/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.font.SMCIDFontType0Font;
import com.plpdf.smmodel.font.SMCIDFontType2Font;
import com.plpdf.smmodel.font.SMFont;
import com.plpdf.smmodel.font.SMMMType1Font;
import com.plpdf.smmodel.font.SMSimpleFont;
import com.plpdf.smmodel.font.SMTrueTypeFont;
import com.plpdf.smmodel.font.SMType0Font;
import com.plpdf.smmodel.font.SMType1Font;
import com.plpdf.smmodel.font.SMType3Font;
import java.io.IOException;
import java.util.Map;

public class SMFontFactory {
    private SMFontFactory() {
    }

    public static SMFont createFont(OMDictionary dic, Map fontCache) throws IOException {
        return SMFontFactory.createFont(dic);
    }

    public static SMFont createFont(OMDictionary dic) throws IOException {
        SMSimpleFont retval = null;
        OMName type = (OMName)dic.getDictionaryObject(OMName.TYPE);
        if (type != null && !OMName.FONT.equals(type)) {
            throw new IOException("Cannot create font if /Type is not /Font.  Actual=" + type);
        }
        OMName subType = (OMName)dic.getDictionaryObject(OMName.SUBTYPE);
        if (subType == null) {
            throw new IOException("Cannot create font as /SubType is not set.");
        }
        retval = subType.equals(OMName.TYPE1) ? new SMType1Font(dic) : (subType.equals(OMName.MM_TYPE1) ? new SMMMType1Font(dic) : (subType.equals(OMName.TRUE_TYPE) ? new SMTrueTypeFont(dic) : (subType.equals(OMName.TYPE3) ? new SMType3Font(dic) : (subType.equals(OMName.TYPE0) ? new SMType0Font(dic) : (subType.equals(OMName.CID_FONT_TYPE0) ? new SMCIDFontType0Font(dic) : (subType.equals(OMName.CID_FONT_TYPE2) ? new SMCIDFontType2Font(dic) : new SMTrueTypeFont(dic)))))));
        return retval;
    }
}

