/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.font.SMFontDescriptor;

public class SMFontDescriptorDictionary
extends SMFontDescriptor
implements OMObjectable {
    private OMDictionary dic;
    private float xHeight = Float.NEGATIVE_INFINITY;
    private float capHeight = Float.NEGATIVE_INFINITY;
    private int flags = -1;

    public SMFontDescriptorDictionary() {
        this.dic = new OMDictionary();
        this.dic.setItem(OMName.TYPE, (OMBase)OMName.FONT_DESC);
    }

    public SMFontDescriptorDictionary(OMDictionary desc) {
        this.dic = desc;
    }

    public OMDictionary getOMDictionary() {
        return this.dic;
    }

    public OMBase getOMObject() {
        return this.dic;
    }

    public String getFontName() {
        String retval = null;
        OMName name = (OMName)this.dic.getDictionaryObject(OMName.FONT_NAME);
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setFontName(String fontName) {
        OMName name = null;
        if (fontName != null) {
            name = OMName.getPDFName(fontName);
        }
        this.dic.setItem(OMName.FONT_NAME, (OMBase)name);
    }

    public String getFontFamily() {
        String retval = null;
        OMString name = (OMString)this.dic.getDictionaryObject(OMName.FONT_FAMILY);
        if (name != null) {
            retval = name.getString();
        }
        return retval;
    }

    public void setFontFamily(String fontFamily) {
        OMString name = null;
        if (fontFamily != null) {
            name = new OMString(fontFamily);
        }
        this.dic.setItem(OMName.FONT_FAMILY, (OMBase)name);
    }

    public float getFontWeight() {
        return this.dic.getFloat(OMName.FONT_WEIGHT, 0.0f);
    }

    public void setFontWeight(float fontWeight) {
        this.dic.setFloat(OMName.FONT_WEIGHT, fontWeight);
    }

    public String getFontStretch() {
        String retval = null;
        OMName name = (OMName)this.dic.getDictionaryObject(OMName.FONT_STRETCH);
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setFontStretch(String fontStretch) {
        OMName name = null;
        if (fontStretch != null) {
            name = OMName.getPDFName(fontStretch);
        }
        this.dic.setItem(OMName.FONT_STRETCH, (OMBase)name);
    }

    public int getFlags() {
        if (this.flags == -1) {
            this.flags = this.dic.getInt(OMName.FLAGS, 0);
        }
        return this.flags;
    }

    public void setFlags(int flags) {
        this.dic.setInt(OMName.FLAGS, flags);
        this.flags = flags;
    }

    public SMRectangle getFontBoundingBox() {
        OMArray rect = (OMArray)this.dic.getDictionaryObject(OMName.FONT_BBOX);
        SMRectangle retval = null;
        if (rect != null) {
            retval = new SMRectangle(rect);
        }
        return retval;
    }

    public void setFontBoundingBox(SMRectangle rect) {
        OMArray array = null;
        if (rect != null) {
            array = rect.getOMArray();
        }
        this.dic.setItem(OMName.FONT_BBOX, (OMBase)array);
    }

    public float getItalicAngle() {
        return this.dic.getFloat(OMName.ITALIC_ANGLE, 0.0f);
    }

    public void setItalicAngle(float angle) {
        this.dic.setFloat(OMName.ITALIC_ANGLE, angle);
    }

    public float getAscent() {
        return this.dic.getFloat(OMName.ASCENT, 0.0f);
    }

    public void setAscent(float ascent) {
        this.dic.setFloat(OMName.ASCENT, ascent);
    }

    public float getDescent() {
        return this.dic.getFloat(OMName.DESCENT, 0.0f);
    }

    public void setDescent(float descent) {
        this.dic.setFloat(OMName.DESCENT, descent);
    }

    public float getLeading() {
        return this.dic.getFloat(OMName.LEADING, 0.0f);
    }

    public void setLeading(float leading) {
        this.dic.setFloat(OMName.LEADING, leading);
    }

    public float getCapHeight() {
        if (this.capHeight == Float.NEGATIVE_INFINITY) {
            this.capHeight = Math.abs(this.dic.getFloat(OMName.CAP_HEIGHT, 0.0f));
        }
        return this.capHeight;
    }

    public void setCapHeight(float capHeight) {
        this.dic.setFloat(OMName.CAP_HEIGHT, capHeight);
        this.capHeight = capHeight;
    }

    public float getXHeight() {
        if (this.xHeight == Float.NEGATIVE_INFINITY) {
            this.xHeight = Math.abs(this.dic.getFloat(OMName.XHEIGHT, 0.0f));
        }
        return this.xHeight;
    }

    public void setXHeight(float xHeight) {
        this.dic.setFloat(OMName.XHEIGHT, xHeight);
        this.xHeight = xHeight;
    }

    public float getStemV() {
        return this.dic.getFloat(OMName.STEM_V, 0.0f);
    }

    public void setStemV(float stemV) {
        this.dic.setFloat(OMName.STEM_V, stemV);
    }

    public float getStemH() {
        return this.dic.getFloat(OMName.STEM_H, 0.0f);
    }

    public void setStemH(float stemH) {
        this.dic.setFloat(OMName.STEM_H, stemH);
    }

    public float getAverageWidth() {
        return this.dic.getFloat(OMName.AVG_WIDTH, 0.0f);
    }

    public void setAverageWidth(float averageWidth) {
        this.dic.setFloat(OMName.AVG_WIDTH, averageWidth);
    }

    public float getMaxWidth() {
        return this.dic.getFloat(OMName.MAX_WIDTH, 0.0f);
    }

    public void setMaxWidth(float maxWidth) {
        this.dic.setFloat(OMName.MAX_WIDTH, maxWidth);
    }

    public float getMissingWidth() {
        return this.dic.getFloat(OMName.MISSING_WIDTH, 0.0f);
    }

    public void setMissingWidth(float missingWidth) {
        this.dic.setFloat(OMName.MISSING_WIDTH, missingWidth);
    }

    public String getCharSet() {
        String retval = null;
        OMString name = (OMString)this.dic.getDictionaryObject(OMName.CHAR_SET);
        if (name != null) {
            retval = name.getString();
        }
        return retval;
    }

    public void setCharacterSet(String charSet) {
        OMString name = null;
        if (charSet != null) {
            name = new OMString(charSet);
        }
        this.dic.setItem(OMName.CHAR_SET, (OMBase)name);
    }

    public SMStream getFontFile() {
        SMStream retval = null;
        OMStream stream = (OMStream)this.dic.getDictionaryObject(OMName.FONT_FILE);
        if (stream != null) {
            retval = new SMStream(stream);
        }
        return retval;
    }

    public void setFontFile(SMStream type1Stream) {
        this.dic.setItem(OMName.FONT_FILE, (OMObjectable)type1Stream);
    }

    public SMStream getFontFile2() {
        SMStream retval = null;
        OMStream stream = (OMStream)this.dic.getDictionaryObject(OMName.FONT_FILE2);
        if (stream != null) {
            retval = new SMStream(stream);
        }
        return retval;
    }

    public void setFontFile2(SMStream ttfStream) {
        this.dic.setItem(OMName.FONT_FILE2, (OMObjectable)ttfStream);
    }

    public SMStream getFontFile3() {
        SMStream retval = null;
        OMStream stream = (OMStream)this.dic.getDictionaryObject(OMName.FONT_FILE3);
        if (stream != null) {
            retval = new SMStream(stream);
        }
        return retval;
    }

    public void setFontFile3(SMStream stream) {
        this.dic.setItem(OMName.FONT_FILE3, (OMObjectable)stream);
    }
}

