/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.smmodel.common.SMRectangle;
import java.io.IOException;

public abstract class SMFontDescriptor {
    private static final int FLAG_FIXED_PITCH = 1;
    private static final int FLAG_SERIF = 2;
    private static final int FLAG_SYMBOLIC = 4;
    private static final int FLAG_SCRIPT = 8;
    private static final int FLAG_NON_SYMBOLIC = 32;
    private static final int FLAG_ITALIC = 64;
    private static final int FLAG_ALL_CAP = 65536;
    private static final int FLAG_SMALL_CAP = 131072;
    private static final int FLAG_FORCE_BOLD = 262144;

    public abstract String getFontName();

    public abstract void setFontName(String var1);

    public abstract String getFontFamily();

    public abstract void setFontFamily(String var1);

    public abstract String getFontStretch();

    public abstract void setFontStretch(String var1);

    public abstract float getFontWeight();

    public abstract void setFontWeight(float var1);

    public abstract int getFlags();

    public abstract void setFlags(int var1);

    public boolean isFixedPitch() {
        return this.isFlagBitOn(1);
    }

    public void setFixedPitch(boolean flag) {
        this.setFlagBit(1, flag);
    }

    public boolean isSerif() {
        return this.isFlagBitOn(2);
    }

    public void setSerif(boolean flag) {
        this.setFlagBit(2, flag);
    }

    public boolean isSymbolic() {
        return this.isFlagBitOn(4);
    }

    public void setSymbolic(boolean flag) {
        this.setFlagBit(4, flag);
    }

    public boolean isScript() {
        return this.isFlagBitOn(8);
    }

    public void setScript(boolean flag) {
        this.setFlagBit(8, flag);
    }

    public boolean isNonSymbolic() {
        return this.isFlagBitOn(32);
    }

    public void setNonSymbolic(boolean flag) {
        this.setFlagBit(32, flag);
    }

    public boolean isItalic() {
        return this.isFlagBitOn(64);
    }

    public void setItalic(boolean flag) {
        this.setFlagBit(64, flag);
    }

    public boolean isAllCap() {
        return this.isFlagBitOn(65536);
    }

    public void setAllCap(boolean flag) {
        this.setFlagBit(65536, flag);
    }

    public boolean isSmallCap() {
        return this.isFlagBitOn(131072);
    }

    public void setSmallCap(boolean flag) {
        this.setFlagBit(131072, flag);
    }

    public boolean isForceBold() {
        return this.isFlagBitOn(262144);
    }

    public void setForceBold(boolean flag) {
        this.setFlagBit(262144, flag);
    }

    private boolean isFlagBitOn(int bit) {
        return (this.getFlags() & bit) != 0;
    }

    private void setFlagBit(int bit, boolean value) {
        int flags = this.getFlags();
        flags = value ? (flags |= bit) : (flags &= 0xFFFFFFFF ^ bit);
        this.setFlags(flags);
    }

    public abstract SMRectangle getFontBoundingBox();

    public abstract void setFontBoundingBox(SMRectangle var1);

    public abstract float getItalicAngle();

    public abstract void setItalicAngle(float var1);

    public abstract float getAscent();

    public abstract void setAscent(float var1);

    public abstract float getDescent();

    public abstract void setDescent(float var1);

    public abstract float getLeading();

    public abstract void setLeading(float var1);

    public abstract float getCapHeight();

    public abstract void setCapHeight(float var1);

    public abstract float getXHeight();

    public abstract void setXHeight(float var1);

    public abstract float getStemV();

    public abstract void setStemV(float var1);

    public abstract float getStemH();

    public abstract void setStemH(float var1);

    public abstract float getAverageWidth() throws IOException;

    public abstract void setAverageWidth(float var1);

    public abstract float getMaxWidth();

    public abstract void setMaxWidth(float var1);

    public abstract String getCharSet();

    public abstract void setCharacterSet(String var1);

    public abstract float getMissingWidth();

    public abstract void setMissingWidth(float var1);
}

