/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.encoding.DictionaryEncoding;
import com.plpdf.encoding.Encoding;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.font.afm.AFMParser;
import com.plpdf.font.afm.FontMetric;
import com.plpdf.font.cmap.CMap;
import com.plpdf.font.cmap.CMapParser;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMMatrix;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.font.SMFontDescriptor;
import com.plpdf.smmodel.font.SMFontDescriptorAFM;
import com.plpdf.smmodel.font.SMFontDescriptorDictionary;
import com.plpdf.util.ResourceLoader;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMFont
implements OMObjectable {
    private static final String CLASS_NAME = SMFont.class.getName();
    protected OMDictionary font;
    private Encoding fontEncoding = null;
    private SMFontDescriptor fontDescriptor = null;
    protected SMMatrix fontMatrix = null;
    protected CMap cmap = null;
    protected CMap toUnicodeCmap = null;
    private boolean hasToUnicode = false;
    protected static Map<String, CMap> cmapObjects = Collections.synchronizedMap(new HashMap());
    private List<Integer> widths = null;
    private static final Map<String, FontMetric> afmObjects = Collections.unmodifiableMap(SMFont.getAdobeFontMetrics());
    protected static final String resourceRootCMAP = "com/plpdf/res/cmap/";
    private static final String resourceRootAFM = "com/plpdf/res/afm/";
    private FontMetric afm = null;
    private OMBase encoding = null;
    private static final String[] SINGLE_CHAR_STRING = new String[256];
    private static final String[][] DOUBLE_CHAR_STRING = new String[256][256];
    private String subtype = null;
    private boolean type1Font;
    private boolean trueTypeFont;
    private boolean typeFont;
    private boolean type0Font;

    static {
        int i = 0;
        while (i < 256) {
            try {
                SMFont.SINGLE_CHAR_STRING[i] = new String(new byte[]{(byte)i}, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            int j = 0;
            while (j < 256) {
                try {
                    SMFont.DOUBLE_CHAR_STRING[i][j] = new String(new byte[]{(byte)i, (byte)j}, "UTF-16BE");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
    }

    private static Map<String, FontMetric> getAdobeFontMetrics() {
        HashMap<String, FontMetric> metrics = new HashMap<String, FontMetric>();
        SMFont.addAdobeFontMetric(metrics, "Courier-Bold");
        SMFont.addAdobeFontMetric(metrics, "Courier-BoldOblique");
        SMFont.addAdobeFontMetric(metrics, "Courier");
        SMFont.addAdobeFontMetric(metrics, "Courier-Oblique");
        SMFont.addAdobeFontMetric(metrics, "Helvetica");
        SMFont.addAdobeFontMetric(metrics, "Helvetica-Bold");
        SMFont.addAdobeFontMetric(metrics, "Helvetica-BoldOblique");
        SMFont.addAdobeFontMetric(metrics, "Helvetica-Oblique");
        SMFont.addAdobeFontMetric(metrics, "Symbol");
        SMFont.addAdobeFontMetric(metrics, "Times-Bold");
        SMFont.addAdobeFontMetric(metrics, "Times-BoldItalic");
        SMFont.addAdobeFontMetric(metrics, "Times-Italic");
        SMFont.addAdobeFontMetric(metrics, "Times-Roman");
        SMFont.addAdobeFontMetric(metrics, "ZapfDingbats");
        return metrics;
    }

    private static void addAdobeFontMetric(Map<String, FontMetric> metrics, String name) {
        block5: {
            try {
                String resource = resourceRootAFM + name + ".afm";
                InputStream afmStream = ResourceLoader.loadResource(resource);
                if (afmStream == null) break block5;
                try {
                    AFMParser parser = new AFMParser(afmStream);
                    parser.parse();
                    metrics.put(name, parser.getResult());
                }
                finally {
                    afmStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void clearResources() {
        cmapObjects.clear();
    }

    public SMFont() {
        this.font = new OMDictionary();
        this.font.setItem(OMName.TYPE, (OMBase)OMName.FONT);
    }

    public SMFont(OMDictionary fontDictionary) {
        this.font = fontDictionary;
        this.determineEncoding();
    }

    public SMFontDescriptor getFontDescriptor() {
        if (this.fontDescriptor == null) {
            OMDictionary fd = (OMDictionary)this.font.getDictionaryObject(OMName.FONT_DESC);
            if (fd != null) {
                this.fontDescriptor = new SMFontDescriptorDictionary(fd);
            } else {
                this.getAFM();
                if (this.afm != null) {
                    this.fontDescriptor = new SMFontDescriptorAFM(this.afm);
                }
            }
        }
        return this.fontDescriptor;
    }

    public void setFontDescriptor(SMFontDescriptorDictionary fdDictionary) {
        OMDictionary dic = null;
        if (fdDictionary != null) {
            dic = fdDictionary.getOMDictionary();
        }
        this.font.setItem(OMName.FONT_DESC, (OMBase)dic);
        this.fontDescriptor = fdDictionary;
    }

    protected abstract void determineEncoding();

    @Override
    public OMBase getOMObject() {
        return this.font;
    }

    public abstract float getFontWidth(byte[] var1, int var2, int var3) throws IOException;

    public abstract float getFontHeight(byte[] var1, int var2, int var3) throws IOException;

    public float getStringWidth(String string) throws IOException {
        byte[] data = string.getBytes("ISO-8859-1");
        float totalWidth = 0.0f;
        int i = 0;
        while (i < data.length) {
            totalWidth += this.getFontWidth(data, i, 1);
            ++i;
        }
        return totalWidth;
    }

    public abstract float getAverageFontWidth() throws IOException;

    public void drawString(String string, Graphics g, float fontSize, AffineTransform at, float x, float y) throws Exception {
        this.drawString(string, null, g, fontSize, at, x, y);
    }

    public abstract void drawString(String var1, int[] var2, Graphics var3, float var4, AffineTransform var5, float var6, float var7) throws IOException, Exception;

    public int getCodeFromArray(byte[] data, int offset, int length) {
        int code = 0;
        int i = 0;
        while (i < length) {
            code <<= 8;
            code |= (data[offset + i] + 256) % 256;
            ++i;
        }
        return code;
    }

    protected float getFontWidthFromAFMFile(int code) throws IOException {
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            String characterName = this.fontEncoding.getName(code);
            retval = metric.getCharacterWidth(characterName);
        }
        return retval;
    }

    protected float getAverageFontWidthFromAFMFile() throws IOException {
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            retval = metric.getAverageCharacterWidth();
        }
        return retval;
    }

    protected FontMetric getAFM() {
        if (this.isType1Font() && this.afm == null) {
            OMBase baseFont = this.font.getDictionaryObject(OMName.BASE_FONT);
            String name = null;
            if (baseFont instanceof OMName) {
                name = ((OMName)baseFont).getName();
                if (name.indexOf("+") > -1) {
                    name = name.substring(name.indexOf("+") + 1);
                }
            } else if (baseFont instanceof OMString) {
                OMString string = (OMString)baseFont;
                name = string.getString();
            }
            if (name != null) {
                this.afm = afmObjects.get(name);
            }
        }
        return this.afm;
    }

    protected OMBase getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.font.getDictionaryObject(OMName.ENCODING);
        }
        return this.encoding;
    }

    protected void setEncoding(OMBase encodingValue) {
        this.font.setItem(OMName.ENCODING, encodingValue);
        this.encoding = encodingValue;
    }

    protected String cmapEncoding(int code, int length, boolean isCIDFont, CMap sourceCmap) throws IOException {
        String retval = null;
        if (sourceCmap == null) {
            sourceCmap = this.cmap;
        }
        if (sourceCmap != null && (retval = sourceCmap.lookup(code, length)) == null && isCIDFont) {
            retval = sourceCmap.lookupCID(code);
        }
        return retval;
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        String retval = null;
        int code = this.getCodeFromArray(c, offset, length);
        if (this.toUnicodeCmap != null) {
            retval = this.cmapEncoding(code, length, false, this.toUnicodeCmap);
        }
        if (retval == null && this.cmap != null) {
            retval = this.cmapEncoding(code, length, false, this.cmap);
        }
        if (retval == null) {
            if (this.fontEncoding != null) {
                retval = this.fontEncoding.getCharacter(code);
            }
            if (retval == null && (this.cmap == null || length == 2)) {
                retval = SMFont.getStringFromArray(c, offset, length);
            }
        }
        return retval;
    }

    public int encodeToCID(byte[] c, int offset, int length) throws IOException {
        int code = -1;
        if (this.encode(c, offset, length) != null) {
            code = this.getCodeFromArray(c, offset, length);
        }
        return code;
    }

    private static String getStringFromArray(byte[] c, int offset, int length) throws IOException {
        String retval = null;
        if (length == 1) {
            retval = SINGLE_CHAR_STRING[(c[offset] + 256) % 256];
        } else if (length == 2) {
            retval = DOUBLE_CHAR_STRING[(c[offset] + 256) % 256][(c[offset + 1] + 256) % 256];
        } else {
            throw new IOException("Error:Unknown character length:" + length);
        }
        return retval;
    }

    protected CMap parseCmap(String cmapRoot, InputStream cmapStream) {
        CMap targetCmap = null;
        if (cmapStream != null) {
            CMapParser parser = new CMapParser();
            try {
                targetCmap = parser.parse(cmapRoot, cmapStream);
                if (cmapRoot != null) {
                    cmapObjects.put(targetCmap.getName(), targetCmap);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return targetCmap;
    }

    public void setFontEncoding(Encoding enc) {
        this.fontEncoding = enc;
    }

    public Encoding getFontEncoding() {
        return this.fontEncoding;
    }

    public String getType() {
        return this.font.getNameAsString(OMName.TYPE);
    }

    public String getSubType() {
        if (this.subtype == null) {
            this.subtype = this.font.getNameAsString(OMName.SUBTYPE);
            this.type1Font = "Type1".equals(this.subtype);
            this.trueTypeFont = "TrueType".equals(this.subtype);
            this.type0Font = "Type0".equals(this.subtype);
            this.typeFont = this.type1Font || "Type0".equals(this.subtype) || this.trueTypeFont;
        }
        return this.subtype;
    }

    protected boolean isType1Font() {
        this.getSubType();
        return this.type1Font;
    }

    protected boolean isType0Font() {
        this.getSubType();
        return this.type0Font;
    }

    private boolean isTrueTypeFont() {
        this.getSubType();
        return this.trueTypeFont;
    }

    public boolean isSymbolicFont() {
        if (this.getFontDescriptor() != null) {
            return this.getFontDescriptor().isSymbolic();
        }
        return false;
    }

    private boolean isTypeFont() {
        this.getSubType();
        return this.typeFont;
    }

    public String getBaseFont() {
        return this.font.getNameAsString(OMName.BASE_FONT);
    }

    public void setBaseFont(String baseFont) {
        this.font.setName(OMName.BASE_FONT, baseFont);
    }

    public int getFirstChar() {
        return this.font.getInt(OMName.FIRST_CHAR, -1);
    }

    public void setFirstChar(int firstChar) {
        this.font.setInt(OMName.FIRST_CHAR, firstChar);
    }

    public int getLastChar() {
        return this.font.getInt(OMName.LAST_CHAR, -1);
    }

    public void setLastChar(int lastChar) {
        this.font.setInt(OMName.LAST_CHAR, lastChar);
    }

    public List<Integer> getWidths() {
        OMArray array;
        if (this.widths == null && (array = (OMArray)this.font.getDictionaryObject(OMName.WIDTHS)) != null) {
            this.widths = OMArrayList.convertIntegerOMArrayToList(array);
        }
        return this.widths;
    }

    public void setWidths(List<Integer> widthsList) throws IOException {
        this.widths = widthsList;
        this.font.setItem(OMName.WIDTHS, (OMBase)OMArrayList.converterToOMArray(this.widths));
    }

    public SMMatrix getFontMatrix() {
        if (this.fontMatrix == null) {
            OMArray array = (OMArray)this.font.getDictionaryObject(OMName.FONT_MATRIX);
            if (array == null) {
                array = new OMArray();
                array.add(new OMFloat(0.001f));
                array.add(OMInteger.ZERO);
                array.add(OMInteger.ZERO);
                array.add(new OMFloat(0.001f));
                array.add(OMInteger.ZERO);
                array.add(OMInteger.ZERO);
            }
            this.fontMatrix = new SMMatrix(array);
        }
        return this.fontMatrix;
    }

    public abstract SMRectangle getFontBoundingBox() throws IOException;

    public boolean equals(Object other) {
        return other instanceof SMFont && ((SMFont)other).getOMObject() == this.getOMObject();
    }

    public int hashCode() {
        return this.getOMObject().hashCode();
    }

    public float getFontWidth(int charCode) {
        float width = -1.0f;
        int firstChar = this.getFirstChar();
        int lastChar = this.getLastChar();
        if (charCode >= firstChar && charCode <= lastChar) {
            this.getWidths();
            if (this.widths != null) {
                width = this.widths.get(charCode - firstChar).floatValue();
            }
        } else {
            SMFontDescriptor fd = this.getFontDescriptor();
            if (fd instanceof SMFontDescriptorDictionary) {
                width = fd.getMissingWidth();
            }
        }
        return width;
    }

    protected boolean hasToUnicode() {
        return this.hasToUnicode;
    }

    protected void setHasToUnicode(boolean hasToUnicodeValue) {
        this.hasToUnicode = hasToUnicodeValue;
    }

    public abstract float getSpaceWidth();

    public void setEncoding(Encoding enc) {
        this.font.setItem(OMName.ENCODING, (OMObjectable)enc);
        this.fontEncoding = enc;
    }

    public void setEncodingDiffs(String encoding, String font) throws IOException, PlpdfException {
        int c;
        OMDictionary omd = new OMDictionary();
        OMArray tags = new OMArray();
        OMArray widths = new OMArray();
        tags.add(0, OMName.getPDFName(""));
        tags.set(0, 0);
        int i = 1;
        while (i <= 256) {
            tags.add(i, OMName.getPDFName(".notdef"));
            ++i;
        }
        i = 32;
        while (i <= 255) {
            widths.add(i - 32, OMInteger.get("0"));
            ++i;
        }
        String res_path = "com/plpdf/res/maps/" + encoding.toLowerCase() + ".map";
        InputStream maps = ResourceLoader.loadResource(res_path);
        String afm_path = resourceRootAFM + font + ".afm";
        InputStream afm_stream = ResourceLoader.loadResource(afm_path);
        AFMParser afmparser = new AFMParser(afm_stream);
        afmparser.parse();
        FontMetric fontMetric = afmparser.getResult();
        StringBuffer sb = new StringBuffer();
        int ind = 0;
        while ((c = maps.read()) >= 0) {
            if (c != 10) {
                sb.append((char)c);
                continue;
            }
            String[] linearray = sb.toString().split(" ");
            if (linearray.length < 3) {
                throw new PlpdfException(CLASS_NAME, "InvalidFontMapLine");
            }
            try {
                ind = Integer.parseInt(linearray[0].substring(1), 16);
            }
            catch (NumberFormatException e) {
                throw new PlpdfException(CLASS_NAME, "InvalidFontMapLine", new String[]{linearray[0].substring(1)});
            }
            tags.set(ind + 1, OMName.getPDFName(linearray[2]));
            if (ind >= 32 && ind <= 255) {
                widths.set(ind - 32, (int)fontMetric.getCharacterWidth(linearray[2]));
            }
            sb.delete(0, sb.length());
        }
        omd.setName("Type", "Encoding");
        omd.setItem(OMName.DIFFERENCES, (OMBase)tags);
        DictionaryEncoding enc = new DictionaryEncoding(omd);
        this.setEncoding(enc);
        this.setFirstChar(32);
        this.setLastChar(255);
        this.setWidths(widths);
    }

    public void setWidths(OMArray widths) {
        this.font.setItem(OMName.WIDTHS, (OMBase)widths);
    }

    public CMap getCMap() {
        return this.cmap;
    }
}

