/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.io.IOUtils;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.font.FontManager;
import com.plpdf.smmodel.font.SMCIDFont;
import com.plpdf.smmodel.font.SMFontDescriptorDictionary;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;

public class SMCIDFontType2Font
extends SMCIDFont {
    private Boolean hasCIDToGIDMap = null;
    private Boolean hasIdentityCIDToGIDMap = null;
    private int[] cid2gid = null;

    public SMCIDFontType2Font() {
        this.font.setItem(OMName.SUBTYPE, (OMBase)OMName.CID_FONT_TYPE2);
    }

    public SMCIDFontType2Font(OMDictionary fontDictionary) {
        super(fontDictionary);
    }

    public Font getawtFont() throws IOException {
        Font awtFont = null;
        SMFontDescriptorDictionary fd = (SMFontDescriptorDictionary)this.getFontDescriptor();
        SMStream ff2Stream = fd.getFontFile2();
        if (ff2Stream != null) {
            try {
                awtFont = Font.createFont(0, ff2Stream.createInputStream());
            }
            catch (FontFormatException fontFormatException) {
                // empty catch block
            }
            if (awtFont == null) {
                awtFont = FontManager.getAwtFont(fd.getFontName());
                this.setIsFontSubstituted(true);
            }
        }
        return awtFont;
    }

    private void readCIDToGIDMapping() {
        OMBase map = this.font.getDictionaryObject(OMName.CID_TO_GID_MAP);
        if (map instanceof OMStream) {
            OMStream stream = (OMStream)map;
            try {
                byte[] mapAsBytes = IOUtils.toByteArray(stream.getUnfilteredStream());
                int numberOfInts = mapAsBytes.length / 2;
                this.cid2gid = new int[numberOfInts];
                int offset = 0;
                int index = 0;
                while (index < numberOfInts) {
                    this.cid2gid[index] = this.getCodeFromArray(mapAsBytes, offset, 2);
                    offset += 2;
                    ++index;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean hasCIDToGIDMap() {
        if (this.hasCIDToGIDMap == null) {
            OMBase map = this.font.getDictionaryObject(OMName.CID_TO_GID_MAP);
            this.hasCIDToGIDMap = map != null && map instanceof OMStream ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.hasCIDToGIDMap;
    }

    public boolean hasIdentityCIDToGIDMap() {
        if (this.hasIdentityCIDToGIDMap == null) {
            OMBase map = this.font.getDictionaryObject(OMName.CID_TO_GID_MAP);
            this.hasIdentityCIDToGIDMap = map != null && map instanceof OMName ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.hasIdentityCIDToGIDMap;
    }

    public int mapCIDToGID(int cid) {
        if (this.hasCIDToGIDMap()) {
            if (this.cid2gid == null) {
                this.readCIDToGIDMapping();
            }
            if (this.cid2gid != null && cid < this.cid2gid.length) {
                return this.cid2gid[cid];
            }
            return -1;
        }
        return cid;
    }
}

