/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.font.cmap.CMap;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.font.SMFontDescriptor;
import com.plpdf.smmodel.font.SMSimpleFont;
import com.plpdf.util.ResourceLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class SMCIDFont
extends SMSimpleFont {
    private Map<Integer, Float> widthCache = null;
    private long defaultWidth = 0L;

    public SMCIDFont() {
    }

    public SMCIDFont(OMDictionary fontDictionary) {
        super(fontDictionary);
        this.extractWidths();
    }

    public SMRectangle getFontBoundingBox() throws IOException {
        throw new RuntimeException("getFontBoundingBox(): Not yet implemented");
    }

    public long getDefaultWidth() {
        if (this.defaultWidth == 0L) {
            OMNumber number = (OMNumber)this.font.getDictionaryObject(OMName.DW);
            this.defaultWidth = number != null ? (long)number.intValue() : 1000L;
        }
        return this.defaultWidth;
    }

    public void setDefaultWidth(long dw) {
        this.defaultWidth = dw;
        this.font.setLong(OMName.DW, dw);
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        float retval = this.getDefaultWidth();
        int code = this.getCodeFromArray(c, offset, length);
        Float widthFloat = this.widthCache.get(code);
        if (widthFloat != null) {
            retval = widthFloat.floatValue();
        }
        return retval;
    }

    private void extractWidths() {
        if (this.widthCache == null) {
            this.widthCache = new HashMap<Integer, Float>();
            OMArray widths = (OMArray)this.font.getDictionaryObject(OMName.W);
            if (widths != null) {
                int size = widths.size();
                int counter = 0;
                while (counter < size) {
                    OMBase next;
                    OMNumber firstCode = (OMNumber)widths.getObject(counter++);
                    if ((next = widths.getObject(counter++)) instanceof OMArray) {
                        OMArray array = (OMArray)next;
                        int startRange = firstCode.intValue();
                        int arraySize = array.size();
                        int i = 0;
                        while (i < arraySize) {
                            OMNumber width = (OMNumber)array.get(i);
                            this.widthCache.put(startRange + i, Float.valueOf(width.floatValue()));
                            ++i;
                        }
                        continue;
                    }
                    OMNumber secondCode = (OMNumber)next;
                    OMNumber rangeWidth = (OMNumber)widths.getObject(counter++);
                    int startRange = firstCode.intValue();
                    int endRange = secondCode.intValue();
                    float width = rangeWidth.floatValue();
                    int i = startRange;
                    while (i <= endRange) {
                        this.widthCache.put(i, Float.valueOf(width));
                        ++i;
                    }
                }
            }
        }
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        float retval = 0.0f;
        SMFontDescriptor desc = this.getFontDescriptor();
        float xHeight = desc.getXHeight();
        float capHeight = desc.getCapHeight();
        retval = xHeight != 0.0f && capHeight != 0.0f ? (xHeight + capHeight) / 2.0f : (xHeight != 0.0f ? xHeight : (capHeight != 0.0f ? capHeight : 0.0f));
        if (retval == 0.0f) {
            retval = desc.getAscent();
        }
        return retval;
    }

    public float getAverageFontWidth() throws IOException {
        float average;
        float totalWidths = 0.0f;
        float characterCount = 0.0f;
        float defaultWidth = this.getDefaultWidth();
        OMArray widths = (OMArray)this.font.getDictionaryObject(OMName.W);
        if (widths != null) {
            int i = 0;
            while (i < widths.size()) {
                OMNumber rangeWidth;
                OMNumber firstCode = (OMNumber)widths.getObject(i++);
                OMBase next = widths.getObject(i);
                if (next instanceof OMArray) {
                    OMArray array = (OMArray)next;
                    int j = 0;
                    while (j < array.size()) {
                        OMNumber width = (OMNumber)array.get(j);
                        totalWidths += width.floatValue();
                        characterCount += 1.0f;
                        ++j;
                    }
                } else if ((rangeWidth = (OMNumber)widths.getObject(++i)).floatValue() > 0.0f) {
                    totalWidths += rangeWidth.floatValue();
                    characterCount += 1.0f;
                }
                ++i;
            }
        }
        if ((average = totalWidths / characterCount) <= 0.0f) {
            average = defaultWidth;
        }
        return average;
    }

    public float getFontWidth(int charCode) {
        float width = -1.0f;
        if (this.widthCache.containsKey(charCode)) {
            width = this.widthCache.get(charCode).floatValue();
        }
        return width;
    }

    private String getCIDSystemInfo() {
        String cidSystemInfo = null;
        OMDictionary cidsysteminfo = (OMDictionary)this.font.getDictionaryObject(OMName.CIDSYSTEMINFO);
        if (cidsysteminfo != null) {
            String ordering = cidsysteminfo.getString(OMName.ORDERING);
            String registry = cidsysteminfo.getString(OMName.REGISTRY);
            int supplement = cidsysteminfo.getInt(OMName.SUPPLEMENT);
            cidSystemInfo = String.valueOf(registry) + "-" + ordering + "-" + supplement;
        }
        return cidSystemInfo;
    }

    protected void determineEncoding() {
        String cidSystemInfo = this.getCIDSystemInfo();
        if (cidSystemInfo != null) {
            cidSystemInfo = cidSystemInfo.contains("Identity") ? "Identity-H" : (cidSystemInfo.startsWith("Adobe-UCS-") ? "Adobe-Identity-UCS" : String.valueOf(cidSystemInfo.substring(0, cidSystemInfo.lastIndexOf("-"))) + "-UCS2");
            this.cmap = (CMap)cmapObjects.get(cidSystemInfo);
            if (this.cmap == null) {
                String resourceName = "com/plpdf/res/cmap/" + cidSystemInfo;
                try {
                    this.cmap = this.parseCmap("com/plpdf/res/cmap/", ResourceLoader.loadResource(resourceName));
                }
                catch (IOException iOException) {}
            }
        } else {
            super.determineEncoding();
        }
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        String result = null;
        result = this.cmap != null ? this.cmapEncoding(this.getCodeFromArray(c, offset, length), length, true, this.cmap) : super.encode(c, offset, length);
        return result;
    }
}

