/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.fdf;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRange;

public class FDFIconFit
implements OMObjectable {
    private OMDictionary fit;
    public static final String SCALE_OPTION_ALWAYS = "A";
    public static final String SCALE_OPTION_ONLY_WHEN_ICON_IS_BIGGER = "B";
    public static final String SCALE_OPTION_ONLY_WHEN_ICON_IS_SMALLER = "S";
    public static final String SCALE_OPTION_NEVER = "N";
    public static final String SCALE_TYPE_ANAMORPHIC = "A";
    public static final String SCALE_TYPE_PROPORTIONAL = "P";

    public FDFIconFit() {
        this.fit = new OMDictionary();
    }

    public FDFIconFit(OMDictionary f) {
        this.fit = f;
    }

    public OMBase getOMObject() {
        return this.fit;
    }

    public OMDictionary getOMDictionary() {
        return this.fit;
    }

    public String getScaleOption() {
        String retval = this.fit.getNameAsString("SW");
        if (retval == null) {
            retval = "A";
        }
        return retval;
    }

    public void setScaleOption(String option) {
        this.fit.setName("SW", option);
    }

    public String getScaleType() {
        String retval = this.fit.getNameAsString(SCALE_OPTION_ONLY_WHEN_ICON_IS_SMALLER);
        if (retval == null) {
            retval = SCALE_TYPE_PROPORTIONAL;
        }
        return retval;
    }

    public void setScaleType(String scale) {
        this.fit.setName(SCALE_OPTION_ONLY_WHEN_ICON_IS_SMALLER, scale);
    }

    public SMRange getFractionalSpaceToAllocate() {
        SMRange retval = null;
        OMArray array = (OMArray)this.fit.getDictionaryObject("A");
        if (array == null) {
            retval = new SMRange();
            retval.setMin(0.5f);
            retval.setMax(0.5f);
            this.setFractionalSpaceToAllocate(retval);
        } else {
            retval = new SMRange(array);
        }
        return retval;
    }

    public void setFractionalSpaceToAllocate(SMRange space) {
        this.fit.setItem("A", (OMObjectable)space);
    }

    public boolean shouldScaleToFitAnnotation() {
        return this.fit.getBoolean("FB", false);
    }

    public void setScaleToFitAnnotation(boolean value) {
        this.fit.setBoolean("FB", value);
    }
}

