/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.fdf;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMTextStream;
import com.plpdf.smmodel.fdf.FDFIconFit;
import com.plpdf.smmodel.fdf.FDFNamedPageReference;
import com.plpdf.smmodel.fdf.FDFOptionElement;
import com.plpdf.smmodel.interactive.action.SMActionFactory;
import com.plpdf.smmodel.interactive.action.SMAdditionalActions;
import com.plpdf.smmodel.interactive.action.type.SMAction;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceDictionary;
import com.plpdf.util.XMLUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FDFField
implements OMObjectable {
    private static final String CLASS_NAME = FDFField.class.getName();
    private static final String FIELD_TYPE_BTN = "Btn";
    private static final String FIELD_TYPE_TX = "Tx";
    private static final String FIELD_TYPE_CH = "Ch";
    private static final String FIELD_TYPE_SIG = "Sig";
    private OMDictionary field;

    public FDFField() {
        this.field = new OMDictionary();
    }

    public FDFField(OMDictionary f) {
        this.field = f;
    }

    public FDFField(Element fieldXML) throws IOException, PlpdfException {
        this();
        this.setPartialFieldName(fieldXML.getAttribute("name"));
        NodeList nodeList = fieldXML.getChildNodes();
        ArrayList<FDFField> kids = new ArrayList<FDFField>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element child = (Element)node;
                if (child.getTagName().equals("value")) {
                    this.setValue(XMLUtil.getNodeValue(child));
                } else if (child.getTagName().equals("value-richtext")) {
                    this.setRichText(new SMTextStream(XMLUtil.getNodeValue(child)));
                } else if (child.getTagName().equals("field")) {
                    kids.add(new FDFField(child));
                }
            }
            ++i;
        }
        if (kids.size() > 0) {
            this.setKids(kids);
        }
    }

    public void writeXML(Writer output) throws IOException {
        List<FDFField> kids;
        SMTextStream rt;
        output.write("<field name=\"" + this.getPartialFieldName() + "\">\n");
        Object value = this.getValue();
        if (value != null) {
            if (value instanceof SMTextStream) {
                output.write("<value>" + this.escapeXML(((SMTextStream)value).getAsString()) + "</value>\n");
            } else {
                output.write("<value>" + this.escapeXML((String)value) + "</value>\n");
            }
        }
        if ((rt = this.getRichText()) != null) {
            output.write("<value-richtext>" + this.escapeXML(rt.getAsString()) + "</value-richtext>\n");
        }
        if ((kids = this.getKids()) != null) {
            int i = 0;
            while (i < kids.size()) {
                kids.get(i).writeXML(output);
                ++i;
            }
        }
        output.write("</field>\n");
    }

    @Override
    public OMBase getOMObject() {
        return this.field;
    }

    public OMDictionary getOMDictionary() {
        return this.field;
    }

    public List<FDFField> getKids() {
        OMArray kids = (OMArray)this.field.getDictionaryObject(OMName.KIDS);
        OMArrayList retval = null;
        if (kids != null) {
            ArrayList<FDFField> actuals = new ArrayList<FDFField>();
            int i = 0;
            while (i < kids.size()) {
                actuals.add(new FDFField((OMDictionary)kids.getObject(i)));
                ++i;
            }
            retval = new OMArrayList(actuals, kids);
        }
        return retval;
    }

    public void setKids(List<FDFField> kids) {
        this.field.setItem(OMName.KIDS, (OMBase)OMArrayList.converterToOMArray(kids));
    }

    public String getPartialFieldName() {
        return this.field.getString(OMName.T);
    }

    public void setPartialFieldName(String partial) throws IOException {
        this.field.setString(OMName.T, partial);
    }

    public Object getValue() throws IOException {
        Object retval = null;
        OMBase value = this.field.getDictionaryObject(OMName.V);
        if (value instanceof OMName) {
            retval = ((OMName)value).getName();
        } else if (value instanceof OMArray) {
            retval = OMArrayList.convertOMStringOMArrayToList((OMArray)value);
        } else if (value instanceof OMString || value instanceof OMStream) {
            retval = SMTextStream.createTextStream(value);
        } else if (value != null) {
            throw new IOException("Error:Unknown type for field import" + value);
        }
        return retval;
    }

    public void setValue(Object value, String fieldtype) throws IOException, PlpdfException {
        OMBase om = null;
        if (value instanceof List) {
            om = OMArrayList.convertStringListToOMStringOMArray((List)value);
        } else if (value instanceof String) {
            om = fieldtype != null && fieldtype.equalsIgnoreCase(FIELD_TYPE_TX) ? new OMString((String)value) : OMName.getPDFName((String)value);
        } else if (value instanceof OMObjectable) {
            om = ((OMObjectable)value).getOMObject();
        } else if (value != null) {
            throw new PlpdfException(CLASS_NAME, "UnknownImportType", new String[]{value.getClass().getName()});
        }
        this.field.setItem("V", om);
    }

    public void setValue(Object value) throws IOException, PlpdfException {
        this.setValue(value, null);
    }

    public Integer getFieldFlags() {
        Integer retval = null;
        OMNumber ff = (OMNumber)this.field.getDictionaryObject(OMName.FF);
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setFieldFlags(Integer ff) {
        OMInteger value = null;
        if (ff != null) {
            value = OMInteger.get(ff.intValue());
        }
        this.field.setItem(OMName.FF, (OMBase)value);
    }

    public void setFieldFlags(int ff) {
        this.field.setInt(OMName.FF, ff);
    }

    public Integer getSetFieldFlags() {
        Integer retval = null;
        OMNumber ff = (OMNumber)this.field.getDictionaryObject(OMName.SET_FF);
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setSetFieldFlags(Integer ff) {
        OMInteger value = null;
        if (ff != null) {
            value = OMInteger.get(ff.intValue());
        }
        this.field.setItem(OMName.SET_FF, (OMBase)value);
    }

    public void setSetFieldFlags(int ff) {
        this.field.setInt(OMName.SET_FF, ff);
    }

    public Integer getClearFieldFlags() {
        Integer retval = null;
        OMNumber ff = (OMNumber)this.field.getDictionaryObject(OMName.CLR_FF);
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setClearFieldFlags(Integer ff) {
        OMInteger value = null;
        if (ff != null) {
            value = OMInteger.get(ff.intValue());
        }
        this.field.setItem(OMName.CLR_FF, (OMBase)value);
    }

    public void setClearFieldFlags(int ff) {
        this.field.setInt(OMName.CLR_FF, ff);
    }

    public Integer getWidgetFieldFlags() {
        Integer retval = null;
        OMNumber f = (OMNumber)this.field.getDictionaryObject("F");
        if (f != null) {
            retval = new Integer(f.intValue());
        }
        return retval;
    }

    public void setWidgetFieldFlags(Integer f) {
        OMInteger value = null;
        if (f != null) {
            value = OMInteger.get(f.intValue());
        }
        this.field.setItem(OMName.F, (OMBase)value);
    }

    public void setWidgetFieldFlags(int f) {
        this.field.setInt(OMName.F, f);
    }

    public Integer getSetWidgetFieldFlags() {
        Integer retval = null;
        OMNumber ff = (OMNumber)this.field.getDictionaryObject(OMName.SET_F);
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setSetWidgetFieldFlags(Integer ff) {
        OMInteger value = null;
        if (ff != null) {
            value = OMInteger.get(ff.intValue());
        }
        this.field.setItem(OMName.SET_F, (OMBase)value);
    }

    public void setSetWidgetFieldFlags(int ff) {
        this.field.setInt(OMName.SET_F, ff);
    }

    public Integer getClearWidgetFieldFlags() {
        Integer retval = null;
        OMNumber ff = (OMNumber)this.field.getDictionaryObject(OMName.CLR_F);
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setClearWidgetFieldFlags(Integer ff) {
        OMInteger value = null;
        if (ff != null) {
            value = OMInteger.get(ff.intValue());
        }
        this.field.setItem(OMName.CLR_F, (OMBase)value);
    }

    public void setClearWidgetFieldFlags(int ff) {
        this.field.setInt(OMName.CLR_F, ff);
    }

    public SMAppearanceDictionary getAppearanceDictionary() {
        SMAppearanceDictionary retval = null;
        OMDictionary dict = (OMDictionary)this.field.getDictionaryObject(OMName.AP);
        if (dict != null) {
            retval = new SMAppearanceDictionary(dict);
        }
        return retval;
    }

    public void setAppearanceDictionary(SMAppearanceDictionary ap) {
        this.field.setItem(OMName.AP, (OMObjectable)ap);
    }

    public FDFNamedPageReference getAppearanceStreamReference() {
        FDFNamedPageReference retval = null;
        OMDictionary ref = (OMDictionary)this.field.getDictionaryObject(OMName.AP_REF);
        if (ref != null) {
            retval = new FDFNamedPageReference(ref);
        }
        return retval;
    }

    public void setAppearanceStreamReference(FDFNamedPageReference ref) {
        this.field.setItem(OMName.AP_REF, (OMObjectable)ref);
    }

    public FDFIconFit getIconFit() {
        FDFIconFit retval = null;
        OMDictionary dic = (OMDictionary)this.field.getDictionaryObject("IF");
        if (dic != null) {
            retval = new FDFIconFit(dic);
        }
        return retval;
    }

    public void setIconFit(FDFIconFit fit) {
        this.field.setItem("IF", (OMObjectable)fit);
    }

    public List getOptions() {
        OMArrayList retval = null;
        OMArray array = (OMArray)this.field.getDictionaryObject(OMName.OPT);
        if (array != null) {
            ArrayList<Object> objects = new ArrayList<Object>();
            int i = 0;
            while (i < array.size()) {
                OMBase next = array.getObject(i);
                if (next instanceof OMString) {
                    objects.add(((OMString)next).getString());
                } else {
                    OMArray value = (OMArray)next;
                    objects.add(new FDFOptionElement(value));
                }
                ++i;
            }
            retval = new OMArrayList(objects, array);
        }
        return retval;
    }

    public void setOptions(List options) {
        OMArray value = OMArrayList.converterToOMArray(options);
        this.field.setItem(OMName.OPT, (OMBase)value);
    }

    public SMAction getAction() {
        return SMActionFactory.createAction((OMDictionary)this.field.getDictionaryObject(OMName.A));
    }

    public void setAction(SMAction a) {
        this.field.setItem(OMName.A, (OMObjectable)a);
    }

    public SMAdditionalActions getAdditionalActions() {
        SMAdditionalActions retval = null;
        OMDictionary dict = (OMDictionary)this.field.getDictionaryObject(OMName.AA);
        if (dict != null) {
            retval = new SMAdditionalActions(dict);
        }
        return retval;
    }

    public void setAdditionalActions(SMAdditionalActions aa) {
        this.field.setItem(OMName.AA, (OMObjectable)aa);
    }

    public SMTextStream getRichText() {
        OMBase rv = this.field.getDictionaryObject(OMName.RV);
        return SMTextStream.createTextStream(rv);
    }

    public void setRichText(SMTextStream rv) {
        this.field.setItem(OMName.RV, (OMObjectable)rv);
    }

    private String escapeXML(String input) {
        StringBuilder escapedXML = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case '<': {
                    escapedXML.append("&lt;");
                    break;
                }
                case '>': {
                    escapedXML.append("&gt;");
                    break;
                }
                case '\"': {
                    escapedXML.append("&quot;");
                    break;
                }
                case '&': {
                    escapedXML.append("&amp;");
                    break;
                }
                case '\'': {
                    escapedXML.append("&apos;");
                    break;
                }
                default: {
                    if (c > '~') {
                        escapedXML.append("&#" + c + ";");
                        break;
                    }
                    escapedXML.append(c);
                }
            }
            ++i;
        }
        return escapedXML.toString();
    }
}

