/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.fdf;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMName;
import com.plpdf.pdfparser.PDFParser;
import com.plpdf.pdfwriter.OMWriter;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.fdf.FDFCatalog;
import com.plpdf.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FDFDocument {
    private OMDocument document;

    public FDFDocument() throws IOException {
        this.document = new OMDocument();
        this.document.setHeaderString("%FDF-1.2");
        this.document.setTrailer(new OMDictionary());
        FDFCatalog catalog = new FDFCatalog();
        this.setCatalog(catalog);
    }

    public FDFDocument(OMDocument doc) {
        this.document = doc;
    }

    public FDFDocument(Document doc) throws IOException, PlpdfException {
        this();
        Element xfdf = doc.getDocumentElement();
        if (!xfdf.getNodeName().equals("xfdf")) {
            throw new PlpdfException(this.getClass().getName(), "InvalidDocumnetRoot", new String[]{xfdf.getNodeName()});
        }
        FDFCatalog cat = new FDFCatalog(xfdf);
        this.setCatalog(cat);
    }

    public void writeXML(Writer output) throws IOException {
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.write("<xfdf xmlns=\"http://ns.adobe.com/xfdf/\" xml:space=\"preserve\">\n");
        this.getCatalog().writeXML(output);
        output.write("</xfdf>\n");
    }

    public OMDocument getDocument() {
        return this.document;
    }

    public FDFCatalog getCatalog() {
        FDFCatalog retval = null;
        OMDictionary trailer = this.document.getTrailer();
        OMDictionary root = (OMDictionary)trailer.getDictionaryObject(OMName.ROOT);
        if (root == null) {
            retval = new FDFCatalog();
            this.setCatalog(retval);
        } else {
            retval = new FDFCatalog(root);
        }
        return retval;
    }

    public void setCatalog(FDFCatalog cat) {
        OMDictionary trailer = this.document.getTrailer();
        trailer.setItem(OMName.ROOT, (OMObjectable)cat);
    }

    public static FDFDocument load(String filename) throws IOException, CryptographyException {
        return FDFDocument.load(new BufferedInputStream(new FileInputStream(filename)));
    }

    public static FDFDocument load(File file) throws IOException, CryptographyException {
        return FDFDocument.load(new BufferedInputStream(new FileInputStream(file)));
    }

    public static FDFDocument load(InputStream input) throws IOException, CryptographyException {
        PDFParser parser = new PDFParser(input);
        parser.parse();
        return parser.getFDFDocument();
    }

    public static FDFDocument loadXFDF(String filename) throws IOException, PlpdfException {
        return FDFDocument.loadXFDF(new BufferedInputStream(new FileInputStream(filename)));
    }

    public static FDFDocument loadXFDF(File file) throws IOException, PlpdfException {
        return FDFDocument.loadXFDF(new BufferedInputStream(new FileInputStream(file)));
    }

    public static FDFDocument loadXFDF(InputStream input) throws IOException, PlpdfException {
        Document doc = XMLUtil.parse(input);
        return new FDFDocument(doc);
    }

    public void save(File fileName) throws Exception {
        this.save(new FileOutputStream(fileName));
    }

    public void save(String fileName) throws Exception {
        this.save(new FileOutputStream(fileName));
    }

    public void save(OutputStream output) throws Exception {
        OMWriter writer = null;
        try {
            writer = new OMWriter(output);
            writer.write(this.document);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void saveXFDF(File fileName) throws IOException, OMVisitorException {
        this.saveXFDF(new BufferedWriter(new FileWriter(fileName)));
    }

    public void saveXFDF(String fileName) throws IOException, OMVisitorException {
        this.saveXFDF(new BufferedWriter(new FileWriter(fileName)));
    }

    public void saveXFDF(Writer output) throws IOException, OMVisitorException {
        try {
            this.writeXML(output);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public void close() throws IOException {
        this.document.close();
    }
}

