/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.fdf;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.filespecification.SMFileSpecification;
import com.plpdf.smmodel.common.filespecification.SMSimpleFileSpecification;
import com.plpdf.smmodel.fdf.FDFAnnotation;
import com.plpdf.smmodel.fdf.FDFAnnotationText;
import com.plpdf.smmodel.fdf.FDFField;
import com.plpdf.smmodel.fdf.FDFJavaScript;
import com.plpdf.smmodel.fdf.FDFPage;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FDFDictionary
implements OMObjectable {
    private OMDictionary fdf;

    public FDFDictionary() {
        this.fdf = new OMDictionary();
    }

    public FDFDictionary(OMDictionary fdfDictionary) {
        this.fdf = fdfDictionary;
    }

    public FDFDictionary(Element fdfXML) throws IOException, PlpdfException {
        this();
        NodeList nodeList = fdfXML.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element child = (Element)node;
                if (child.getTagName().equals("f")) {
                    SMSimpleFileSpecification fs = new SMSimpleFileSpecification();
                    fs.setFile(child.getAttribute("href"));
                    this.setFile(fs);
                } else if (child.getTagName().equals("ids")) {
                    OMArray ids = new OMArray();
                    String original = child.getAttribute("original");
                    String modified = child.getAttribute("modified");
                    ids.add(OMString.createFromHexString(original));
                    ids.add(OMString.createFromHexString(modified));
                    this.setID(ids);
                } else if (child.getTagName().equals("fields")) {
                    NodeList fields = child.getElementsByTagName("field");
                    ArrayList<FDFField> fieldList = new ArrayList<FDFField>();
                    int f = 0;
                    while (f < fields.getLength()) {
                        fieldList.add(new FDFField((Element)fields.item(f)));
                        ++f;
                    }
                    this.setFields(fieldList);
                } else if (child.getTagName().equals("annots")) {
                    NodeList annots = child.getChildNodes();
                    ArrayList<FDFAnnotationText> annotList = new ArrayList<FDFAnnotationText>();
                    int j = 0;
                    while (j < annots.getLength()) {
                        Node annotNode = annots.item(i);
                        if (annotNode instanceof Element) {
                            Element annot = (Element)annotNode;
                            if (annot.getNodeName().equals("text")) {
                                annotList.add(new FDFAnnotationText(annot));
                            } else {
                                throw new IOException("Error: Unknown annotation type '" + annot.getNodeName());
                            }
                        }
                        ++j;
                    }
                    this.setAnnotations(annotList);
                }
            }
            ++i;
        }
    }

    public void writeXML(Writer output) throws IOException {
        List fields;
        OMArray ids;
        SMFileSpecification fs = this.getFile();
        if (fs != null) {
            output.write("<f href=\"" + fs.getFile() + "\" />\n");
        }
        if ((ids = this.getID()) != null) {
            OMString original = (OMString)ids.getObject(0);
            OMString modified = (OMString)ids.getObject(1);
            output.write("<ids original=\"" + original.getHexString() + "\" ");
            output.write("modified=\"" + modified.getHexString() + "\" />\n");
        }
        if ((fields = this.getFields()) != null && fields.size() > 0) {
            output.write("<fields>\n");
            int i = 0;
            while (i < fields.size()) {
                ((FDFField)fields.get(i)).writeXML(output);
                ++i;
            }
            output.write("</fields>\n");
        }
    }

    public OMBase getOMObject() {
        return this.fdf;
    }

    public OMDictionary getOMDictionary() {
        return this.fdf;
    }

    public SMFileSpecification getFile() throws IOException {
        return SMFileSpecification.createFS(this.fdf.getDictionaryObject(OMName.F));
    }

    public void setFile(SMFileSpecification fs) {
        this.fdf.setItem(OMName.F, (OMObjectable)fs);
    }

    public OMArray getID() {
        return (OMArray)this.fdf.getDictionaryObject(OMName.ID);
    }

    public void setID(OMArray id) {
        this.fdf.setItem(OMName.ID, (OMBase)id);
    }

    public List getFields() {
        OMArrayList retval = null;
        OMArray fieldArray = (OMArray)this.fdf.getDictionaryObject(OMName.FIELDS);
        if (fieldArray != null) {
            ArrayList<FDFField> fields = new ArrayList<FDFField>();
            int i = 0;
            while (i < fieldArray.size()) {
                fields.add(new FDFField((OMDictionary)fieldArray.getObject(i)));
                ++i;
            }
            retval = new OMArrayList(fields, fieldArray);
        }
        return retval;
    }

    public void setFields(List fields) {
        this.fdf.setItem(OMName.FIELDS, (OMBase)OMArrayList.converterToOMArray(fields));
    }

    public String getStatus() {
        return this.fdf.getString(OMName.STATUS);
    }

    public void setStatus(String status) throws IOException {
        this.fdf.setString(OMName.STATUS, status);
    }

    public List getPages() {
        OMArrayList retval = null;
        OMArray pageArray = (OMArray)this.fdf.getDictionaryObject(OMName.PAGES);
        if (pageArray != null) {
            ArrayList<FDFPage> pages = new ArrayList<FDFPage>();
            int i = 0;
            while (i < pageArray.size()) {
                pages.add(new FDFPage((OMDictionary)pageArray.get(i)));
                ++i;
            }
            retval = new OMArrayList(pages, pageArray);
        }
        return retval;
    }

    public void setPages(List pages) {
        this.fdf.setItem(OMName.PAGES, (OMBase)OMArrayList.converterToOMArray(pages));
    }

    public String getEncoding() {
        String encoding = this.fdf.getNameAsString(OMName.ENCODING);
        if (encoding == null) {
            encoding = "PDFDocEncoding";
        }
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.fdf.setName(OMName.ENCODING, encoding);
    }

    public List getAnnotations() throws IOException {
        OMArrayList retval = null;
        OMArray annotArray = (OMArray)this.fdf.getDictionaryObject(OMName.ANNOTS);
        if (annotArray != null) {
            ArrayList<FDFAnnotation> annots = new ArrayList<FDFAnnotation>();
            int i = 0;
            while (i < annotArray.size()) {
                annots.add(FDFAnnotation.create((OMDictionary)annotArray.getObject(i)));
                ++i;
            }
            retval = new OMArrayList(annots, annotArray);
        }
        return retval;
    }

    public void setAnnotations(List annots) {
        this.fdf.setItem(OMName.ANNOTS, (OMBase)OMArrayList.converterToOMArray(annots));
    }

    public OMStream getDifferences() {
        return (OMStream)this.fdf.getDictionaryObject(OMName.DIFFERENCES);
    }

    public void setDifferences(OMStream diff) {
        this.fdf.setItem(OMName.DIFFERENCES, (OMBase)diff);
    }

    public String getTarget() {
        return this.fdf.getString(OMName.TARGET);
    }

    public void setTarget(String target) throws IOException {
        this.fdf.setString(OMName.TARGET, target);
    }

    public List getEmbeddedFDFs() throws IOException {
        OMArrayList retval = null;
        OMArray embeddedArray = (OMArray)this.fdf.getDictionaryObject(OMName.EMBEDDED_FDFS);
        if (embeddedArray != null) {
            ArrayList<SMFileSpecification> embedded = new ArrayList<SMFileSpecification>();
            int i = 0;
            while (i < embeddedArray.size()) {
                embedded.add(SMFileSpecification.createFS(embeddedArray.get(i)));
                ++i;
            }
            retval = new OMArrayList(embedded, embeddedArray);
        }
        return retval;
    }

    public void setEmbeddedFDFs(List embedded) {
        this.fdf.setItem(OMName.EMBEDDED_FDFS, (OMBase)OMArrayList.converterToOMArray(embedded));
    }

    public FDFJavaScript getJavaScript() {
        FDFJavaScript fs = null;
        OMDictionary dic = (OMDictionary)this.fdf.getDictionaryObject(OMName.JAVA_SCRIPT);
        if (dic != null) {
            fs = new FDFJavaScript(dic);
        }
        return fs;
    }

    public void setJavaScript(FDFJavaScript js) {
        this.fdf.setItem(OMName.JAVA_SCRIPT, (OMObjectable)js);
    }
}

