/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.fdf;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.fdf.FDFDictionary;
import com.plpdf.smmodel.interactive.digitalsignature.SMSignature;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Element;

public class FDFCatalog
implements OMObjectable {
    private OMDictionary catalog;

    public FDFCatalog() {
        this.catalog = new OMDictionary();
    }

    public FDFCatalog(OMDictionary cat) {
        this.catalog = cat;
    }

    public FDFCatalog(Element element) throws IOException, PlpdfException {
        this();
        FDFDictionary fdfDict = new FDFDictionary(element);
        this.setFDF(fdfDict);
    }

    public void writeXML(Writer output) throws IOException {
        FDFDictionary fdf = this.getFDF();
        fdf.writeXML(output);
    }

    public OMBase getOMObject() {
        return this.catalog;
    }

    public OMDictionary getOMDictionary() {
        return this.catalog;
    }

    public String getVersion() {
        return this.catalog.getNameAsString("Version");
    }

    public void setVersion(String version) {
        this.catalog.setName("Version", version);
    }

    public FDFDictionary getFDF() {
        OMDictionary fdf = (OMDictionary)this.catalog.getDictionaryObject("FDF");
        FDFDictionary retval = null;
        if (fdf != null) {
            retval = new FDFDictionary(fdf);
        } else {
            retval = new FDFDictionary();
            this.setFDF(retval);
        }
        return retval;
    }

    public void setFDF(FDFDictionary fdf) {
        this.catalog.setItem("FDF", (OMObjectable)fdf);
    }

    public SMSignature getSignature() {
        SMSignature signature = null;
        OMDictionary sig = (OMDictionary)this.catalog.getDictionaryObject("Sig");
        if (sig != null) {
            signature = new SMSignature(sig);
        }
        return signature;
    }

    public void setSignature(SMSignature sig) {
        this.catalog.setItem("Sig", (OMObjectable)sig);
    }
}

