/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.fdf;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.fdf.FDFAnnotationText;
import com.plpdf.util.BitFlagHelper;
import com.plpdf.util.DateConverter;
import java.awt.Color;
import java.io.IOException;
import java.util.Calendar;
import org.w3c.dom.Element;

public abstract class FDFAnnotation
implements OMObjectable {
    protected OMDictionary annot;

    public FDFAnnotation() {
        this.annot = new OMDictionary();
        this.annot.setName("Type", "Annot");
    }

    public FDFAnnotation(OMDictionary a) {
        this.annot = a;
    }

    public FDFAnnotation(Element element) throws IOException {
        this();
        String color;
        String page = element.getAttribute("page");
        if (page != null) {
            this.setPage(Integer.parseInt(page));
        }
        if ((color = element.getAttribute("color")) != null && color.length() == 7 && color.charAt(0) == '#') {
            int colorValue = Integer.parseInt(color.substring(1, 7), 16);
            this.setColor(new Color(colorValue));
        }
        this.setDate(element.getAttribute("date"));
        String flags = element.getAttribute("flags");
        if (flags != null) {
            String[] flagTokens = flags.split(",");
            int i = 0;
            while (i < flagTokens.length) {
                if (flagTokens[i].equals("invisible")) {
                    this.setInvisible(true);
                } else if (flagTokens[i].equals("hidden")) {
                    this.setHidden(true);
                } else if (flagTokens[i].equals("print")) {
                    this.setPrinted(true);
                } else if (flagTokens[i].equals("nozoom")) {
                    this.setNoZoom(true);
                } else if (flagTokens[i].equals("norotate")) {
                    this.setNoRotate(true);
                } else if (flagTokens[i].equals("noview")) {
                    this.setNoView(true);
                } else if (flagTokens[i].equals("readonly")) {
                    this.setReadOnly(true);
                } else if (flagTokens[i].equals("locked")) {
                    this.setLocked(true);
                } else if (flagTokens[i].equals("togglenoview")) {
                    this.setToggleNoView(true);
                }
                ++i;
            }
        }
        this.setName(element.getAttribute("name"));
        String rect = element.getAttribute("rect");
        if (rect != null) {
            String[] rectValues = rect.split(",");
            float[] values = new float[rectValues.length];
            int i = 0;
            while (i < rectValues.length) {
                values[i] = Float.parseFloat(rectValues[i]);
                ++i;
            }
            OMArray array = new OMArray();
            array.setFloatArray(values);
            this.setRectangle(new SMRectangle(array));
        }
        this.setName(element.getAttribute("title"));
        this.setCreationDate(DateConverter.toCalendar(element.getAttribute("creationdate")));
        String opac = element.getAttribute("opacity");
        if (opac != null) {
            this.setOpacity(Float.parseFloat(opac));
        }
        this.setSubject(element.getAttribute("subject"));
    }

    public static FDFAnnotation create(OMDictionary fdfDic) throws IOException {
        FDFAnnotationText retval = null;
        if (fdfDic != null) {
            if ("Text".equals(fdfDic.getNameAsString(OMName.SUBTYPE))) {
                retval = new FDFAnnotationText(fdfDic);
            } else {
                throw new IOException("Unknown annotation type '" + fdfDic.getNameAsString(OMName.SUBTYPE) + "'");
            }
        }
        return retval;
    }

    public OMBase getOMObject() {
        return this.annot;
    }

    public OMDictionary getOMDictionary() {
        return this.annot;
    }

    public Integer getPage() {
        Integer retval = null;
        OMNumber page = (OMNumber)this.annot.getDictionaryObject("Page");
        if (page != null) {
            retval = new Integer(page.intValue());
        }
        return retval;
    }

    public void setPage(int page) {
        this.annot.setInt("Page", page);
    }

    public Color getColor() {
        float[] rgb;
        Color retval = null;
        OMArray array = (OMArray)this.annot.getDictionaryObject("color");
        if (array != null && (rgb = array.toFloatArray()).length >= 3) {
            retval = new Color(rgb[0], rgb[1], rgb[2]);
        }
        return retval;
    }

    public void setColor(Color c) {
        OMArray color = null;
        if (c != null) {
            float[] colors = c.getRGBColorComponents(null);
            color = new OMArray();
            color.setFloatArray(colors);
        }
        this.annot.setItem("color", color);
    }

    public String getDate() {
        return this.annot.getString("date");
    }

    public void setDate(String date) throws IOException {
        this.annot.setString("date", date);
    }

    public boolean isInvisible() {
        return BitFlagHelper.getFlag(this.annot, OMName.F, 1);
    }

    public void setInvisible(boolean invisible) {
        BitFlagHelper.setFlag(this.annot, OMName.F, 1, invisible);
    }

    public boolean isHidden() {
        return BitFlagHelper.getFlag(this.annot, OMName.F, 2);
    }

    public void setHidden(boolean hidden) {
        BitFlagHelper.setFlag(this.annot, OMName.F, 2, hidden);
    }

    public boolean isPrinted() {
        return BitFlagHelper.getFlag(this.annot, OMName.F, 4);
    }

    public void setPrinted(boolean printed) {
        BitFlagHelper.setFlag(this.annot, OMName.F, 4, printed);
    }

    public boolean isNoZoom() {
        return BitFlagHelper.getFlag(this.annot, OMName.F, 8);
    }

    public void setNoZoom(boolean noZoom) {
        BitFlagHelper.setFlag(this.annot, OMName.F, 8, noZoom);
    }

    public boolean isNoRotate() {
        return BitFlagHelper.getFlag(this.annot, OMName.F, 16);
    }

    public void setNoRotate(boolean noRotate) {
        BitFlagHelper.setFlag(this.annot, OMName.F, 16, noRotate);
    }

    public boolean isNoView() {
        return BitFlagHelper.getFlag(this.annot, OMName.F, 32);
    }

    public void setNoView(boolean noView) {
        BitFlagHelper.setFlag(this.annot, OMName.F, 32, noView);
    }

    public boolean isReadOnly() {
        return BitFlagHelper.getFlag(this.annot, OMName.F, 64);
    }

    public void setReadOnly(boolean readOnly) {
        BitFlagHelper.setFlag(this.annot, OMName.F, 64, readOnly);
    }

    public boolean isLocked() {
        return BitFlagHelper.getFlag(this.annot, OMName.F, 128);
    }

    public void setLocked(boolean locked) {
        BitFlagHelper.setFlag(this.annot, OMName.F, 128, locked);
    }

    public boolean isToggleNoView() {
        return BitFlagHelper.getFlag(this.annot, OMName.F, 256);
    }

    public void setToggleNoView(boolean toggleNoView) {
        BitFlagHelper.setFlag(this.annot, OMName.F, 256, toggleNoView);
    }

    public void setName(String name) throws IOException {
        this.annot.setString(OMName.NM, name);
    }

    public String getName() {
        return this.annot.getString(OMName.NM);
    }

    public void setRectangle(SMRectangle rectangle) {
        this.annot.setItem(OMName.RECT, (OMObjectable)rectangle);
    }

    public SMRectangle getRectangle() {
        SMRectangle retval = null;
        OMArray rectArray = (OMArray)this.annot.getDictionaryObject(OMName.RECT);
        if (rectArray != null) {
            retval = new SMRectangle(rectArray);
        }
        return retval;
    }

    public void setTitle(String title) throws IOException {
        this.annot.setString(OMName.T, title);
    }

    public String getTitle() {
        return this.annot.getString(OMName.T);
    }

    public Calendar getCreationDate() throws IOException {
        return this.annot.getDate(OMName.CREATION_DATE);
    }

    public void setCreationDate(Calendar date) throws IOException {
        this.annot.setDate(OMName.CREATION_DATE, date);
    }

    public void setOpacity(float opacity) {
        this.annot.setFloat(OMName.CA, opacity);
    }

    public float getOpacity() {
        return this.annot.getFloat(OMName.CA, 1.0f);
    }

    public void setSubject(String subject) throws IOException {
        this.annot.setString(OMName.SUBJ, subject);
    }

    public String getSubject() {
        return this.annot.getString(OMName.SUBJ);
    }
}

