/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.encryption;

import com.plpdf.encryption.ARCFour;
import com.plpdf.encryption.IVGenerator;
import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.DecryptionMaterial;
import com.plpdf.smmodel.encryption.SMCryptFilterDictionary;
import com.plpdf.smmodel.encryption.SMEncryptionDictionary;
import com.plpdf.smmodel.encryption.SecurityHandler;
import com.plpdf.smmodel.encryption.StandardDecryptionMaterial;
import com.plpdf.smmodel.encryption.StandardProtectionPolicy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class StandardSecurityHandler
extends SecurityHandler {
    private static final String CLASS_NAME = StandardSecurityHandler.class.getName();
    public static final String FILTER = "Standard";
    private static final int DEFAULT_VERSION = 1;
    private static final int DEFAULT_REVISION = 3;
    private int revision = 3;
    private StandardProtectionPolicy policy;
    private ARCFour rc4 = new ARCFour();
    public static final Class<?> PROTECTION_POLICY_CLASS = StandardProtectionPolicy.class;
    public static final byte[] ENCRYPT_PADDING;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 40;
        byArray[1] = -65;
        byArray[2] = 78;
        byArray[3] = 94;
        byArray[4] = 78;
        byArray[5] = 117;
        byArray[6] = -118;
        byArray[7] = 65;
        byArray[8] = 100;
        byArray[10] = 78;
        byArray[11] = 86;
        byArray[12] = -1;
        byArray[13] = -6;
        byArray[14] = 1;
        byArray[15] = 8;
        byArray[16] = 46;
        byArray[17] = 46;
        byArray[19] = -74;
        byArray[20] = -48;
        byArray[21] = 104;
        byArray[22] = 62;
        byArray[23] = -128;
        byArray[24] = 47;
        byArray[25] = 12;
        byArray[26] = -87;
        byArray[27] = -2;
        byArray[28] = 100;
        byArray[29] = 83;
        byArray[30] = 105;
        byArray[31] = 122;
        ENCRYPT_PADDING = byArray;
    }

    public StandardSecurityHandler() {
    }

    public StandardSecurityHandler(StandardProtectionPolicy p) {
        this.policy = p;
        this.keyLength = this.policy.getEncryptionKeyLength();
    }

    private int computeVersionNumber() {
        if (this.keyLength == 40) {
            return 1;
        }
        if (this.algorithm.equalsIgnoreCase("AES")) {
            if (this.keyLength == 128) {
                return 4;
            }
            if (this.keyLength == 256) {
                return 5;
            }
        }
        return 2;
    }

    private int computeRevisionNumber() {
        if (this.version == 1) {
            return 2;
        }
        if (this.version == 4) {
            return 4;
        }
        if (this.version == 5) {
            return 5;
        }
        return 3;
    }

    public void decryptDocument(SMDocument doc, DecryptionMaterial decryptionMaterial) throws CryptographyException, IOException, PlpdfException, NoSuchAlgorithmException {
        this.document = doc;
        if (doc.getEncryptionDictionary().getVersion() == 4 || doc.getEncryptionDictionary().getVersion() == 5) {
            if (doc.getEncryptionDictionary().getCFM().equals("AESV2") || doc.getEncryptionDictionary().getCFM().equals("AESV3")) {
                this.algorithm = "AES";
            } else if (doc.getEncryptionDictionary().getCFM().equals("None")) {
                throw new PlpdfException(CLASS_NAME, "NoNeedToDecrypt");
            }
        }
        SMEncryptionDictionary dictionary = this.document.getEncryptionDictionary();
        OMArray documentIDArray = this.document.getDocument().getDocumentID();
        this.prepareForDecryption(dictionary, documentIDArray, decryptionMaterial);
        this.proceedDecryption();
    }

    public void prepareForDecryption(SMEncryptionDictionary encDictionary, OMArray documentIDArray, DecryptionMaterial decryptionMaterial) throws CryptographyException, IOException, NoSuchAlgorithmException, PlpdfException {
        OMName cryptFilterMethod;
        SMCryptFilterDictionary stdCryptFilterDictionary;
        if (!(decryptionMaterial instanceof StandardDecryptionMaterial)) {
            throw new CryptographyException("Provided decryption material is not compatible with the document");
        }
        StandardDecryptionMaterial material = (StandardDecryptionMaterial)decryptionMaterial;
        String password = material.getPassword();
        if (password == null) {
            password = "";
        }
        int dicPermissions = encDictionary.getPermissions();
        int dicRevision = encDictionary.getRevision();
        int dicLength = encDictionary.getLength() / 8;
        byte[] documentIDBytes = null;
        if (documentIDArray != null && documentIDArray.size() >= 1) {
            OMString id = (OMString)documentIDArray.getObject(0);
            documentIDBytes = id.getBytes();
        } else {
            documentIDBytes = new byte[]{};
        }
        boolean encryptMetadata = encDictionary.isEncryptMetaData();
        byte[] u = encDictionary.getUserKey();
        byte[] o = encDictionary.getOwnerKey();
        if (dicRevision == 5) {
            boolean isUserPassword = this.isUserPassword(password.getBytes("ISO-8859-1"), u, o, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata);
            boolean isOwnerPassword = this.isOwnerPassword(password.getBytes("ISO-8859-1"), u, o, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata);
            if (isUserPassword) {
                this.currentAccessPermission = new AccessPermission(dicPermissions);
                this.encryptionKey = this.computeEncryptedKey(password.getBytes("ISO-8859-1"), o, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata);
            } else if (isOwnerPassword) {
                this.currentAccessPermission = AccessPermission.getOwnerAccessPermission();
                byte[] computedUserPassword = this.getUserPassword(password.getBytes("ISO-8859-1"), o, dicRevision, dicLength);
                this.encryptionKey = this.computeEncryptedKey(computedUserPassword, o, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata);
            } else {
                throw new CryptographyException("Error: The supplied password does not match either the owner or user password in the document.");
            }
        }
        if ((stdCryptFilterDictionary = encDictionary.getStdCryptFilterDictionary()) != null && (cryptFilterMethod = stdCryptFilterDictionary.getCryptFilterMethod()) != null) {
            this.setAES("AESV2".equalsIgnoreCase(cryptFilterMethod.getName()));
        }
    }

    public void prepareDocumentForEncryption(SMDocument doc) throws Exception {
        this.document = doc;
        SMEncryptionDictionary encryptionDictionary = this.document.getEncryptionDictionary();
        if (encryptionDictionary == null) {
            encryptionDictionary = new SMEncryptionDictionary();
        }
        this.algorithm = this.policy.getAlgorithm();
        this.version = this.computeVersionNumber();
        this.revision = this.computeRevisionNumber();
        encryptionDictionary.setFilter(FILTER);
        encryptionDictionary.setVersion(this.version);
        encryptionDictionary.setRevision(this.revision);
        encryptionDictionary.setLength(this.keyLength);
        String ownerPassword = this.policy.getOwnerPassword();
        String userPassword = this.policy.getUserPassword();
        if (ownerPassword == null) {
            ownerPassword = "";
        }
        if (userPassword == null) {
            userPassword = "";
        }
        int permissionInt = this.policy.getPermissions().getPermissionBytes();
        encryptionDictionary.setPermissions(permissionInt);
        int length = this.keyLength / 8;
        OMArray idArray = this.document.getDocument().getDocumentID();
        if (idArray == null || idArray.size() < 2) {
            idArray = new OMArray();
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                BigInteger time = BigInteger.valueOf(System.currentTimeMillis());
                md.update(time.toByteArray());
                md.update(ownerPassword.getBytes("ISO-8859-1"));
                md.update(userPassword.getBytes("ISO-8859-1"));
                md.update(this.document.getDocument().toString().getBytes());
                byte[] id = md.digest(this.toString().getBytes("ISO-8859-1"));
                OMString idString = new OMString();
                idString.append(id);
                idArray.add(idString);
                idArray.add(idString);
                this.document.getDocument().setDocumentID(idArray);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptographyException(e);
            }
            catch (IOException e) {
                throw new CryptographyException(e);
            }
        }
        OMString id = (OMString)idArray.getObject(0);
        byte[] o = new byte[48];
        byte[] u = new byte[48];
        byte[] ue = null;
        byte[] oe = null;
        byte[] perms = null;
        byte[] key = IVGenerator.getIV(32);
        if (this.revision != 5) {
            o = this.computeOwnerPassword(ownerPassword.getBytes("ISO-8859-1"), userPassword.getBytes("ISO-8859-1"), this.revision, length);
            u = this.computeUserPassword(userPassword.getBytes("ISO-8859-1"), o, permissionInt, id.getBytes(), this.revision, length, true);
            this.encryptionKey = this.computeEncryptedKey(userPassword.getBytes("ISO-8859-1"), o, permissionInt, id.getBytes(), this.revision, length, true);
        }
        encryptionDictionary.setOwnerKey(o);
        encryptionDictionary.setUserKey(u);
        if (this.revision == 5) {
            encryptionDictionary.setUEKey(ue);
            encryptionDictionary.setOEKey(oe);
            encryptionDictionary.setPERMSKey(perms);
            this.encryptionKey = new byte[length];
            System.arraycopy(key, 0, this.encryptionKey, 0, this.encryptionKey.length);
        }
        if (this.algorithm.equalsIgnoreCase("AES")) {
            OMDictionary stdcf = new OMDictionary();
            if (this.revision == 4) {
                stdcf.setInt(OMName.getPDFName("Length"), 16);
            } else if (this.revision == 5) {
                stdcf.setInt(OMName.getPDFName("Length"), 32);
            }
            stdcf.setItem(OMName.getPDFName("AuthEvent"), (OMBase)OMName.getPDFName("DocOpen"));
            encryptionDictionary.getOMDictionary().setItem(OMName.getPDFName("StrF"), (OMBase)OMName.getPDFName("StdCF"));
            encryptionDictionary.getOMDictionary().setItem(OMName.getPDFName("StmF"), (OMBase)OMName.getPDFName("StdCF"));
            if (this.revision == 4) {
                stdcf.setItem(OMName.getPDFName("CFM"), (OMBase)OMName.getPDFName("AESV2"));
            } else if (this.revision == 5) {
                stdcf.setItem(OMName.getPDFName("CFM"), (OMBase)OMName.getPDFName("AESV3"));
            }
            OMDictionary cf = new OMDictionary();
            cf.setItem(OMName.getPDFName("StdCF"), (OMBase)stdcf);
            encryptionDictionary.getOMDictionary().setItem(OMName.getPDFName("CF"), (OMBase)cf);
        }
        this.document.setEncryptionDictionary(encryptionDictionary);
        this.document.getDocument().setEncryptionDictionary(encryptionDictionary.getOMDictionary());
    }

    public final boolean isOwnerPassword(byte[] ownerPassword, byte[] u, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException, IOException {
        byte[] userPassword = this.getUserPassword(ownerPassword, o, encRevision, length);
        return this.isUserPassword(userPassword, u, o, permissions, id, encRevision, length, encryptMetadata);
    }

    public final byte[] getUserPassword(byte[] ownerPassword, byte[] o, int encRevision, long length) throws CryptographyException, IOException {
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] ownerPadded = this.truncateOrPad(ownerPassword);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(ownerPadded);
            byte[] digest = md.digest();
            if (encRevision == 3 || encRevision == 4) {
                int i = 0;
                while (i < 50) {
                    md.reset();
                    md.update(digest);
                    digest = md.digest();
                    ++i;
                }
            }
            if (encRevision == 2 && length != 5L) {
                throw new CryptographyException("Error: Expected length=5 actual=" + length);
            }
            byte[] rc4Key = new byte[(int)length];
            System.arraycopy(digest, 0, rc4Key, 0, (int)length);
            if (encRevision == 2) {
                this.rc4.setKey(rc4Key);
                this.rc4.write(o, (OutputStream)result);
            } else if (encRevision == 3 || encRevision == 4) {
                byte[] iterationKey = new byte[rc4Key.length];
                byte[] otemp = new byte[o.length];
                System.arraycopy(o, 0, otemp, 0, o.length);
                this.rc4.write(o, (OutputStream)result);
                int i = 19;
                while (i >= 0) {
                    System.arraycopy(rc4Key, 0, iterationKey, 0, rc4Key.length);
                    int j = 0;
                    while (j < iterationKey.length) {
                        iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
                        ++j;
                    }
                    this.rc4.setKey(iterationKey);
                    result.reset();
                    this.rc4.write(otemp, (OutputStream)result);
                    otemp = result.toByteArray();
                    --i;
                }
            }
            return result.toByteArray();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
    }

    public final byte[] computeEncryptedKey(byte[] password, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException {
        byte[] result = new byte[length];
        try {
            byte[] padded = this.truncateOrPad(password);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(padded);
            md.update(o);
            byte zero = (byte)(permissions >>> 0);
            byte one = (byte)(permissions >>> 8);
            byte two = (byte)(permissions >>> 16);
            byte three = (byte)(permissions >>> 24);
            md.update(zero);
            md.update(one);
            md.update(two);
            md.update(three);
            md.update(id);
            if (encRevision == 4 && !encryptMetadata) {
                md.update(new byte[]{-1, -1, -1, -1});
            }
            byte[] digest = md.digest();
            if (encRevision == 3 || encRevision == 4) {
                int i = 0;
                while (i < 50) {
                    md.reset();
                    md.update(digest, 0, length);
                    digest = md.digest();
                    ++i;
                }
            }
            if (encRevision == 2 && length != 5) {
                throw new CryptographyException("Error: length should be 5 when revision is two actual=" + length);
            }
            System.arraycopy(digest, 0, result, 0, length);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
        return result;
    }

    public final byte[] computeUserPassword(byte[] password, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException, IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] encryptionKey = this.computeEncryptedKey(password, o, permissions, id, encRevision, length, encryptMetadata);
        if (encRevision == 2) {
            this.rc4.setKey(encryptionKey);
            this.rc4.write(ENCRYPT_PADDING, (OutputStream)result);
        } else if (encRevision == 3 || encRevision == 4) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(ENCRYPT_PADDING);
                md.update(id);
                result.write(md.digest());
                byte[] iterationKey = new byte[encryptionKey.length];
                int i = 0;
                while (i < 20) {
                    System.arraycopy(encryptionKey, 0, iterationKey, 0, iterationKey.length);
                    int j = 0;
                    while (j < iterationKey.length) {
                        iterationKey[j] = (byte)(iterationKey[j] ^ i);
                        ++j;
                    }
                    this.rc4.setKey(iterationKey);
                    ByteArrayInputStream input = new ByteArrayInputStream(result.toByteArray());
                    result.reset();
                    this.rc4.write(input, (OutputStream)result);
                    ++i;
                }
                byte[] finalResult = new byte[32];
                System.arraycopy(result.toByteArray(), 0, finalResult, 0, 16);
                System.arraycopy(ENCRYPT_PADDING, 0, finalResult, 16, 16);
                result.reset();
                result.write(finalResult);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptographyException(e);
            }
        }
        return result.toByteArray();
    }

    public final byte[] computeOwnerPassword(byte[] ownerPassword, byte[] userPassword, int encRevision, int length) throws CryptographyException, IOException {
        try {
            byte[] ownerPadded = this.truncateOrPad(ownerPassword);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(ownerPadded);
            byte[] digest = md.digest();
            if (encRevision == 3 || encRevision == 4) {
                int i = 0;
                while (i < 50) {
                    md.reset();
                    md.update(digest, 0, length);
                    digest = md.digest();
                    ++i;
                }
            }
            if (encRevision == 2 && length != 5) {
                throw new CryptographyException("Error: Expected length=5 actual=" + length);
            }
            byte[] rc4Key = new byte[length];
            System.arraycopy(digest, 0, rc4Key, 0, length);
            byte[] paddedUser = this.truncateOrPad(userPassword);
            this.rc4.setKey(rc4Key);
            ByteArrayOutputStream crypted = new ByteArrayOutputStream();
            this.rc4.write(new ByteArrayInputStream(paddedUser), (OutputStream)crypted);
            if (encRevision == 3 || encRevision == 4) {
                byte[] iterationKey = new byte[rc4Key.length];
                int i = 1;
                while (i < 20) {
                    System.arraycopy(rc4Key, 0, iterationKey, 0, rc4Key.length);
                    int j = 0;
                    while (j < iterationKey.length) {
                        iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
                        ++j;
                    }
                    this.rc4.setKey(iterationKey);
                    ByteArrayInputStream input = new ByteArrayInputStream(crypted.toByteArray());
                    crypted.reset();
                    this.rc4.write(input, (OutputStream)crypted);
                    ++i;
                }
            }
            return crypted.toByteArray();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e.getMessage());
        }
    }

    private final byte[] truncateOrPad(byte[] password) {
        byte[] padded = new byte[ENCRYPT_PADDING.length];
        int bytesBeforePad = Math.min(password.length, padded.length);
        System.arraycopy(password, 0, padded, 0, bytesBeforePad);
        System.arraycopy(ENCRYPT_PADDING, 0, padded, bytesBeforePad, ENCRYPT_PADDING.length - bytesBeforePad);
        return padded;
    }

    public final boolean isUserPassword(byte[] password, byte[] u, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException, IOException {
        boolean matches = false;
        byte[] computedValue = this.computeUserPassword(password, o, permissions, id, encRevision, length, encryptMetadata);
        if (encRevision == 2) {
            matches = Arrays.equals(u, computedValue);
        } else if (encRevision == 3 || encRevision == 4) {
            matches = StandardSecurityHandler.arraysEqual(u, computedValue, 16);
        } else {
            throw new IOException("Unknown Encryption Revision " + encRevision);
        }
        return matches;
    }

    public final boolean isUserPassword(String password, byte[] u, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException, IOException {
        return this.isUserPassword(password.getBytes("ISO-8859-1"), u, o, permissions, id, encRevision, length, encryptMetadata);
    }

    public final boolean isOwnerPassword(String password, byte[] u, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException, IOException {
        return this.isOwnerPassword(password.getBytes("ISO-8859-1"), u, o, permissions, id, encRevision, length, encryptMetadata);
    }

    private static final boolean arraysEqual(byte[] first, byte[] second, int count) {
        if (first.length < count || second.length < count) {
            return false;
        }
        int i = 0;
        while (i < count) {
            if (first[i] != second[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

