/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.encryption;

import com.plpdf.encryption.AESCipher;
import com.plpdf.encryption.ARCFour;
import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.DecryptionMaterial;
import com.plpdf.smmodel.encryption.SMEncryptionDictionary;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityHandler {
    private static final int DEFAULT_KEY_LENGTH = 40;
    private final byte[] AES_SALT = new byte[]{115, 65, 108, 84};
    protected int version;
    protected int keyLength = 40;
    protected byte[] encryptionKey;
    protected SMDocument document;
    protected ARCFour rc4 = new ARCFour();
    private Set<OMBase> objects = new HashSet<OMBase>();
    private Set<OMDictionary> potentialSignatures = new HashSet<OMDictionary>();
    private boolean aes;
    protected String algorithm = "RC4";
    protected AESCipher cipher;
    protected AccessPermission currentAccessPermission = null;

    public abstract void prepareDocumentForEncryption(SMDocument var1) throws Exception;

    public abstract void prepareForDecryption(SMEncryptionDictionary var1, OMArray var2, DecryptionMaterial var3) throws CryptographyException, IOException, NoSuchAlgorithmException, PlpdfException;

    public abstract void decryptDocument(SMDocument var1, DecryptionMaterial var2) throws CryptographyException, IOException, PlpdfException, NoSuchAlgorithmException;

    protected void proceedDecryption() throws IOException, CryptographyException, PlpdfException {
        OMDictionary trailer = this.document.getDocument().getTrailer();
        OMArray fields = (OMArray)trailer.getObjectFromPath("Root/AcroForm/Fields");
        if (fields != null) {
            int i = 0;
            while (i < fields.size()) {
                OMDictionary field = (OMDictionary)fields.getObject(i);
                if (field == null) {
                    throw new IOException("Could not decypt document, object not found.");
                }
                this.addDictionaryAndSubDictionary(this.potentialSignatures, field);
                ++i;
            }
        }
        List<OMObject> allObjects = this.document.getDocument().getObjects();
        Iterator<OMObject> objectIter = allObjects.iterator();
        while (objectIter.hasNext()) {
            this.decryptObject(objectIter.next());
        }
        this.document.setEncryptionDictionary(null);
    }

    private void addDictionaryAndSubDictionary(Set<OMDictionary> set, OMDictionary dic) {
        if (dic != null) {
            set.add(dic);
            OMArray kids = (OMArray)dic.getDictionaryObject(OMName.KIDS);
            int i = 0;
            while (kids != null && i < kids.size()) {
                this.addDictionaryAndSubDictionary(set, (OMDictionary)kids.getObject(i));
                ++i;
            }
            OMBase value = dic.getDictionaryObject(OMName.V);
            if (value instanceof OMDictionary) {
                this.addDictionaryAndSubDictionary(set, (OMDictionary)value);
            }
        }
    }

    public void encryptData(long objectNumber, long genNumber, InputStream data, OutputStream output) throws CryptographyException, IOException, PlpdfException {
        this.encryptData(objectNumber, genNumber, data, output, false);
    }

    public void encryptData(long objectNumber, long genNumber, InputStream data, OutputStream output, boolean decrypt) throws IOException, CryptographyException {
        byte[] newKey = null;
        if (this.algorithm.equalsIgnoreCase("RC4")) {
            newKey = new byte[this.encryptionKey.length + 5];
            System.arraycopy(this.encryptionKey, 0, newKey, 0, this.encryptionKey.length);
            newKey[newKey.length - 5] = (byte)(objectNumber & 0xFFL);
            newKey[newKey.length - 4] = (byte)(objectNumber >> 8 & 0xFFL);
            newKey[newKey.length - 3] = (byte)(objectNumber >> 16 & 0xFFL);
            newKey[newKey.length - 2] = (byte)(genNumber & 0xFFL);
            newKey[newKey.length - 1] = (byte)(genNumber >> 8 & 0xFFL);
        } else if (this.algorithm.equalsIgnoreCase("AES") && this.encryptionKey.length == 16) {
            newKey = new byte[this.encryptionKey.length + 9];
            System.arraycopy(this.encryptionKey, 0, newKey, 0, this.encryptionKey.length);
            newKey[newKey.length - 9] = (byte)(objectNumber & 0xFFL);
            newKey[newKey.length - 8] = (byte)(objectNumber >> 8 & 0xFFL);
            newKey[newKey.length - 7] = (byte)(objectNumber >> 16 & 0xFFL);
            newKey[newKey.length - 6] = (byte)(genNumber & 0xFFL);
            newKey[newKey.length - 5] = (byte)(genNumber >> 8 & 0xFFL);
            newKey[newKey.length - 4] = 115;
            newKey[newKey.length - 3] = 65;
            newKey[newKey.length - 2] = 108;
            newKey[newKey.length - 1] = 84;
        } else {
            newKey = new byte[this.encryptionKey.length];
        }
        byte[] digestedKey = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            digestedKey = md.digest(newKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
        int length = newKey.length;
        if (this.algorithm.equalsIgnoreCase("AES") && this.encryptionKey.length == 32) {
            if (length > 32) {
                length = 32;
            }
        } else if (length > 16) {
            length = 16;
        }
        byte[] finalKey = new byte[length];
        if (this.algorithm.equalsIgnoreCase("AES") && this.encryptionKey.length == 32) {
            System.arraycopy(this.encryptionKey, 0, finalKey, 0, length);
        } else {
            System.arraycopy(digestedKey, 0, finalKey, 0, length);
        }
        if (this.algorithm.equalsIgnoreCase("RC4")) {
            this.rc4.setKey(finalKey);
            this.rc4.write(data, output);
            output.flush();
        } else {
            this.algorithm.equalsIgnoreCase("AES");
        }
    }

    private void decryptObject(OMObject object) throws CryptographyException, IOException, PlpdfException {
        long objNum = object.getObjectNumber().intValue();
        long genNum = object.getGenerationNumber().intValue();
        OMBase base = object.getObject();
        this.decrypt(base, objNum, genNum);
    }

    private void decrypt(OMBase obj, long objNum, long genNum) throws CryptographyException, IOException {
        if (!this.objects.contains(obj)) {
            this.objects.add(obj);
            if (obj instanceof OMString) {
                this.decryptString((OMString)obj, objNum, genNum, true);
            } else if (obj instanceof OMStream) {
                this.decryptStream((OMStream)obj, objNum, genNum);
            } else if (obj instanceof OMDictionary) {
                this.decryptDictionary((OMDictionary)obj, objNum, genNum);
            } else if (obj instanceof OMArray) {
                this.decryptArray((OMArray)obj, objNum, genNum);
            }
        }
    }

    public void decryptStream(OMStream stream, long objNum, long genNum) throws CryptographyException, IOException {
        this.decryptDictionary(stream, objNum, genNum);
        InputStream encryptedStream = stream.getFilteredStream();
        this.encryptData(objNum, genNum, encryptedStream, stream.createFilteredStream(), true);
    }

    public void encryptStream(OMStream stream, long objNum, long genNum) throws CryptographyException, IOException, PlpdfException {
        InputStream encryptedStream = stream.getFilteredStream();
        this.encryptData(objNum, genNum, encryptedStream, stream.createFilteredStream(), false);
    }

    private void decryptDictionary(OMDictionary dictionary, long objNum, long genNum) throws CryptographyException, IOException {
        for (Map.Entry<OMName, OMBase> entry : dictionary.entrySet()) {
            OMBase value = entry.getValue();
            if (!(value instanceof OMString) && !(value instanceof OMStream) || entry.getKey().getName().equals("Contents") && value instanceof OMString && this.potentialSignatures.contains(dictionary)) continue;
            this.decrypt(entry.getValue(), objNum, genNum);
        }
    }

    public void decryptString(OMString string, long objNum, long genNum, boolean decrypt) throws CryptographyException, IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryptData(objNum, genNum, data, buffer, decrypt);
        string.reset();
        string.append(buffer.toByteArray());
    }

    private void decryptArray(OMArray array, long objNum, long genNum) throws CryptographyException, IOException {
        int i = 0;
        while (i < array.size()) {
            this.decrypt(array.get(i), objNum, genNum);
            ++i;
        }
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int keyLen) {
        this.keyLength = keyLen;
    }

    public AccessPermission getCurrentAccessPermission() {
        return this.currentAccessPermission;
    }

    public boolean isAES() {
        return this.aes;
    }

    public void setAES(boolean aes) {
        this.aes = aes;
    }

    public void setAlgorithm(String algo) {
        this.algorithm = algo;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

