/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.encryption;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.encryption.SMEncryptionDictionary;
import java.io.IOException;

public class SMStandardEncryption
extends SMEncryptionDictionary {
    public static final String FILTER_NAME = "Standard";
    public static final int DEFAULT_REVISION = 3;
    public static final int REVISION2 = 2;
    public static final int REVISION3 = 3;
    public static final int REVISION4 = 4;
    public static final int DEFAULT_PERMISSIONS = -4;
    private static final int PRINT_BIT = 3;
    private static final int MODIFICATION_BIT = 4;
    private static final int EXTRACT_BIT = 5;
    private static final int MODIFY_ANNOTATIONS_BIT = 6;
    private static final int FILL_IN_FORM_BIT = 9;
    private static final int EXTRACT_FOR_ACCESSIBILITY_BIT = 10;
    private static final int ASSEMBLE_DOCUMENT_BIT = 11;
    private static final int DEGRADED_PRINT_BIT = 12;

    public SMStandardEncryption() {
        this.encryptionDictionary.setItem(OMName.FILTER, (OMBase)OMName.getPDFName(FILTER_NAME));
        this.setVersion(1);
        this.setRevision(2);
        this.setPermissions(-4);
    }

    public SMStandardEncryption(OMDictionary dict) {
        super(dict);
    }

    public int getRevision() {
        int revision = 0;
        OMNumber cosRevision = (OMNumber)this.encryptionDictionary.getDictionaryObject(OMName.getPDFName("R"));
        if (cosRevision != null) {
            revision = cosRevision.intValue();
        }
        return revision;
    }

    public void setRevision(int revision) {
        this.encryptionDictionary.setInt(OMName.getPDFName("R"), revision);
    }

    public byte[] getOwnerKey() {
        byte[] o = null;
        OMString owner = (OMString)this.encryptionDictionary.getDictionaryObject(OMName.getPDFName("O"));
        if (owner != null) {
            o = owner.getBytes();
        }
        return o;
    }

    public void setOwnerKey(byte[] o) throws IOException {
        OMString owner = new OMString();
        owner.append(o);
        this.encryptionDictionary.setItem(OMName.getPDFName("O"), (OMBase)owner);
    }

    public byte[] getUserKey() {
        byte[] u = null;
        OMString user = (OMString)this.encryptionDictionary.getDictionaryObject(OMName.getPDFName("U"));
        if (user != null) {
            u = user.getBytes();
        }
        return u;
    }

    public void setUserKey(byte[] u) throws IOException {
        OMString user = new OMString();
        user.append(u);
        this.encryptionDictionary.setItem(OMName.getPDFName("U"), (OMBase)user);
    }

    public int getPermissions() {
        int permissions = 0;
        OMInteger p = (OMInteger)this.encryptionDictionary.getDictionaryObject(OMName.getPDFName("P"));
        if (p != null) {
            permissions = p.intValue();
        }
        return permissions;
    }

    public void setPermissions(int p) {
        this.encryptionDictionary.setInt(OMName.getPDFName("P"), p);
    }

    private boolean isPermissionBitOn(int bit) {
        return (this.getPermissions() & 1 << bit - 1) != 0;
    }

    private boolean setPermissionBit(int bit, boolean value) {
        int permissions = this.getPermissions();
        permissions = value ? (permissions |= 1 << bit - 1) : (permissions &= 0xFFFFFFFF ^ 1 << bit - 1);
        this.setPermissions(permissions);
        return (this.getPermissions() & 1 << bit - 1) != 0;
    }

    public boolean canPrint() {
        return this.isPermissionBitOn(3);
    }

    public void setCanPrint(boolean allowPrinting) {
        this.setPermissionBit(3, allowPrinting);
    }

    public boolean canModify() {
        return this.isPermissionBitOn(4);
    }

    public void setCanModify(boolean allowModifications) {
        this.setPermissionBit(4, allowModifications);
    }

    public boolean canExtractContent() {
        return this.isPermissionBitOn(5);
    }

    public void setCanExtractContent(boolean allowExtraction) {
        this.setPermissionBit(5, allowExtraction);
    }

    public boolean canModifyAnnotations() {
        return this.isPermissionBitOn(6);
    }

    public void setCanModifyAnnotations(boolean allowAnnotationModification) {
        this.setPermissionBit(6, allowAnnotationModification);
    }

    public boolean canFillInForm() {
        return this.isPermissionBitOn(9);
    }

    public void setCanFillInForm(boolean allowFillingInForm) {
        this.setPermissionBit(9, allowFillingInForm);
    }

    public boolean canExtractForAccessibility() {
        return this.isPermissionBitOn(10);
    }

    public void setCanExtractForAccessibility(boolean allowExtraction) {
        this.setPermissionBit(10, allowExtraction);
    }

    public boolean canAssembleDocument() {
        return this.isPermissionBitOn(11);
    }

    public void setCanAssembleDocument(boolean allowAssembly) {
        this.setPermissionBit(11, allowAssembly);
    }

    public boolean canPrintDegraded() {
        return this.isPermissionBitOn(12);
    }

    public void setCanPrintDegraded(boolean allowAssembly) {
        this.setPermissionBit(12, allowAssembly);
    }
}

