/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.encryption;

import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.encryption.SMEncryptionDictionary;
import com.plpdf.smmodel.encryption.SMStandardEncryption;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SMEncryptionManager {
    private static Map handlerMap = Collections.synchronizedMap(new HashMap());

    static {
        SMEncryptionManager.registerSecurityHandler("Standard", SMStandardEncryption.class);
    }

    private SMEncryptionManager() {
    }

    public static void registerSecurityHandler(String filterName, Class handlerClass) {
        handlerMap.put(OMName.getPDFName(filterName), handlerClass);
    }

    public static SMEncryptionDictionary getEncryptionDictionary(OMDictionary dictionary) throws IOException {
        Object retval = null;
        if (dictionary != null) {
            OMName filter = (OMName)dictionary.getDictionaryObject(OMName.FILTER);
            Class handlerClass = (Class)handlerMap.get(filter);
            if (handlerClass == null) {
                throw new IOException("No handler for security handler '" + filter.getName() + "'");
            }
            try {
                Constructor ctor = handlerClass.getConstructor(OMDictionary.class);
                retval = ctor.newInstance(dictionary);
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new IOException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new IOException(e.getMessage());
            }
        }
        return retval;
    }
}

