/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.encryption;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMBoolean;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.encryption.SMCryptFilterDictionary;
import java.io.IOException;

public class SMEncryptionDictionary {
    public static final int VERSION0_UNDOCUMENTED_UNSUPPORTED = 0;
    public static final int VERSION1_40_BIT_ALGORITHM = 1;
    public static final int VERSION2_VARIABLE_LENGTH_ALGORITHM = 2;
    public static final int VERSION3_UNPUBLISHED_ALGORITHM = 3;
    public static final int VERSION4_SECURITY_HANDLER = 4;
    public static final String DEFAULT_NAME = "Standard";
    public static final int DEFAULT_LENGTH = 40;
    public static final int DEFAULT_VERSION = 0;
    protected OMDictionary encryptionDictionary = null;

    public SMEncryptionDictionary() {
        this.encryptionDictionary = new OMDictionary();
    }

    public SMEncryptionDictionary(OMDictionary d) {
        this.encryptionDictionary = d;
    }

    public OMDictionary getOMDictionary() {
        return this.encryptionDictionary;
    }

    public void setFilter(String filter) {
        this.encryptionDictionary.setItem(OMName.FILTER, (OMBase)OMName.getPDFName(filter));
    }

    public String getFilter() {
        return this.encryptionDictionary.getNameAsString(OMName.FILTER);
    }

    public String getSubFilter() {
        return this.encryptionDictionary.getNameAsString(OMName.SUB_FILTER);
    }

    public void setSubFilter(String subfilter) {
        this.encryptionDictionary.setName(OMName.SUB_FILTER, subfilter);
    }

    public void setVersion(int version) {
        this.encryptionDictionary.setInt(OMName.V, version);
    }

    public int getVersion() {
        return this.encryptionDictionary.getInt(OMName.V, 0);
    }

    public void setLength(int length) {
        this.encryptionDictionary.setInt(OMName.LENGTH, length);
    }

    public int getLength() {
        return this.encryptionDictionary.getInt(OMName.LENGTH, 40);
    }

    public void setRevision(int revision) {
        this.encryptionDictionary.setInt(OMName.R, revision);
    }

    public int getRevision() {
        return this.encryptionDictionary.getInt(OMName.R, 0);
    }

    public void setOwnerKey(byte[] o) throws IOException {
        OMString owner = new OMString();
        owner.append(o);
        this.encryptionDictionary.setItem(OMName.O, (OMBase)owner);
    }

    public byte[] getOwnerKey() throws IOException {
        byte[] o = null;
        OMString owner = (OMString)this.encryptionDictionary.getDictionaryObject(OMName.O);
        if (owner != null) {
            o = owner.getBytes();
        }
        return o;
    }

    public void setUserKey(byte[] u) throws IOException {
        OMString user = new OMString();
        user.append(u);
        this.encryptionDictionary.setItem(OMName.U, (OMBase)user);
    }

    public byte[] getUserKey() throws IOException {
        byte[] u = null;
        OMString user = (OMString)this.encryptionDictionary.getDictionaryObject(OMName.U);
        if (user != null) {
            u = user.getBytes();
        }
        return u;
    }

    public void setPermissions(int permissions) {
        this.encryptionDictionary.setInt(OMName.P, permissions);
    }

    public int getPermissions() {
        return this.encryptionDictionary.getInt(OMName.P, 0);
    }

    public boolean isEncryptMetaData() {
        boolean encryptMetaData = true;
        OMBase value = this.encryptionDictionary.getDictionaryObject(OMName.ENCRYPT_META_DATA);
        if (value instanceof OMBoolean) {
            encryptMetaData = ((OMBoolean)value).getValue();
        }
        return encryptMetaData;
    }

    public void setRecipients(byte[][] recipients) throws IOException {
        OMArray array = new OMArray();
        int i = 0;
        while (i < recipients.length) {
            OMString recip = new OMString();
            recip.append(recipients[i]);
            recip.setForceLiteralForm(true);
            array.add(recip);
            ++i;
        }
        this.encryptionDictionary.setItem(OMName.RECIPIENTS, (OMBase)array);
    }

    public int getRecipientsLength() {
        OMArray array = (OMArray)this.encryptionDictionary.getItem(OMName.RECIPIENTS);
        return array.size();
    }

    public OMString getRecipientStringAt(int i) {
        OMArray array = (OMArray)this.encryptionDictionary.getItem(OMName.RECIPIENTS);
        return (OMString)array.get(i);
    }

    public SMCryptFilterDictionary getStdCryptFilterDictionary() {
        return this.getCryptFilterDictionary(OMName.STD_CF);
    }

    public SMCryptFilterDictionary getCryptFilterDictionary(OMName cryptFilterName) {
        OMDictionary stdCryptFilterDictionary;
        OMDictionary cryptFilterDictionary = (OMDictionary)this.encryptionDictionary.getDictionaryObject(OMName.CF);
        if (cryptFilterDictionary != null && (stdCryptFilterDictionary = (OMDictionary)cryptFilterDictionary.getDictionaryObject(cryptFilterName)) != null) {
            return new SMCryptFilterDictionary(stdCryptFilterDictionary);
        }
        return null;
    }

    public OMName getStreamFilterName() {
        OMName stmF = (OMName)this.encryptionDictionary.getDictionaryObject(OMName.STM_F);
        if (stmF == null) {
            stmF = OMName.IDENTITY;
        }
        return stmF;
    }

    public OMName getStringFilterName() {
        OMName strF = (OMName)this.encryptionDictionary.getDictionaryObject(OMName.STR_F);
        if (strF == null) {
            strF = OMName.IDENTITY;
        }
        return strF;
    }

    public byte[] getOEKey() throws IOException {
        byte[] oe = null;
        OMString oe1 = (OMString)this.encryptionDictionary.getDictionaryObject(OMName.getPDFName("OE"));
        if (oe1 != null) {
            oe = oe1.getBytes();
        }
        return oe;
    }

    public byte[] getUEKey() throws IOException {
        byte[] ue = null;
        OMString ue1 = (OMString)this.encryptionDictionary.getDictionaryObject(OMName.getPDFName("UE"));
        if (ue1 != null) {
            ue = ue1.getBytes();
        }
        return ue;
    }

    public byte[] getPERMSKey() throws IOException {
        byte[] perms = null;
        OMString perms1 = (OMString)this.encryptionDictionary.getDictionaryObject(OMName.getPDFName("Perms"));
        if (perms1 != null) {
            perms = perms1.getBytes();
        }
        return perms;
    }

    public String getCFM() {
        OMDictionary cf = null;
        OMDictionary stdcf = null;
        OMBase cf_base = this.encryptionDictionary.getItem(OMName.getPDFName("CF"));
        if (cf_base instanceof OMDictionary) {
            cf = (OMDictionary)cf_base;
        } else if (cf_base instanceof OMObject) {
            cf = (OMDictionary)((OMObject)cf_base).getObject();
        }
        OMBase stdcf_base = cf.getItem(OMName.getPDFName("StdCF"));
        if (stdcf_base == null) {
            OMBase StrF_base = this.encryptionDictionary.getItem(OMName.getPDFName("StrF"));
            OMDictionary cf1 = null;
            if (StrF_base instanceof OMName) {
                String StrF_base_name = ((OMName)StrF_base).getName();
                OMBase cf1_base = cf.getItem(OMName.getPDFName(StrF_base_name));
                if (cf1_base instanceof OMDictionary) {
                    cf1 = (OMDictionary)cf1_base;
                } else if (cf1_base instanceof OMObject) {
                    cf1 = (OMDictionary)((OMObject)cf1_base).getObject();
                }
                return ((OMName)cf1.getItem(OMName.getPDFName("CFM"))).getName();
            }
        } else {
            if (stdcf_base instanceof OMDictionary) {
                stdcf = (OMDictionary)stdcf_base;
            } else if (stdcf_base instanceof OMObject) {
                stdcf = (OMDictionary)((OMObject)stdcf_base).getObject();
            }
            return ((OMName)stdcf.getItem(OMName.getPDFName("CFM"))).getName();
        }
        return null;
    }

    public void setUEKey(byte[] ue) throws IOException {
        OMString ue1 = new OMString();
        ue1.append(ue);
        this.encryptionDictionary.setItem(OMName.getPDFName("UE"), (OMBase)ue1);
    }

    public void setOEKey(byte[] oe) throws IOException {
        OMString oe1 = new OMString();
        oe1.append(oe);
        this.encryptionDictionary.setItem(OMName.getPDFName("OE"), (OMBase)oe1);
    }

    public void setPERMSKey(byte[] perms) throws IOException {
        OMString perms1 = new OMString();
        perms1.append(perms);
        this.encryptionDictionary.setItem(OMName.getPDFName("Perms"), (OMBase)perms1);
    }
}

