/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.edit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.OMStreamArray;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.font.SMFont;
import com.plpdf.smmodel.graphics.SMExtendedGraphicsState;
import com.plpdf.smmodel.graphics.SMShadingPattern;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMDeviceCMYK;
import com.plpdf.smmodel.graphics.color.SMDeviceGray;
import com.plpdf.smmodel.graphics.color.SMDeviceN;
import com.plpdf.smmodel.graphics.color.SMDeviceRGB;
import com.plpdf.smmodel.graphics.color.SMICCBased;
import com.plpdf.smmodel.graphics.color.SMPattern;
import com.plpdf.smmodel.graphics.color.SMSeparation;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentGroup;
import com.plpdf.smmodel.graphics.xobject.SMTemplateXObject;
import com.plpdf.smmodel.graphics.xobject.SMXObject;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.smmodel.markedcontent.SMPropertyList;
import com.plpdf.util.MapUtil;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMPageContentStream {
    private static final String CLASS_NAME = SMPageContentStream.class.getName();
    private SMPage page;
    private OutputStream output;
    private boolean inTextMode = false;
    private SMResources resources;
    private SMColorSpace currentStrokingColorSpace = new SMDeviceGray();
    private SMColorSpace currentNonStrokingColorSpace = new SMDeviceGray();
    private float[] colorComponents = new float[4];
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private Map<String, SMExtendedGraphicsState> opacities = null;
    private Map shadingMappings = new HashMap();
    private Map shadings;
    private Map<String, SMFont> fonts;
    private Map<String, SMXObjectImage> xobjects;
    private Map layerMappings = new HashMap();
    private SMPropertyList layers;
    private static final String ISO8859 = "ISO-8859-1";
    private static final String BEGIN_TEXT = "BT\n";
    private static final String END_TEXT = "ET\n";
    private static final String SET_FONT = "Tf\n";
    private static final String MOVE_TEXT_POSITION = "Td\n";
    private static final String SET_TEXT_MATRIX = "Tm\n";
    private static final String SHOW_TEXT = "Tj\n";
    private static final String SAVE_GRAPHICS_STATE = "q\n";
    private static final String RESTORE_GRAPHICS_STATE = "Q\n";
    private static final String CONCATENATE_MATRIX = "cm\n";
    private static final String XOBJECT_DO = "Do\n";
    private static final String RG_STROKING = "RG\n";
    private static final String RG_NON_STROKING = "rg\n";
    private static final String K_STROKING = "K\n";
    private static final String K_NON_STROKING = "k\n";
    private static final String G_STROKING = "G\n";
    private static final String G_NON_STROKING = "g\n";
    private static final String RECTANGLE = "re\n";
    private static final String FILL_NON_ZERO = "f\n";
    private static final String FILL_EVEN_ODD = "f*\n";
    private static final String LINE_TO = "l\n";
    private static final String MOVE_TO = "m\n";
    private static final String CLOSE_STROKE = "s\n";
    private static final String STROKE = "S\n";
    private static final String LINE_WIDTH = "w\n";
    private static final String LINE_JOIN_STYLE = "j\n";
    private static final String LINE_CAP_STYLE = "J\n";
    private static final String LINE_DASH_PATTERN = "d\n";
    private static final String CLOSE_SUBPATH = "h\n";
    private static final String CLIP_PATH_NON_ZERO = "W\n";
    private static final String CLIP_PATH_EVEN_ODD = "W*\n";
    private static final String NOP = "n\n";
    private static final String BEZIER_312 = "c\n";
    private static final String BEZIER_32 = "v\n";
    private static final String BEZIER_313 = "y\n";
    private static final String BMC = "BMC\n";
    private static final String BDC = "BDC\n";
    private static final String EMC = "EMC\n";
    private static final String SET_STROKING_COLORSPACE = "CS\n";
    private static final String SET_NON_STROKING_COLORSPACE = "cs\n";
    private static final String SET_STROKING_COLOR_SIMPLE = "SC\n";
    private static final String SET_STROKING_COLOR_COMPLEX = "SCN\n";
    private static final String SET_NON_STROKING_COLOR_SIMPLE = "sc\n";
    private static final String SET_NON_STROKING_COLOR_COMPLEX = "scn\n";
    public static final String OPTIONAL_CONTENT = "OC\n";
    public static final String BEGIN_MARKED_CONTENT = "BMC\n";
    public static final String BEGIN_MARKED_CONTENT_D = "BDC\n";
    public static final String END_MARKED_CONTENT = "EMC\n";
    public static final int FILL_TEXT = 0;
    public static final int STROKE_TEXT = 1;
    public static final int FILL_THEN_STROKE_TEXT = 2;
    private static final int SPACE = 32;
    private static final byte[] OPENING_BRACKET = SMPageContentStream.getISOBytes("[");
    private static final byte[] CLOSING_BRACKET = SMPageContentStream.getISOBytes("]");

    private static byte[] getISOBytes(String s) {
        try {
            return s.getBytes(ISO8859);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public SMPageContentStream(SMDocument document, SMPage sourcePage) throws IOException {
        this(document, sourcePage, false, true);
    }

    public SMPageContentStream(SMDocument document, SMPage sourcePage, boolean appendContent, boolean compress) throws IOException {
        this(document, sourcePage, appendContent, compress, false, false);
    }

    public SMPageContentStream(SMDocument document, SMPage sourcePage, boolean appendContent, boolean compress, boolean movefirst) throws IOException {
        this(document, sourcePage, appendContent, compress, false, movefirst);
    }

    public SMPageContentStream(SMDocument document, SMPage sourcePage, boolean appendContent, boolean compress, boolean resetContext, boolean movefirst) throws IOException {
        boolean hasContent;
        this.page = sourcePage;
        this.resources = this.page.getResources();
        if (this.resources == null) {
            this.resources = new SMResources();
            this.page.setResources(this.resources);
        }
        this.fonts = this.resources.getFonts();
        this.xobjects = this.resources.getImages();
        this.layers = this.resources.getProperties();
        this.opacities = this.resources.getGraphicsStates();
        this.shadings = this.resources.getShadings();
        SMStream contents = sourcePage.getContents();
        boolean bl = hasContent = contents != null;
        if (appendContent && hasContent) {
            SMStream contentsToAppend = new SMStream(document);
            OMStreamArray compoundStream = null;
            if (contents.getStream() instanceof OMStreamArray) {
                compoundStream = (OMStreamArray)contents.getStream();
                if (movefirst) {
                    compoundStream.appendStream(0, contentsToAppend.getStream());
                } else {
                    compoundStream.appendStream(contentsToAppend.getStream());
                }
            } else {
                OMArray newArray = new OMArray();
                if (movefirst) {
                    newArray.add(contentsToAppend.getOMObject());
                    newArray.add(contents.getOMObject());
                } else {
                    newArray.add(contents.getOMObject());
                    newArray.add(contentsToAppend.getOMObject());
                }
                compoundStream = new OMStreamArray(newArray);
            }
            if (compress) {
                ArrayList<OMName> filters = new ArrayList<OMName>();
                filters.add(OMName.FLATE_DECODE);
                contentsToAppend.setFilters(filters);
            }
            if (resetContext) {
                SMStream saveGraphics = new SMStream(document);
                this.output = saveGraphics.createOutputStream();
                this.saveGraphicsState();
                this.close();
                if (compress) {
                    ArrayList<OMName> filters = new ArrayList<OMName>();
                    filters.add(OMName.FLATE_DECODE);
                    saveGraphics.setFilters(filters);
                }
                compoundStream.insertOMStream(saveGraphics);
            }
            sourcePage.setContents(new SMStream(compoundStream));
            this.output = contentsToAppend.createOutputStream();
            if (resetContext) {
                this.restoreGraphicsState();
            }
        } else {
            contents = new SMStream(document);
            if (compress) {
                ArrayList<OMName> filters = new ArrayList<OMName>();
                filters.add(OMName.FLATE_DECODE);
                contents.setFilters(filters);
            }
            sourcePage.setContents(contents);
            this.output = contents.createOutputStream();
        }
        this.formatDecimal.setMaximumFractionDigits(10);
        this.formatDecimal.setGroupingUsed(false);
    }

    public void beginText() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: Nested beginText() calls are not allowed.");
        }
        this.appendRawCommands(BEGIN_TEXT);
        this.inTextMode = true;
    }

    public void endText() throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: You must call beginText() before calling endText.");
        }
        this.appendRawCommands(END_TEXT);
        this.inTextMode = false;
    }

    public void setFont(SMFont font, float fontSize) throws IOException {
        String fontMapping = this.resources.addFont(font);
        this.appendRawCommands("/");
        this.appendRawCommands(fontMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(fontSize);
        this.appendRawCommands(32);
        this.appendRawCommands(SET_FONT);
    }

    public void drawImage(SMXObjectImage image, float x, float y) throws IOException {
        this.drawXObject(image, x, y, image.getWidth(), image.getHeight());
    }

    public void drawXObject(SMXObject xobject, float x, float y, float width, float height) throws IOException {
        AffineTransform transform = new AffineTransform(width, 0.0f, 0.0f, height, x, y);
        this.drawXObject(xobject, transform);
    }

    public void drawXObject1x1(SMXObject xobject) throws IOException {
        AffineTransform transform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.drawXObject(xobject, transform);
    }

    public void drawXObject(SMXObject xobject, AffineTransform transform) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: drawXObject is not allowed within a text block.");
        }
        String xObjectPrefix = null;
        xObjectPrefix = xobject instanceof SMXObjectImage ? "Im" : "Form";
        String objMapping = this.resources.addXObject(xobject, xObjectPrefix);
        this.saveGraphicsState();
        this.appendRawCommands(32);
        this.concatenate2CTM(transform);
        this.appendRawCommands(32);
        this.appendRawCommands("/");
        this.appendRawCommands(objMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(XOBJECT_DO);
        this.restoreGraphicsState();
    }

    public void moveTextPositionByAmount(float x, float y) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before moveTextPositionByAmount");
        }
        this.appendRawCommands(x);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TEXT_POSITION);
    }

    public void setTextMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before setTextMatrix");
        }
        this.appendRawCommands(a);
        this.appendRawCommands(32);
        this.appendRawCommands(b);
        this.appendRawCommands(32);
        this.appendRawCommands(c);
        this.appendRawCommands(32);
        this.appendRawCommands(d);
        this.appendRawCommands(32);
        this.appendRawCommands(e);
        this.appendRawCommands(32);
        this.appendRawCommands(f);
        this.appendRawCommands(32);
        this.appendRawCommands(SET_TEXT_MATRIX);
    }

    public void setTextMatrix(AffineTransform matrix) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before setTextMatrix");
        }
        this.appendMatrix(matrix);
        this.appendRawCommands(SET_TEXT_MATRIX);
    }

    public void setTextScaling(double sx, double sy, double tx, double ty) throws IOException {
        this.setTextMatrix(sx, 0.0, 0.0, sy, tx, ty);
    }

    public void setTextTranslation(double tx, double ty) throws IOException {
        this.setTextMatrix(1.0, 0.0, 0.0, 1.0, tx, ty);
    }

    public void setTextRotation(double angle, double tx, double ty) throws IOException {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        this.setTextMatrix(angleCos, angleSin, -angleSin, angleCos, tx, ty);
    }

    public void concatenate2CTM(double a, double b, double c, double d, double e, double f) throws IOException {
        this.appendRawCommands(a);
        this.appendRawCommands(32);
        this.appendRawCommands(b);
        this.appendRawCommands(32);
        this.appendRawCommands(c);
        this.appendRawCommands(32);
        this.appendRawCommands(d);
        this.appendRawCommands(32);
        this.appendRawCommands(e);
        this.appendRawCommands(32);
        this.appendRawCommands(f);
        this.appendRawCommands(32);
        this.appendRawCommands(CONCATENATE_MATRIX);
    }

    public void concatenate2CTM(AffineTransform at) throws IOException {
        this.appendMatrix(at);
        this.appendRawCommands(CONCATENATE_MATRIX);
    }

    public void drawString(String text) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before drawString");
        }
        OMString string = new OMString(text);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        string.writePDF(buffer);
        this.appendRawCommands(buffer.toByteArray());
        this.appendRawCommands(32);
        this.appendRawCommands(SHOW_TEXT);
    }

    public void setStrokingColorSpace(SMColorSpace colorSpace) throws IOException {
        this.currentStrokingColorSpace = colorSpace;
        this.writeColorSpace(colorSpace);
        this.appendRawCommands(SET_STROKING_COLORSPACE);
    }

    public void setNonStrokingColorSpace(SMColorSpace colorSpace) throws IOException {
        this.currentNonStrokingColorSpace = colorSpace;
        this.writeColorSpace(colorSpace);
        this.appendRawCommands(SET_NON_STROKING_COLORSPACE);
    }

    private void writeColorSpace(SMColorSpace colorSpace) throws IOException {
        OMName key = null;
        if (colorSpace instanceof SMDeviceGray || colorSpace instanceof SMDeviceRGB || colorSpace instanceof SMDeviceCMYK) {
            key = OMName.getPDFName(colorSpace.getName());
        } else {
            OMDictionary colorSpaces = (OMDictionary)this.resources.getOMDictionary().getDictionaryObject(OMName.COLORSPACE);
            if (colorSpaces == null) {
                colorSpaces = new OMDictionary();
                this.resources.getOMDictionary().setItem(OMName.COLORSPACE, (OMBase)colorSpaces);
            }
            if ((key = colorSpaces.getKeyForValue(colorSpace.getOMObject())) == null) {
                int counter = 0;
                String csName = "CS";
                while (colorSpaces.containsValue(String.valueOf(csName) + counter)) {
                    ++counter;
                }
                key = OMName.getPDFName(String.valueOf(csName) + counter);
                colorSpaces.setItem(key, (OMObjectable)colorSpace);
            }
        }
        key.writePDF(this.output);
        this.appendRawCommands(32);
    }

    public void setStrokingColor(float[] components) throws IOException {
        int i = 0;
        while (i < components.length) {
            this.appendRawCommands(components[i]);
            this.appendRawCommands(32);
            ++i;
        }
        if (this.currentStrokingColorSpace instanceof SMSeparation || this.currentStrokingColorSpace instanceof SMPattern || this.currentStrokingColorSpace instanceof SMDeviceN || this.currentStrokingColorSpace instanceof SMICCBased) {
            this.appendRawCommands(SET_STROKING_COLOR_COMPLEX);
        } else {
            this.appendRawCommands(SET_STROKING_COLOR_SIMPLE);
        }
    }

    public void setStrokingColor(Color color) throws IOException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0], this.colorComponents[1], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new IOException("Error: unknown colorspace:" + colorSpace);
        }
    }

    public void setNonStrokingColor(Color color) throws IOException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setNonStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0], this.colorComponents[1], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new IOException("Error: unknown colorspace:" + colorSpace);
        }
    }

    public void setStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands((double)r / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)g / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)b / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(RG_STROKING);
    }

    public void setStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands((double)c / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)m / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)y / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)k / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(K_STROKING);
    }

    public void setStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(c);
        this.appendRawCommands(32);
        this.appendRawCommands(m);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(k);
        this.appendRawCommands(32);
        this.appendRawCommands(K_STROKING);
    }

    public void setStrokingColor(int g) throws IOException {
        this.appendRawCommands((double)g / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(G_STROKING);
    }

    public void setStrokingColor(double g) throws IOException {
        this.appendRawCommands(g);
        this.appendRawCommands(32);
        this.appendRawCommands(G_STROKING);
    }

    public void setNonStrokingColor(float[] components) throws IOException {
        int i = 0;
        while (i < components.length) {
            this.appendRawCommands(components[i]);
            this.appendRawCommands(32);
            ++i;
        }
        if (this.currentNonStrokingColorSpace instanceof SMSeparation || this.currentNonStrokingColorSpace instanceof SMPattern || this.currentNonStrokingColorSpace instanceof SMDeviceN || this.currentNonStrokingColorSpace instanceof SMICCBased) {
            this.appendRawCommands(SET_NON_STROKING_COLOR_COMPLEX);
        } else {
            this.appendRawCommands(SET_NON_STROKING_COLOR_SIMPLE);
        }
    }

    public void setNonStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands((double)r / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)g / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)b / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(RG_NON_STROKING);
    }

    public void setNonStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands((double)c / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)m / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)y / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands((double)k / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(K_NON_STROKING);
    }

    public void setNonStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(c);
        this.appendRawCommands(32);
        this.appendRawCommands(m);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(k);
        this.appendRawCommands(32);
        this.appendRawCommands(K_NON_STROKING);
    }

    public void setNonStrokingColor(int g) throws IOException {
        this.appendRawCommands((double)g / 255.0);
        this.appendRawCommands(32);
        this.appendRawCommands(G_NON_STROKING);
    }

    public void setNonStrokingColor(double g) throws IOException {
        this.appendRawCommands(g);
        this.appendRawCommands(32);
        this.appendRawCommands(G_NON_STROKING);
    }

    public void addRect(float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addRect is not allowed within a text block.");
        }
        this.appendRawCommands(x);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(width);
        this.appendRawCommands(32);
        this.appendRawCommands(height);
        this.appendRawCommands(32);
        this.appendRawCommands(RECTANGLE);
    }

    public void fillRect(float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: fillRect is not allowed within a text block.");
        }
        this.addRect(x, y, width, height);
        this.fill(1);
    }

    public void addBezier312(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addBezier312 is not allowed within a text block.");
        }
        this.appendRawCommands(x1);
        this.appendRawCommands(32);
        this.appendRawCommands(y1);
        this.appendRawCommands(32);
        this.appendRawCommands(x2);
        this.appendRawCommands(32);
        this.appendRawCommands(y2);
        this.appendRawCommands(32);
        this.appendRawCommands(x3);
        this.appendRawCommands(32);
        this.appendRawCommands(y3);
        this.appendRawCommands(32);
        this.appendRawCommands(BEZIER_312);
    }

    public void addBezier32(float x2, float y2, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addBezier32 is not allowed within a text block.");
        }
        this.appendRawCommands(x2);
        this.appendRawCommands(32);
        this.appendRawCommands(y2);
        this.appendRawCommands(32);
        this.appendRawCommands(x3);
        this.appendRawCommands(32);
        this.appendRawCommands(y3);
        this.appendRawCommands(32);
        this.appendRawCommands(BEZIER_32);
    }

    public void addBezier31(float x1, float y1, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addBezier31 is not allowed within a text block.");
        }
        this.appendRawCommands(x1);
        this.appendRawCommands(32);
        this.appendRawCommands(y1);
        this.appendRawCommands(32);
        this.appendRawCommands(x3);
        this.appendRawCommands(32);
        this.appendRawCommands(y3);
        this.appendRawCommands(32);
        this.appendRawCommands(BEZIER_313);
    }

    public void moveTo(float x, float y) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: moveTo is not allowed within a text block.");
        }
        this.appendRawCommands(x);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TO);
    }

    public void lineTo(float x, float y) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: lineTo is not allowed within a text block.");
        }
        this.appendRawCommands(x);
        this.appendRawCommands(32);
        this.appendRawCommands(y);
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
    }

    public void addLine(float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addLine is not allowed within a text block.");
        }
        this.moveTo(xStart, yStart);
        this.lineTo(xEnd, yEnd);
    }

    public void drawLine(float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: drawLine is not allowed within a text block.");
        }
        this.addLine(xStart, yStart, xEnd, yEnd);
        this.stroke();
    }

    public void addPolygon(float[] x, float[] y) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addPolygon is not allowed within a text block.");
        }
        if (x.length != y.length) {
            throw new IOException("Error: some points are missing coordinate");
        }
        int i = 0;
        while (i < x.length) {
            if (i == 0) {
                this.moveTo(x[i], y[i]);
            } else {
                this.lineTo(x[i], y[i]);
            }
            ++i;
        }
        this.closeSubPath();
    }

    public void drawPolygon(float[] x, float[] y) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: drawPolygon is not allowed within a text block.");
        }
        this.addPolygon(x, y);
        this.stroke();
    }

    public void fillPolygon(float[] x, float[] y) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: fillPolygon is not allowed within a text block.");
        }
        this.addPolygon(x, y);
        this.fill(1);
    }

    public void stroke() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: stroke is not allowed within a text block.");
        }
        this.appendRawCommands(STROKE);
    }

    public void closeAndStroke() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: closeAndStroke is not allowed within a text block.");
        }
        this.appendRawCommands(CLOSE_STROKE);
    }

    public void fill(int windingRule) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: fill is not allowed within a text block.");
        }
        if (windingRule == 1) {
            this.appendRawCommands(FILL_NON_ZERO);
        } else if (windingRule == 0) {
            this.appendRawCommands(FILL_EVEN_ODD);
        } else {
            throw new IOException("Error: unknown value for winding rule");
        }
    }

    public void closeSubPath() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: closeSubPath is not allowed within a text block.");
        }
        this.appendRawCommands(CLOSE_SUBPATH);
    }

    public void clipPath(int windingRule) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: clipPath is not allowed within a text block.");
        }
        if (windingRule == 1) {
            this.appendRawCommands(CLIP_PATH_NON_ZERO);
            this.appendRawCommands(NOP);
        } else if (windingRule == 0) {
            this.appendRawCommands(CLIP_PATH_EVEN_ODD);
            this.appendRawCommands(NOP);
        } else {
            throw new IOException("Error: unknown value for winding rule");
        }
    }

    public void setLineWidth(float lineWidth) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: setLineWidth is not allowed within a text block.");
        }
        this.appendRawCommands(lineWidth);
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_WIDTH);
    }

    public void setLineJoinStyle(int lineJoinStyle) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: setLineJoinStyle is not allowed within a text block.");
        }
        if (lineJoinStyle < 0 || lineJoinStyle > 2) {
            throw new IOException("Error: unknown value for line join style");
        }
        this.appendRawCommands(Integer.toString(lineJoinStyle));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_JOIN_STYLE);
    }

    public void setLineCapStyle(int lineCapStyle) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: setLineCapStyle is not allowed within a text block.");
        }
        if (lineCapStyle < 0 || lineCapStyle > 2) {
            throw new IOException("Error: unknown value for line cap style");
        }
        this.appendRawCommands(Integer.toString(lineCapStyle));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_CAP_STYLE);
    }

    public void setLineDashPattern(float[] pattern, float phase) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: setLineDashPattern is not allowed within a text block.");
        }
        this.appendRawCommands(OPENING_BRACKET);
        float[] fArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            float value = fArray[n2];
            this.appendRawCommands(value);
            this.appendRawCommands(32);
            ++n2;
        }
        this.appendRawCommands(CLOSING_BRACKET);
        this.appendRawCommands(phase);
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_DASH_PATTERN);
    }

    public void beginMarkedContentSequence(OMName tag) throws IOException {
        this.appendOMName(tag);
        this.appendRawCommands(32);
        this.appendRawCommands("BMC\n");
    }

    public void beginMarkedContentSequence(OMName tag, OMName propsName) throws IOException {
        this.appendOMName(tag);
        this.appendRawCommands(32);
        this.appendOMName(propsName);
        this.appendRawCommands(32);
        this.appendRawCommands("BDC\n");
    }

    public void endMarkedContentSequence() throws IOException {
        this.appendRawCommands("EMC\n");
    }

    public void saveGraphicsState() throws IOException {
        this.appendRawCommands(SAVE_GRAPHICS_STATE);
    }

    public void restoreGraphicsState() throws IOException {
        this.appendRawCommands(RESTORE_GRAPHICS_STATE);
    }

    public void appendRawCommands(double data) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(data));
    }

    public void appendRawCommands(float data) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(data));
    }

    public void appendRawCommands(String commands) throws IOException {
        this.appendRawCommands(commands.getBytes(ISO8859));
    }

    public void appendRawCommands(byte[] commands) throws IOException {
        this.output.write(commands);
    }

    public void appendRawCommands(int data) throws IOException {
        this.output.write(data);
    }

    public void appendOMName(OMName name) throws IOException {
        name.writePDF(this.output);
    }

    private void appendMatrix(AffineTransform transform) throws IOException {
        double[] values = new double[6];
        transform.getMatrix(values);
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            this.appendRawCommands(v);
            this.appendRawCommands(32);
            ++n2;
        }
    }

    public void close() throws IOException {
        this.output.close();
        this.currentNonStrokingColorSpace = null;
        this.currentStrokingColorSpace = null;
        this.page = null;
        this.resources = null;
    }

    public void beginLayer(SMOptionalContentGroup layer) throws IOException {
        String layerMapping = this.resources.addLayer(layer);
        this.appendRawCommands("/");
        this.appendRawCommands(OPTIONAL_CONTENT);
        this.appendRawCommands(32);
        this.appendRawCommands("/");
        this.appendRawCommands(layerMapping);
        this.appendRawCommands(32);
        this.appendRawCommands("BDC\n");
        this.appendRawCommands(32);
    }

    public void endLayer() throws IOException {
        this.appendRawCommands("EMC\n");
        this.appendRawCommands(32);
    }

    public void startOpacity(OMDictionary op) throws IOException {
        SMExtendedGraphicsState gs = new SMExtendedGraphicsState(op);
        String opacityMapping = null;
        try {
            opacityMapping = this.getGraphicsStates1(this.opacities, gs);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (opacityMapping == null) {
            if (this.opacities == null) {
                this.opacities = this.resources.crExtGState();
            }
            opacityMapping = MapUtil.getNextUniqueKey(this.opacities, "GS");
            this.opacities.put(opacityMapping, gs);
            this.resources.setGraphicsStates(this.opacities);
        }
        this.appendRawCommands("q");
        this.appendRawCommands(32);
        this.appendRawCommands("/");
        this.appendRawCommands(opacityMapping);
        this.appendRawCommands(32);
        this.appendRawCommands("gs");
        this.appendRawCommands(32);
    }

    public String getGraphicsStates1(Map<String, SMExtendedGraphicsState> op, SMExtendedGraphicsState gs) {
        String ret = null;
        if (op != null) {
            for (String name : op.keySet()) {
                SMExtendedGraphicsState state = op.get(name);
                if (!gs.equals(state)) continue;
                ret = name;
            }
        }
        return ret;
    }

    public void endOpacity() throws IOException {
        this.appendRawCommands("Q");
        this.appendRawCommands(32);
    }

    public void saveState() throws IOException {
        this.appendRawCommands("q");
        this.appendRawCommands(32);
    }

    public void restoreState() throws IOException {
        this.appendRawCommands("Q");
        this.appendRawCommands(32);
    }

    public void setHorizontalScaling(float scale) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(scale));
        this.appendRawCommands(" Tz");
        this.appendRawCommands(32);
    }

    public void setCharacterSpacing(float charSpace) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(charSpace));
        this.appendRawCommands(" Tc");
        this.appendRawCommands(32);
    }

    public void setLineCap(int style) throws IOException {
        if (style >= 0 && style <= 2) {
            this.appendRawCommands(this.formatDecimal.format(style));
            this.appendRawCommands(" J");
            this.appendRawCommands(32);
        }
    }

    public void setLineJoin(int style) throws IOException {
        if (style >= 0 && style <= 2) {
            this.appendRawCommands(this.formatDecimal.format(style));
            this.appendRawCommands(" j");
            this.appendRawCommands(32);
        }
    }

    public void setMiterLimit(float miterLimit) throws IOException {
        if (miterLimit > 1.0f) {
            this.appendRawCommands(this.formatDecimal.format(miterLimit));
            this.appendRawCommands(" M");
            this.appendRawCommands(32);
        }
    }

    public void setLiteral(String s) throws IOException {
        this.appendRawCommands(s);
    }

    public void setLiteral(char c) throws IOException {
        this.appendRawCommands(c);
    }

    public void setLiteral(float f) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(f));
    }

    public OutputStream getInternalBuffer() {
        return this.output;
    }

    public void closePath() throws IOException {
        this.appendRawCommands("h");
        this.appendRawCommands(32);
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x3));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y3));
        this.appendRawCommands(32);
        this.appendRawCommands("c");
        this.appendRawCommands(32);
    }

    public void curveTo(float x2, float y2, float x3, float y3) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x3));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y3));
        this.appendRawCommands(32);
        this.appendRawCommands("v");
        this.appendRawCommands(32);
    }

    public void eoFill() throws IOException {
        this.appendRawCommands("f*");
        this.appendRawCommands(32);
    }

    public void fill() throws IOException {
        this.appendRawCommands("f");
        this.appendRawCommands(32);
    }

    public void rectangle(float x, float y, float width, float height) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(width));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(height));
        this.appendRawCommands(32);
        this.appendRawCommands(RECTANGLE);
    }

    public void eoClip() throws IOException {
        this.appendRawCommands("W*");
        this.appendRawCommands(32);
    }

    public void clip() throws IOException {
        this.appendRawCommands("W");
        this.appendRawCommands(32);
    }

    public void newPath() throws IOException {
        this.appendRawCommands("n");
        this.appendRawCommands(32);
    }

    public SMPage getPage() {
        return this.page;
    }

    public void setShadingFill(SMShadingPattern shading) throws IOException {
        String shadingMapping = (String)this.shadingMappings.get(shading);
        if (shadingMapping == null) {
            shadingMapping = MapUtil.getNextUniqueKey(this.shadings, "P");
            this.shadingMappings.put(shading, shadingMapping);
            this.shadings.put(shadingMapping, shading);
        }
        this.appendRawCommands("Pattern");
        this.appendRawCommands(" cs ");
        this.appendRawCommands(shadingMapping.getBytes());
        this.appendRawCommands(" scn");
        this.appendRawCommands(32);
    }

    public void setShadingStroke(SMShadingPattern shading) throws IOException {
        String shadingMapping = (String)this.shadingMappings.get(shading);
        if (shadingMapping == null) {
            shadingMapping = MapUtil.getNextUniqueKey(this.shadings, "P");
            this.shadingMappings.put(shading, shadingMapping);
            this.shadings.put(shadingMapping, shading);
        }
        this.appendRawCommands("Pattern");
        this.appendRawCommands(" CS ");
        this.appendRawCommands(shadingMapping.getBytes());
        this.appendRawCommands(" SCN");
        this.appendRawCommands(32);
    }

    public void drawTemplate(SMTemplateXObject template, float x, float y) throws IOException {
        this.drawXObject(template, 1.0f, 0.0f, 0.0f, 1.0f, x, y);
    }

    public void drawTemplate(SMTemplateXObject template, float x, float y, float widthScale, float heightScale) throws IOException {
        this.drawXObject(template, widthScale, 0.0f, 0.0f, heightScale, x, y);
    }

    public void drawXObject(SMXObject xobject, float a, float b, float c, float d, float e, float f) throws IOException {
        AffineTransform transform = new AffineTransform(a, b, c, d, e, f);
        this.drawXObject(xobject, transform);
    }

    public void drawString(String text, String encoding) throws IOException, PlpdfException {
        if (!this.inTextMode) {
            throw new PlpdfException(CLASS_NAME, "BeginTextRequired", new String[]{"drawString()"});
        }
        OMString string = new OMString(text, encoding);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        string.writePDF(buffer);
        this.appendRawCommands(new String(buffer.toByteArray(), encoding));
        this.appendRawCommands(32);
        this.appendRawCommands(SHOW_TEXT);
    }

    public void setTextMatrix(float a, float b, float c, float d, float x, float y) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(a));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(b));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(d));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(SET_TEXT_MATRIX);
    }

    public void setTextMatrix(float x, float y) throws IOException {
        this.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, x, y);
    }

    public void drawarc1(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x3));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y3));
        this.appendRawCommands(32);
        this.appendRawCommands(BEZIER_312);
    }

    public void DrawLine(float x1, float y1, float x2, float y2) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y1));
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TO);
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y2));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
        this.appendRawCommands(32);
        this.appendRawCommands(STROKE);
    }

    public void setTextRenderingMode(int mode) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(mode));
        this.appendRawCommands(32);
        this.appendRawCommands("Tr\n");
    }

    public void setTextStroke() throws IOException {
        this.setTextRenderingMode(1);
    }

    public void setTextFillStroke() throws IOException {
        this.setTextRenderingMode(2);
    }

    public void appendStream(OMStream stream) throws IOException {
        InputStream ioStream = stream.getUnfilteredStream();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int amountRead = 0;
        while ((amountRead = ioStream.read(buffer, 0, buffer.length)) != -1) {
            byteArray.write(buffer, 0, amountRead);
        }
        this.appendRawCommands(String.valueOf(byteArray.toString()) + "\n");
    }

    public void fillRoundedRect(float x, float y, float width, float height, float r) throws IOException {
        float arc = (float)(1.0 * (Math.sqrt(2.0) - 1.0));
        this.appendRawCommands(this.formatDecimal.format(x + r));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TO);
        float xc = x + width - r;
        float yc = y + r;
        this.appendRawCommands(this.formatDecimal.format(xc));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
        this.drawarc1(xc + r * arc, yc - r, xc + r, yc - r * arc, xc + r, yc);
        xc = x + width - r;
        yc = y + height - r;
        this.appendRawCommands(this.formatDecimal.format(x + width));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(yc));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
        this.drawarc1(xc + r, yc + r * arc, xc + r * arc, yc + r, xc, yc + r);
        xc = x + r;
        yc = y + height - r;
        this.appendRawCommands(this.formatDecimal.format(xc));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y + height));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
        this.drawarc1(xc - r * arc, yc + r, xc - r, yc + r * arc, xc - r, yc);
        xc = x + r;
        yc = y + r;
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(yc));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
        this.drawarc1(xc - r, yc - r * arc, xc - r * arc, yc - r, xc, yc - r);
        this.appendRawCommands(FILL_NON_ZERO);
    }

    public void fillTriangle(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y1));
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TO);
        this.appendRawCommands(this.formatDecimal.format(x2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y2));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
        this.appendRawCommands(this.formatDecimal.format(x3));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y3));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
        this.appendRawCommands(this.formatDecimal.format(x1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y1));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
        this.appendRawCommands(FILL_NON_ZERO);
    }
}

