/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.documentinterchange.taggedpdf;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMAttributeObject;
import com.plpdf.smmodel.documentinterchange.taggedpdf.SMFourColours;
import com.plpdf.smmodel.graphics.color.SMGamma;
import java.io.IOException;

public abstract class SMStandardAttributeObject
extends SMAttributeObject {
    protected static final float UNSPECIFIED = -1.0f;

    public SMStandardAttributeObject() {
    }

    public SMStandardAttributeObject(OMDictionary dictionary) {
        super(dictionary);
    }

    public boolean isSpecified(String name) {
        return this.getOMDictionary().getDictionaryObject(name) != null;
    }

    protected String getString(String name) {
        return this.getOMDictionary().getString(name);
    }

    protected void setString(String name, String value) throws IOException {
        OMBase oldBase = this.getOMDictionary().getDictionaryObject(name);
        this.getOMDictionary().setString(name, value);
        OMBase newBase = this.getOMDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected String[] getArrayOfString(String name) {
        OMBase v = this.getOMDictionary().getDictionaryObject(name);
        if (v instanceof OMArray) {
            OMArray array = (OMArray)v;
            String[] strings = new String[array.size()];
            int i = 0;
            while (i < array.size()) {
                strings[i] = ((OMName)array.getObject(i)).getName();
                ++i;
            }
            return strings;
        }
        return null;
    }

    protected void setArrayOfString(String name, String[] values) {
        OMBase oldBase = this.getOMDictionary().getDictionaryObject(name);
        OMArray array = new OMArray();
        int i = 0;
        while (i < values.length) {
            array.add(new OMString(values[i]));
            ++i;
        }
        this.getOMDictionary().setItem(name, (OMBase)array);
        OMBase newBase = this.getOMDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected String getName(String name) {
        return this.getOMDictionary().getNameAsString(name);
    }

    protected String getName(String name, String defaultValue) {
        return this.getOMDictionary().getNameAsString(name, defaultValue);
    }

    protected Object getNameOrArrayOfName(String name, String defaultValue) {
        OMBase v = this.getOMDictionary().getDictionaryObject(name);
        if (v instanceof OMArray) {
            OMArray array = (OMArray)v;
            String[] names = new String[array.size()];
            int i = 0;
            while (i < array.size()) {
                OMBase item = array.getObject(i);
                if (item instanceof OMName) {
                    names[i] = ((OMName)item).getName();
                }
                ++i;
            }
            return names;
        }
        if (v instanceof OMName) {
            return ((OMName)v).getName();
        }
        return defaultValue;
    }

    protected void setName(String name, String value) {
        OMBase oldBase = this.getOMDictionary().getDictionaryObject(name);
        this.getOMDictionary().setName(name, value);
        OMBase newBase = this.getOMDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected void setArrayOfName(String name, String[] values) {
        OMBase oldBase = this.getOMDictionary().getDictionaryObject(name);
        OMArray array = new OMArray();
        int i = 0;
        while (i < values.length) {
            array.add(OMName.getPDFName(values[i]));
            ++i;
        }
        this.getOMDictionary().setItem(name, (OMBase)array);
        OMBase newBase = this.getOMDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected Object getNumberOrName(String name, String defaultValue) {
        OMBase value = this.getOMDictionary().getDictionaryObject(name);
        if (value instanceof OMNumber) {
            return Float.valueOf(((OMNumber)value).floatValue());
        }
        if (value instanceof OMName) {
            return ((OMName)value).getName();
        }
        return defaultValue;
    }

    protected int getInteger(String name, int defaultValue) {
        return this.getOMDictionary().getInt(name, defaultValue);
    }

    protected void setInteger(String name, int value) {
        OMBase oldBase = this.getOMDictionary().getDictionaryObject(name);
        this.getOMDictionary().setInt(name, value);
        OMBase newBase = this.getOMDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected float getNumber(String name, float defaultValue) {
        return this.getOMDictionary().getFloat(name, defaultValue);
    }

    protected float getNumber(String name) {
        return this.getOMDictionary().getFloat(name);
    }

    protected Object getNumberOrArrayOfNumber(String name, float defaultValue) {
        OMBase v = this.getOMDictionary().getDictionaryObject(name);
        if (v instanceof OMArray) {
            OMArray array = (OMArray)v;
            float[] values = new float[array.size()];
            int i = 0;
            while (i < array.size()) {
                OMBase item = array.getObject(i);
                if (item instanceof OMNumber) {
                    values[i] = ((OMNumber)item).floatValue();
                }
                ++i;
            }
            return values;
        }
        if (v instanceof OMNumber) {
            return Float.valueOf(((OMNumber)v).floatValue());
        }
        if (defaultValue == -1.0f) {
            return null;
        }
        return Float.valueOf(defaultValue);
    }

    protected void setNumber(String name, float value) {
        OMBase oldBase = this.getOMDictionary().getDictionaryObject(name);
        this.getOMDictionary().setFloat(name, value);
        OMBase newBase = this.getOMDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected void setNumber(String name, int value) {
        OMBase oldBase = this.getOMDictionary().getDictionaryObject(name);
        this.getOMDictionary().setInt(name, value);
        OMBase newBase = this.getOMDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected void setArrayOfNumber(String name, float[] values) {
        OMArray array = new OMArray();
        int i = 0;
        while (i < values.length) {
            array.add(new OMFloat(values[i]));
            ++i;
        }
        OMBase oldBase = this.getOMDictionary().getDictionaryObject(name);
        this.getOMDictionary().setItem(name, (OMBase)array);
        OMBase newBase = this.getOMDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected SMGamma getColor(String name) {
        OMArray c = (OMArray)this.getOMDictionary().getDictionaryObject(name);
        if (c != null) {
            return new SMGamma(c);
        }
        return null;
    }

    protected Object getColorOrFourColors(String name) {
        OMArray array = (OMArray)this.getOMDictionary().getDictionaryObject(name);
        if (array == null) {
            return null;
        }
        if (array.size() == 3) {
            return new SMGamma(array);
        }
        if (array.size() == 4) {
            return new SMFourColours(array);
        }
        return null;
    }

    protected void setColor(String name, SMGamma value) {
        OMBase oldValue = this.getOMDictionary().getDictionaryObject(name);
        this.getOMDictionary().setItem(name, (OMObjectable)value);
        OMBase newValue = value == null ? null : value.getOMObject();
        this.potentiallyNotifyChanged(oldValue, newValue);
    }

    protected void setFourColors(String name, SMFourColours value) {
        OMBase oldValue = this.getOMDictionary().getDictionaryObject(name);
        this.getOMDictionary().setItem(name, (OMObjectable)value);
        OMBase newValue = value == null ? null : value.getOMObject();
        this.potentiallyNotifyChanged(oldValue, newValue);
    }
}

