/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.documentinterchange.prepress;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.graphics.SMLineDashPattern;
import com.plpdf.smmodel.graphics.color.SMColorState;
import com.plpdf.smmodel.graphics.color.SMDeviceRGB;

public class SMBoxStyle
implements OMObjectable {
    public static final String GUIDELINE_STYLE_SOLID = "S";
    public static final String GUIDELINE_STYLE_DASHED = "D";
    private OMDictionary dictionary;

    public SMBoxStyle() {
        this.dictionary = new OMDictionary();
    }

    public SMBoxStyle(OMDictionary dic) {
        this.dictionary = dic;
    }

    public OMBase getOMObject() {
        return this.dictionary;
    }

    public OMDictionary getDictionary() {
        return this.dictionary;
    }

    public SMColorState getGuidelineColor() {
        OMArray colorValues = (OMArray)this.dictionary.getDictionaryObject("C");
        if (colorValues == null) {
            colorValues = new OMArray();
            colorValues.add(OMInteger.ZERO);
            colorValues.add(OMInteger.ZERO);
            colorValues.add(OMInteger.ZERO);
            this.dictionary.setItem("C", (OMBase)colorValues);
        }
        SMColorState instance = new SMColorState(colorValues);
        instance.setColorSpace(SMDeviceRGB.INSTANCE);
        return instance;
    }

    public void setGuideLineColor(SMColorState color) {
        OMArray values = null;
        if (color != null) {
            values = color.getOMColorSpaceValue();
        }
        this.dictionary.setItem("C", (OMBase)values);
    }

    public float getGuidelineWidth() {
        return this.dictionary.getFloat("W", 1.0f);
    }

    public void setGuidelineWidth(float width) {
        this.dictionary.setFloat("W", width);
    }

    public String getGuidelineStyle() {
        return this.dictionary.getNameAsString(GUIDELINE_STYLE_SOLID, GUIDELINE_STYLE_SOLID);
    }

    public void setGuidelineStyle(String style) {
        this.dictionary.setName(GUIDELINE_STYLE_SOLID, style);
    }

    public SMLineDashPattern getLineDashPattern() {
        SMLineDashPattern pattern = null;
        OMArray d = (OMArray)this.dictionary.getDictionaryObject(GUIDELINE_STYLE_DASHED);
        if (d == null) {
            d = new OMArray();
            d.add(OMInteger.THREE);
            this.dictionary.setItem(GUIDELINE_STYLE_DASHED, (OMBase)d);
        }
        OMArray lineArray = new OMArray();
        lineArray.add(d);
        lineArray.add(OMInteger.ZERO);
        pattern = new SMLineDashPattern(lineArray);
        return pattern;
    }

    public void setLineDashPattern(SMLineDashPattern pattern) {
        OMArray array = null;
        if (pattern != null) {
            array = pattern.getOMDashPattern();
        }
        this.dictionary.setItem(GUIDELINE_STYLE_DASHED, (OMBase)array);
    }
}

