/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.documentinterchange.markedcontent;

import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.documentinterchange.taggedpdf.SMArtifactMarkedContent;
import com.plpdf.smmodel.graphics.xobject.SMXObject;
import com.plpdf.util.TextPosition;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMMarkedContent {
    private String tag;
    private OMDictionary properties;
    private List<Object> contents;

    public static SMMarkedContent create(OMName tag, OMDictionary properties) {
        if (OMName.ARTIFACT.equals(tag)) {
            new SMArtifactMarkedContent(properties);
        }
        return new SMMarkedContent(tag, properties);
    }

    public SMMarkedContent(OMName tag, OMDictionary properties) {
        this.tag = tag == null ? null : tag.getName();
        this.properties = properties;
        this.contents = new ArrayList<Object>();
    }

    public String getTag() {
        return this.tag;
    }

    public OMDictionary getProperties() {
        return this.properties;
    }

    public int getMCID() {
        return this.getProperties() == null ? null : Integer.valueOf(this.getProperties().getInt(OMName.MCID));
    }

    public String getLanguage() {
        return this.getProperties() == null ? null : this.getProperties().getNameAsString(OMName.LANG);
    }

    public String getActualText() {
        return this.getProperties() == null ? null : this.getProperties().getString(OMName.ACTUAL_TEXT);
    }

    public String getAlternateDescription() {
        return this.getProperties() == null ? null : this.getProperties().getString(OMName.ALT);
    }

    public String getExpandedForm() {
        return this.getProperties() == null ? null : this.getProperties().getString(OMName.E);
    }

    public List<Object> getContents() {
        return this.contents;
    }

    public void addText(TextPosition text) {
        this.getContents().add(text);
    }

    public void addMarkedContent(SMMarkedContent markedContent) {
        this.getContents().add(markedContent);
    }

    public void addXObject(SMXObject xobject) {
        this.getContents().add(xobject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("tag=").append(this.tag).append(", properties=").append(this.properties);
        sb.append(", contents=").append(this.contents);
        return sb.toString();
    }
}

