/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.documentinterchange.logicalstructure;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMMarkedContentReference;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMObjectReference;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMStructureElement;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMStructureTreeRoot;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMStructureNode
implements OMObjectable {
    private OMDictionary dictionary;

    public static SMStructureNode create(OMDictionary node) {
        String type = node.getNameAsString(OMName.TYPE);
        if ("StructTreeRoot".equals(type)) {
            return new SMStructureTreeRoot(node);
        }
        if (type == null || "StructElem".equals(type)) {
            return new SMStructureElement(node);
        }
        throw new IllegalArgumentException("Dictionary must not include a Type entry with a value that is neither StructTreeRoot nor StructElem.");
    }

    protected OMDictionary getOMDictionary() {
        return this.dictionary;
    }

    protected SMStructureNode(String type) {
        this.dictionary = new OMDictionary();
        this.dictionary.setName(OMName.TYPE, type);
    }

    protected SMStructureNode(OMDictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public OMBase getOMObject() {
        return this.dictionary;
    }

    public String getType() {
        return this.getOMDictionary().getNameAsString(OMName.TYPE);
    }

    public List<Object> getKids() {
        ArrayList<Object> kidObjects = new ArrayList<Object>();
        OMBase k = this.getOMDictionary().getDictionaryObject(OMName.K);
        if (k instanceof OMArray) {
            for (OMBase kid : (OMArray)k) {
                Object kidObject = this.createObject(kid);
                if (kidObject == null) continue;
                kidObjects.add(kidObject);
            }
        } else {
            Object kidObject = this.createObject(k);
            if (kidObject != null) {
                kidObjects.add(kidObject);
            }
        }
        return kidObjects;
    }

    public void setKids(List<Object> kids) {
        this.getOMDictionary().setItem(OMName.K, (OMBase)OMArrayList.converterToOMArray(kids));
    }

    public void appendKid(SMStructureElement structureElement) {
        this.appendObjectableKid(structureElement);
        structureElement.setParent(this);
    }

    protected void appendObjectableKid(OMObjectable objectable) {
        if (objectable == null) {
            return;
        }
        this.appendKid(objectable.getOMObject());
    }

    protected void appendKid(OMBase object) {
        if (object == null) {
            return;
        }
        OMBase k = this.getOMDictionary().getDictionaryObject(OMName.K);
        if (k == null) {
            this.getOMDictionary().setItem(OMName.K, object);
        } else if (k instanceof OMArray) {
            OMArray array = (OMArray)k;
            array.add(object);
        } else {
            OMArray array = new OMArray();
            array.add(k);
            array.add(object);
            this.getOMDictionary().setItem(OMName.K, (OMBase)array);
        }
    }

    public void insertBefore(SMStructureElement newKid, Object refKid) {
        this.insertObjectableBefore(newKid, refKid);
    }

    protected void insertObjectableBefore(OMObjectable newKid, Object refKid) {
        if (newKid == null) {
            return;
        }
        this.insertBefore(newKid.getOMObject(), refKid);
    }

    protected void insertBefore(OMBase newKid, Object refKid) {
        if (newKid == null || refKid == null) {
            return;
        }
        OMBase k = this.getOMDictionary().getDictionaryObject(OMName.K);
        if (k == null) {
            return;
        }
        OMBase refKidBase = null;
        if (refKid instanceof OMObjectable) {
            refKidBase = ((OMObjectable)refKid).getOMObject();
        } else if (refKid instanceof OMInteger) {
            refKidBase = (OMInteger)refKid;
        }
        if (k instanceof OMArray) {
            OMArray array = (OMArray)k;
            int refIndex = array.indexOfObject(refKidBase);
            array.add(refIndex, newKid.getOMObject());
        } else {
            boolean onlyKid = k.equals(refKidBase);
            if (!onlyKid && k instanceof OMObject) {
                OMBase kObj = ((OMObject)k).getObject();
                onlyKid = kObj.equals(refKidBase);
            }
            if (onlyKid) {
                OMArray array = new OMArray();
                array.add(newKid);
                array.add(refKidBase);
                this.getOMDictionary().setItem(OMName.K, (OMBase)array);
            }
        }
    }

    public boolean removeKid(SMStructureElement structureElement) {
        boolean removed = this.removeObjectableKid(structureElement);
        if (removed) {
            structureElement.setParent(null);
        }
        return removed;
    }

    protected boolean removeObjectableKid(OMObjectable objectable) {
        if (objectable == null) {
            return false;
        }
        return this.removeKid(objectable.getOMObject());
    }

    protected boolean removeKid(OMBase object) {
        if (object == null) {
            return false;
        }
        OMBase k = this.getOMDictionary().getDictionaryObject(OMName.K);
        if (k == null) {
            return false;
        }
        if (k instanceof OMArray) {
            OMArray array = (OMArray)k;
            boolean removed = array.removeObject(object);
            if (array.size() == 1) {
                this.getOMDictionary().setItem(OMName.K, array.getObject(0));
            }
            return removed;
        }
        boolean onlyKid = k.equals(object);
        if (!onlyKid && k instanceof OMObject) {
            OMBase kObj = ((OMObject)k).getObject();
            onlyKid = kObj.equals(object);
        }
        if (onlyKid) {
            this.getOMDictionary().setItem(OMName.K, null);
            return true;
        }
        return false;
    }

    protected Object createObject(OMBase kid) {
        OMBase base;
        OMDictionary kidDic = null;
        if (kid instanceof OMDictionary) {
            kidDic = (OMDictionary)kid;
        } else if (kid instanceof OMObject && (base = ((OMObject)kid).getObject()) instanceof OMDictionary) {
            kidDic = (OMDictionary)base;
        }
        if (kidDic != null) {
            String type = kidDic.getNameAsString(OMName.TYPE);
            if (type == null || "StructElem".equals(type)) {
                return new SMStructureElement(kidDic);
            }
            if ("OBJR".equals(type)) {
                return new SMObjectReference(kidDic);
            }
            if ("MCR".equals(type)) {
                return new SMMarkedContentReference(kidDic);
            }
        } else if (kid instanceof OMInteger) {
            OMInteger mcid = (OMInteger)kid;
            return mcid.intValue();
        }
        return null;
    }
}

