/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.documentinterchange.logicalstructure;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.documentinterchange.logicalstructure.Revisions;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMAttributeObject;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMMarkedContentReference;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMObjectReference;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMStructureNode;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMStructureTreeRoot;
import com.plpdf.smmodel.documentinterchange.markedcontent.SMMarkedContent;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMStructureElement
extends SMStructureNode {
    public static final String TYPE = "StructElem";

    public SMStructureElement(String structureType, SMStructureNode parent) {
        super(TYPE);
        this.setStructureType(structureType);
        this.setParent(parent);
    }

    public SMStructureElement(OMDictionary dic) {
        super(dic);
    }

    public String getStructureType() {
        return this.getOMDictionary().getNameAsString(OMName.S);
    }

    public void setStructureType(String structureType) {
        this.getOMDictionary().setName(OMName.S, structureType);
    }

    public SMStructureNode getParent() {
        OMDictionary p = (OMDictionary)this.getOMDictionary().getDictionaryObject(OMName.P);
        if (p == null) {
            return null;
        }
        return SMStructureNode.create(p);
    }

    public void setParent(SMStructureNode structureNode) {
        this.getOMDictionary().setItem(OMName.P, (OMObjectable)structureNode);
    }

    public String getElementIdentifier() {
        return this.getOMDictionary().getString(OMName.ID);
    }

    public void setElementIdentifier(String id) throws IOException {
        this.getOMDictionary().setString(OMName.ID, id);
    }

    public SMPage getPage() {
        OMDictionary pageDic = (OMDictionary)this.getOMDictionary().getDictionaryObject(OMName.PG);
        if (pageDic == null) {
            return null;
        }
        return new SMPage(pageDic);
    }

    public void setPage(SMPage page) {
        this.getOMDictionary().setItem(OMName.PG, (OMObjectable)page);
    }

    public Revisions<SMAttributeObject> getAttributes() {
        Revisions<SMAttributeObject> attributes = new Revisions<SMAttributeObject>();
        OMBase a = this.getOMDictionary().getDictionaryObject(OMName.A);
        if (a instanceof OMArray) {
            OMArray aa = (OMArray)a;
            Iterator<OMBase> it = aa.iterator();
            SMAttributeObject ao = null;
            while (it.hasNext()) {
                OMBase item = it.next();
                if (item instanceof OMDictionary) {
                    ao = SMAttributeObject.create((OMDictionary)item);
                    ao.setStructureElement(this);
                    attributes.addObject(ao, 0);
                    continue;
                }
                if (!(item instanceof OMInteger)) continue;
                attributes.setRevisionNumber(ao, ((OMInteger)item).intValue());
            }
        }
        if (a instanceof OMDictionary) {
            SMAttributeObject ao = SMAttributeObject.create((OMDictionary)a);
            ao.setStructureElement(this);
            attributes.addObject(ao, 0);
        }
        return attributes;
    }

    public void setAttributes(Revisions<SMAttributeObject> attributes) {
        OMName key = OMName.A;
        if (attributes.size() == 1 && attributes.getRevisionNumber(0) == 0) {
            SMAttributeObject attributeObject = attributes.getObject(0);
            attributeObject.setStructureElement(this);
            this.getOMDictionary().setItem(key, (OMObjectable)attributeObject);
            return;
        }
        OMArray array = new OMArray();
        int i = 0;
        while (i < attributes.size()) {
            SMAttributeObject attributeObject = attributes.getObject(i);
            attributeObject.setStructureElement(this);
            int revisionNumber = attributes.getRevisionNumber(i);
            array.add(attributeObject);
            array.add(OMInteger.get(revisionNumber));
            ++i;
        }
        this.getOMDictionary().setItem(key, (OMBase)array);
    }

    public void addAttribute(SMAttributeObject attributeObject) {
        OMName key = OMName.A;
        attributeObject.setStructureElement(this);
        OMBase a = this.getOMDictionary().getDictionaryObject(key);
        OMArray array = null;
        if (a instanceof OMArray) {
            array = (OMArray)a;
        } else {
            array = new OMArray();
            if (a != null) {
                array.add(a);
                array.add(OMInteger.get(0L));
            }
        }
        this.getOMDictionary().setItem(key, (OMBase)array);
        array.add(attributeObject);
        array.add(OMInteger.get(this.getRevisionNumber()));
    }

    public void removeAttribute(SMAttributeObject attributeObject) {
        OMName key = OMName.A;
        OMBase a = this.getOMDictionary().getDictionaryObject(key);
        if (a instanceof OMArray) {
            OMArray array = (OMArray)a;
            array.remove(attributeObject.getOMObject());
            if (array.size() == 2 && array.getInt(1) == 0) {
                this.getOMDictionary().setItem(key, array.getObject(0));
            }
        } else {
            OMBase directA = a;
            if (a instanceof OMObject) {
                directA = ((OMObject)a).getObject();
            }
            if (attributeObject.getOMObject().equals(directA)) {
                this.getOMDictionary().setItem(key, null);
            }
        }
        attributeObject.setStructureElement(null);
    }

    public void attributeChanged(SMAttributeObject attributeObject) {
        OMName key = OMName.A;
        OMBase a = this.getOMDictionary().getDictionaryObject(key);
        if (a instanceof OMArray) {
            OMArray array = (OMArray)a;
            int i = 0;
            while (i < array.size()) {
                OMBase next;
                OMBase entry = array.getObject(i);
                if (entry.equals(attributeObject.getOMObject()) && (next = array.get(i + 1)) instanceof OMInteger) {
                    array.set(i + 1, OMInteger.get(this.getRevisionNumber()));
                }
                ++i;
            }
        } else {
            OMArray array = new OMArray();
            array.add(a);
            array.add(OMInteger.get(this.getRevisionNumber()));
            this.getOMDictionary().setItem(key, (OMBase)array);
        }
    }

    public Revisions<String> getClassNames() {
        OMName key = OMName.C;
        Revisions<String> classNames = new Revisions<String>();
        OMBase c = this.getOMDictionary().getDictionaryObject(key);
        if (c instanceof OMName) {
            classNames.addObject(((OMName)c).getName(), 0);
        }
        if (c instanceof OMArray) {
            OMArray array = (OMArray)c;
            Iterator<OMBase> it = array.iterator();
            String className = null;
            while (it.hasNext()) {
                OMBase item = it.next();
                if (item instanceof OMName) {
                    className = ((OMName)item).getName();
                    classNames.addObject(className, 0);
                    continue;
                }
                if (!(item instanceof OMInteger)) continue;
                classNames.setRevisionNumber(className, ((OMInteger)item).intValue());
            }
        }
        return classNames;
    }

    public void setClassNames(Revisions<String> classNames) {
        if (classNames == null) {
            return;
        }
        OMName key = OMName.C;
        if (classNames.size() == 1 && classNames.getRevisionNumber(0) == 0) {
            String className = classNames.getObject(0);
            this.getOMDictionary().setName(key, className);
            return;
        }
        OMArray array = new OMArray();
        int i = 0;
        while (i < classNames.size()) {
            String className = classNames.getObject(i);
            int revisionNumber = classNames.getRevisionNumber(i);
            array.add(OMName.getPDFName(className));
            array.add(OMInteger.get(revisionNumber));
            ++i;
        }
        this.getOMDictionary().setItem(key, (OMBase)array);
    }

    public void addClassName(String className) {
        if (className == null) {
            return;
        }
        OMName key = OMName.C;
        OMBase c = this.getOMDictionary().getDictionaryObject(key);
        OMArray array = null;
        if (c instanceof OMArray) {
            array = (OMArray)c;
        } else {
            array = new OMArray();
            if (c != null) {
                array.add(c);
                array.add(OMInteger.get(0L));
            }
        }
        this.getOMDictionary().setItem(key, (OMBase)array);
        array.add(OMName.getPDFName(className));
        array.add(OMInteger.get(this.getRevisionNumber()));
    }

    public void removeClassName(String className) {
        if (className == null) {
            return;
        }
        OMName key = OMName.C;
        OMBase c = this.getOMDictionary().getDictionaryObject(key);
        OMName name = OMName.getPDFName(className);
        if (c instanceof OMArray) {
            OMArray array = (OMArray)c;
            array.remove(name);
            if (array.size() == 2 && array.getInt(1) == 0) {
                this.getOMDictionary().setItem(key, array.getObject(0));
            }
        } else {
            OMBase directC = c;
            if (c instanceof OMObject) {
                directC = ((OMObject)c).getObject();
            }
            if (name.equals(directC)) {
                this.getOMDictionary().setItem(key, null);
            }
        }
    }

    public int getRevisionNumber() {
        return this.getOMDictionary().getInt(OMName.R, 0);
    }

    public void setRevisionNumber(int revisionNumber) {
        this.getOMDictionary().setInt(OMName.R, revisionNumber);
    }

    public void incrementRevisionNumber() {
        this.setRevisionNumber(this.getRevisionNumber() + 1);
    }

    public String getTitle() {
        return this.getOMDictionary().getString(OMName.T);
    }

    public void setTitle(String title) throws IOException {
        this.getOMDictionary().setString(OMName.T, title);
    }

    public String getLanguage() {
        return this.getOMDictionary().getString(OMName.LANG);
    }

    public void setLanguage(String language) throws IOException {
        this.getOMDictionary().setString(OMName.LANG, language);
    }

    public String getAlternateDescription() {
        return this.getOMDictionary().getString(OMName.ALT);
    }

    public void setAlternateDescription(String alternateDescription) throws IOException {
        this.getOMDictionary().setString(OMName.ALT, alternateDescription);
    }

    public String getExpandedForm() {
        return this.getOMDictionary().getString(OMName.E);
    }

    public void setExpandedForm(String expandedForm) throws IOException {
        this.getOMDictionary().setString(OMName.E, expandedForm);
    }

    public String getActualText() {
        return this.getOMDictionary().getString(OMName.ACTUAL_TEXT);
    }

    public void setActualText(String actualText) throws IOException {
        this.getOMDictionary().setString(OMName.ACTUAL_TEXT, actualText);
    }

    public String getStandardStructureType() {
        Object mappedValue;
        String type = this.getStructureType();
        Map<String, Object> roleMap = this.getRoleMap();
        if (roleMap.containsKey(type) && (mappedValue = this.getRoleMap().get(type)) instanceof String) {
            type = (String)mappedValue;
        }
        return type;
    }

    public void appendKid(SMMarkedContent markedContent) {
        if (markedContent == null) {
            return;
        }
        this.appendKid(OMInteger.get(markedContent.getMCID()));
    }

    public void appendKid(SMMarkedContentReference markedContentReference) {
        this.appendObjectableKid(markedContentReference);
    }

    public void appendKid(SMObjectReference objectReference) {
        this.appendObjectableKid(objectReference);
    }

    public void insertBefore(OMInteger markedContentIdentifier, Object refKid) {
        this.insertBefore((OMBase)markedContentIdentifier, refKid);
    }

    public void insertBefore(SMMarkedContentReference markedContentReference, Object refKid) {
        this.insertObjectableBefore(markedContentReference, refKid);
    }

    public void insertBefore(SMObjectReference objectReference, Object refKid) {
        this.insertObjectableBefore(objectReference, refKid);
    }

    public void removeKid(OMInteger markedContentIdentifier) {
        this.removeKid((OMBase)markedContentIdentifier);
    }

    public void removeKid(SMMarkedContentReference markedContentReference) {
        this.removeObjectableKid(markedContentReference);
    }

    public void removeKid(SMObjectReference objectReference) {
        this.removeObjectableKid(objectReference);
    }

    private SMStructureTreeRoot getStructureTreeRoot() {
        SMStructureNode parent = this.getParent();
        while (parent instanceof SMStructureElement) {
            parent = ((SMStructureElement)parent).getParent();
        }
        if (parent instanceof SMStructureTreeRoot) {
            return (SMStructureTreeRoot)parent;
        }
        return null;
    }

    private Map<String, Object> getRoleMap() {
        SMStructureTreeRoot root = this.getStructureTreeRoot();
        if (root != null) {
            return root.getRoleMap();
        }
        return null;
    }
}

