/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.documentinterchange.logicalstructure;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMAttributeObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMDefaultAttributeObject
extends SMAttributeObject {
    public SMDefaultAttributeObject() {
    }

    public SMDefaultAttributeObject(OMDictionary dictionary) {
        super(dictionary);
    }

    public List<String> getAttributeNames() {
        ArrayList<String> attrNames = new ArrayList<String>();
        for (Map.Entry<OMName, OMBase> entry : this.getOMDictionary().entrySet()) {
            OMName key = entry.getKey();
            if (OMName.O.equals(key)) continue;
            attrNames.add(key.getName());
        }
        return attrNames;
    }

    public OMBase getAttributeValue(String attrName) {
        return this.getOMDictionary().getDictionaryObject(attrName);
    }

    protected OMBase getAttributeValue(String attrName, OMBase defaultValue) {
        OMBase value = this.getOMDictionary().getDictionaryObject(attrName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void setAttribute(String attrName, OMBase attrValue) {
        OMBase old = this.getAttributeValue(attrName);
        this.getOMDictionary().setItem(OMName.getPDFName(attrName), attrValue);
        this.potentiallyNotifyChanged(old, attrValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append(super.toString()).append(", attributes={");
        Iterator<String> it = this.getAttributeNames().iterator();
        while (it.hasNext()) {
            String name = it.next();
            sb.append(name).append('=').append(this.getAttributeValue(name));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append('}').toString();
    }
}

