/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.documentinterchange.logicalstructure;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.SMDictionaryWrapper;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMDefaultAttributeObject;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMStructureElement;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMUserAttributeObject;
import com.plpdf.smmodel.documentinterchange.taggedpdf.SMExportFormatAttributeObject;
import com.plpdf.smmodel.documentinterchange.taggedpdf.SMLayoutAttributeObject;
import com.plpdf.smmodel.documentinterchange.taggedpdf.SMListAttributeObject;
import com.plpdf.smmodel.documentinterchange.taggedpdf.SMPrintFieldAttributeObject;
import com.plpdf.smmodel.documentinterchange.taggedpdf.SMTableAttributeObject;

public abstract class SMAttributeObject
extends SMDictionaryWrapper {
    private SMStructureElement structureElement;

    public static SMAttributeObject create(OMDictionary dictionary) {
        String owner = dictionary.getNameAsString(OMName.O);
        if ("UserProperties".equals(owner)) {
            return new SMUserAttributeObject(dictionary);
        }
        if ("List".equals(owner)) {
            return new SMListAttributeObject(dictionary);
        }
        if ("PrintField".equals(owner)) {
            return new SMPrintFieldAttributeObject(dictionary);
        }
        if ("Table".equals(owner)) {
            return new SMTableAttributeObject(dictionary);
        }
        if ("Layout".equals(owner)) {
            return new SMLayoutAttributeObject(dictionary);
        }
        if ("XML-1.00".equals(owner) || "HTML-3.2".equals(owner) || "HTML-4.01".equals(owner) || "OEB-1.00".equals(owner) || "RTF-1.05".equals(owner) || "CSS-1.00".equals(owner) || "CSS-2.00".equals(owner)) {
            return new SMExportFormatAttributeObject(dictionary);
        }
        return new SMDefaultAttributeObject(dictionary);
    }

    private SMStructureElement getStructureElement() {
        return this.structureElement;
    }

    protected void setStructureElement(SMStructureElement structureElement) {
        this.structureElement = structureElement;
    }

    public SMAttributeObject() {
    }

    public SMAttributeObject(OMDictionary dictionary) {
        super(dictionary);
    }

    public String getOwner() {
        return this.getOMDictionary().getNameAsString(OMName.O);
    }

    protected void setOwner(String owner) {
        this.getOMDictionary().setName(OMName.O, owner);
    }

    public boolean isEmpty() {
        return this.getOMDictionary().size() == 1 && this.getOwner() != null;
    }

    protected void potentiallyNotifyChanged(OMBase oldBase, OMBase newBase) {
        if (this.isValueChanged(oldBase, newBase)) {
            this.notifyChanged();
        }
    }

    private boolean isValueChanged(OMBase oldValue, OMBase newValue) {
        if (oldValue == null) {
            return newValue != null;
        }
        return !oldValue.equals(newValue);
    }

    protected void notifyChanged() {
        if (this.getStructureElement() != null) {
            this.getStructureElement().attributeChanged(this);
        }
    }

    public String toString() {
        return "O=" + this.getOwner();
    }

    protected static String arrayToString(Object[] array) {
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(array[i]);
            ++i;
        }
        return sb.append(']').toString();
    }

    protected static String arrayToString(float[] array) {
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(array[i]);
            ++i;
        }
        return sb.append(']').toString();
    }
}

