/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common.function.type4;

import com.plpdf.smmodel.common.function.type4.ExecutionContext;
import com.plpdf.smmodel.common.function.type4.Operator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;

class StackOperators {
    StackOperators() {
    }

    static class Copy
    implements Operator {
        Copy() {
        }

        public void execute(ExecutionContext context) {
            Stack stack = context.getStack();
            int n = ((Number)stack.pop()).intValue();
            if (n > 0) {
                int size = stack.size();
                ArrayList copy = new ArrayList(stack.subList(size - n, size));
                stack.addAll(copy);
            }
        }
    }

    static class Dup
    implements Operator {
        Dup() {
        }

        public void execute(ExecutionContext context) {
            Stack stack = context.getStack();
            stack.push(stack.peek());
        }
    }

    static class Exch
    implements Operator {
        Exch() {
        }

        public void execute(ExecutionContext context) {
            Stack stack = context.getStack();
            Object any2 = stack.pop();
            Object any1 = stack.pop();
            stack.push(any2);
            stack.push(any1);
        }
    }

    static class Index
    implements Operator {
        Index() {
        }

        public void execute(ExecutionContext context) {
            Stack stack = context.getStack();
            int n = ((Number)stack.pop()).intValue();
            if (n < 0) {
                throw new IllegalArgumentException("rangecheck: " + n);
            }
            int size = stack.size();
            stack.push(stack.get(size - n - 1));
        }
    }

    static class Pop
    implements Operator {
        Pop() {
        }

        public void execute(ExecutionContext context) {
            Stack stack = context.getStack();
            stack.pop();
        }
    }

    static class Roll
    implements Operator {
        Roll() {
        }

        public void execute(ExecutionContext context) {
            Stack stack = context.getStack();
            int j = ((Number)stack.pop()).intValue();
            int n = ((Number)stack.pop()).intValue();
            if (j == 0) {
                return;
            }
            if (n < 0) {
                throw new IllegalArgumentException("rangecheck: " + n);
            }
            LinkedList rolled = new LinkedList();
            LinkedList moved = new LinkedList();
            if (j < 0) {
                int n1 = n + j;
                int i = 0;
                while (i < n1) {
                    moved.addFirst(stack.pop());
                    ++i;
                }
                i = j;
                while (i < 0) {
                    rolled.addFirst(stack.pop());
                    ++i;
                }
                stack.addAll(moved);
                stack.addAll(rolled);
            } else {
                int n1 = n - j;
                int i = j;
                while (i > 0) {
                    rolled.addFirst(stack.pop());
                    --i;
                }
                i = 0;
                while (i < n1) {
                    moved.addFirst(stack.pop());
                    ++i;
                }
                stack.addAll(rolled);
                stack.addAll(moved);
            }
        }
    }
}

