/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common.function;

import com.plpdf.om.OMBase;
import com.plpdf.smmodel.common.SMRange;
import com.plpdf.smmodel.common.function.SMFunction;
import com.plpdf.smmodel.common.function.type4.ExecutionContext;
import com.plpdf.smmodel.common.function.type4.InstructionSequence;
import com.plpdf.smmodel.common.function.type4.InstructionSequenceBuilder;
import com.plpdf.smmodel.common.function.type4.Operators;
import java.io.IOException;

public class SMFunctionType4
extends SMFunction {
    private static final Operators OPERATORS = new Operators();
    private final InstructionSequence instructions = InstructionSequenceBuilder.parse(this.getSMStream().getInputStreamAsString());

    public SMFunctionType4(OMBase functionStream) throws IOException {
        super(functionStream);
    }

    public int getFunctionType() {
        return 4;
    }

    public float[] eval(float[] input) throws IOException {
        int numberOfInputValues = input.length;
        ExecutionContext context = new ExecutionContext(OPERATORS);
        int i = numberOfInputValues - 1;
        while (i >= 0) {
            SMRange domain = this.getDomainForInput(i);
            float value = this.clipToRange(input[i], domain.getMin(), domain.getMax());
            context.getStack().push(Float.valueOf(value));
            --i;
        }
        this.instructions.execute(context);
        int numberOfOutputValues = this.getNumberOfOutputParameters();
        int numberOfActualOutputValues = context.getStack().size();
        if (numberOfActualOutputValues < numberOfOutputValues) {
            throw new IllegalStateException("The type 4 function returned " + numberOfActualOutputValues + " values but the Range entry indicates that " + numberOfOutputValues + " values be returned.");
        }
        float[] outputValues = new float[numberOfOutputValues];
        int i2 = numberOfOutputValues - 1;
        while (i2 >= 0) {
            SMRange range = this.getRangeForOutput(i2);
            outputValues[i2] = context.popReal();
            outputValues[i2] = this.clipToRange(outputValues[i2], range.getMin(), range.getMax());
            --i2;
        }
        return outputValues;
    }
}

