/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common.function;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.SMRange;
import com.plpdf.smmodel.common.function.SMFunction;
import java.io.IOException;

public class SMFunctionType3
extends SMFunction {
    private OMArray functions = null;
    private OMArray encode = null;
    private OMArray bounds = null;

    public SMFunctionType3(OMBase functionStream) {
        super(functionStream);
    }

    public int getFunctionType() {
        return 3;
    }

    public float[] eval(float[] input) throws IOException {
        SMFunction function = null;
        float x = input[0];
        SMRange domain = this.getDomainForInput(0);
        x = this.clipToRange(x, domain.getMin(), domain.getMax());
        OMArray functionsArray = this.getFunctions();
        int numberOfFunctions = functionsArray.size();
        if (numberOfFunctions == 1) {
            function = SMFunction.create(functionsArray.get(0));
            SMRange encRange = this.getEncodeForParameter(0);
            x = this.interpolate(x, domain.getMin(), domain.getMax(), encRange.getMin(), encRange.getMax());
        } else {
            float[] boundsValues = this.getBounds().toFloatArray();
            int boundsSize = boundsValues.length;
            float[] partitionValues = new float[boundsSize + 2];
            int partitionValuesSize = partitionValues.length;
            partitionValues[0] = domain.getMin();
            partitionValues[partitionValuesSize - 1] = domain.getMax();
            System.arraycopy(boundsValues, 0, partitionValues, 1, boundsSize);
            int i = 0;
            while (i < partitionValuesSize - 1) {
                if (x >= partitionValues[i] && (x < partitionValues[i + 1] || i == partitionValuesSize - 2 && x == partitionValues[i + 1])) {
                    function = SMFunction.create(functionsArray.get(i));
                    SMRange encRange = this.getEncodeForParameter(i);
                    x = this.interpolate(x, partitionValues[i], partitionValues[i + 1], encRange.getMin(), encRange.getMax());
                    break;
                }
                ++i;
            }
        }
        float[] functionValues = new float[]{x};
        float[] functionResult = function.eval(functionValues);
        return this.clipToRange(functionResult);
    }

    public OMArray getFunctions() {
        if (this.functions == null) {
            this.functions = (OMArray)this.getDictionary().getDictionaryObject(OMName.FUNCTIONS);
        }
        return this.functions;
    }

    public OMArray getBounds() {
        if (this.bounds == null) {
            this.bounds = (OMArray)this.getDictionary().getDictionaryObject(OMName.BOUNDS);
        }
        return this.bounds;
    }

    public OMArray getEncode() {
        if (this.encode == null) {
            this.encode = (OMArray)this.getDictionary().getDictionaryObject(OMName.ENCODE);
        }
        return this.encode;
    }

    private SMRange getEncodeForParameter(int n) {
        OMArray encodeValues = this.getEncode();
        return new SMRange(encodeValues, n);
    }
}

