/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common.function;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.common.function.SMFunction;
import java.io.IOException;

public class SMFunctionType2
extends SMFunction {
    private OMArray C0;
    private OMArray C1;

    public SMFunctionType2(OMBase function) {
        super(function);
    }

    public int getFunctionType() {
        return 2;
    }

    public float[] eval(float[] input) throws IOException {
        double inputValue = input[0];
        double exponent = this.getN();
        OMArray c0 = this.getC0();
        OMArray c1 = this.getC1();
        int c0Size = c0.size();
        float[] functionResult = new float[c0Size];
        int j = 0;
        while (j < c0Size) {
            functionResult[j] = ((OMNumber)c0.get(j)).floatValue() + (float)Math.pow(inputValue, exponent) * (((OMNumber)c1.get(j)).floatValue() - ((OMNumber)c0.get(j)).floatValue());
            ++j;
        }
        return this.clipToRange(functionResult);
    }

    public OMArray getC0() {
        if (this.C0 == null) {
            this.C0 = (OMArray)this.getDictionary().getDictionaryObject(OMName.C0);
            if (this.C0 == null) {
                this.C0 = new OMArray();
                this.C0.add(new OMFloat(0.0f));
            }
        }
        return this.C0;
    }

    public OMArray getC1() {
        if (this.C1 == null) {
            this.C1 = (OMArray)this.getDictionary().getDictionaryObject(OMName.C1);
            if (this.C1 == null) {
                this.C1 = new OMArray();
                this.C1.add(new OMFloat(1.0f));
            }
        }
        return this.C1;
    }

    public float getN() {
        return this.getDictionary().getFloat(OMName.N);
    }
}

