/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common.function;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.SMRange;
import com.plpdf.smmodel.common.function.SMFunction;
import java.io.IOException;

public class SMFunctionType0
extends SMFunction {
    private OMArray encode = null;
    private OMArray decode = null;
    private OMArray size = null;
    private int[][] samples = null;

    public SMFunctionType0(OMBase function) {
        super(function);
    }

    public int getFunctionType() {
        return 0;
    }

    public OMArray getSize() {
        if (this.size == null) {
            this.size = (OMArray)this.getDictionary().getDictionaryObject(OMName.SIZE);
        }
        return this.size;
    }

    public int[][] getSamples() {
        if (this.samples == null) {
            int arraySize = 1;
            int numberOfInputValues = this.getNumberOfInputParameters();
            int numberOfOutputValues = this.getNumberOfOutputParameters();
            OMArray sizes = this.getSize();
            int i = 0;
            while (i < numberOfInputValues) {
                arraySize *= sizes.getInt(i);
                ++i;
            }
            this.samples = new int[arraySize][this.getNumberOfOutputParameters()];
            int bitsPerSample = this.getBitsPerSample();
            int index = 0;
            int arrayIndex = 0;
            try {
                byte[] samplesArray = this.getSMStream().getByteArray();
                int i2 = 0;
                while (i2 < numberOfInputValues) {
                    int sizeInputValues = sizes.getInt(i2);
                    int j = 0;
                    while (j < sizeInputValues) {
                        int bitsLeft = 0;
                        int bitsToRead = bitsPerSample;
                        int currentValue = 0;
                        int k = 0;
                        while (k < numberOfOutputValues) {
                            if (bitsLeft == 0) {
                                currentValue = (samplesArray[arrayIndex++] + 256) % 256;
                                bitsLeft = 8;
                            }
                            int value = 0;
                            while (bitsToRead > 0) {
                                int bits = Math.min(bitsToRead, bitsLeft);
                                value <<= bits;
                                int valueToAdd = currentValue >> 8 - bits;
                                value |= valueToAdd;
                                if ((bitsLeft -= bits) != 0 || (bitsToRead -= bits) <= 0) continue;
                                currentValue = (samplesArray[arrayIndex++] + 256) % 256;
                                bitsLeft = 8;
                            }
                            this.samples[index][k] = value;
                            bitsToRead = bitsPerSample;
                            ++k;
                        }
                        ++index;
                        ++j;
                    }
                    ++i2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.samples;
    }

    public int getBitsPerSample() {
        return this.getDictionary().getInt(OMName.BITS_PER_SAMPLE);
    }

    public void setBitsPerSample(int bps) {
        this.getDictionary().setInt(OMName.BITS_PER_SAMPLE, bps);
    }

    private OMArray getEncodeValues() {
        if (this.encode == null) {
            this.encode = (OMArray)this.getDictionary().getDictionaryObject(OMName.ENCODE);
            if (this.encode == null) {
                this.encode = new OMArray();
                OMArray sizeValues = this.getSize();
                int sizeValuesSize = sizeValues.size();
                int i = 0;
                while (i < sizeValuesSize) {
                    this.encode.add(OMInteger.ZERO);
                    this.encode.add(OMInteger.get(sizeValues.getInt(i) - 1));
                    ++i;
                }
            }
        }
        return this.encode;
    }

    private OMArray getDecodeValues() {
        if (this.decode == null) {
            this.decode = (OMArray)this.getDictionary().getDictionaryObject(OMName.DECODE);
            if (this.decode == null) {
                this.decode = this.getRangeValues();
            }
        }
        return this.decode;
    }

    public SMRange getEncodeForParameter(int paramNum) {
        SMRange retval = null;
        OMArray encodeValues = this.getEncodeValues();
        if (encodeValues != null && encodeValues.size() >= paramNum * 2 + 1) {
            retval = new SMRange(encodeValues, paramNum);
        }
        return retval;
    }

    public void setEncodeValues(OMArray encodeValues) {
        this.encode = encodeValues;
        this.getDictionary().setItem(OMName.ENCODE, (OMBase)encodeValues);
    }

    public SMRange getDecodeForParameter(int paramNum) {
        SMRange retval = null;
        OMArray decodeValues = this.getDecodeValues();
        if (decodeValues != null && decodeValues.size() >= paramNum * 2 + 1) {
            retval = new SMRange(decodeValues, paramNum);
        }
        return retval;
    }

    public void setDecodeValues(OMArray decodeValues) {
        this.decode = decodeValues;
        this.getDictionary().setItem(OMName.DECODE, (OMBase)decodeValues);
    }

    public float[] eval(float[] input) throws IOException {
        float[] sizeValues = this.getSize().toFloatArray();
        int bitsPerSample = this.getBitsPerSample();
        int numberOfInputValues = input.length;
        int numberOfOutputValues = this.getNumberOfOutputParameters();
        int intInputValuesPrevious = 0;
        int intInputValuesNext = 0;
        int i = 0;
        while (i < numberOfInputValues) {
            SMRange domain = this.getDomainForInput(i);
            SMRange encode = this.getEncodeForParameter(i);
            input[i] = this.clipToRange(input[i], domain.getMin(), domain.getMax());
            input[i] = this.interpolate(input[i], domain.getMin(), domain.getMax(), encode.getMin(), encode.getMax());
            input[i] = this.clipToRange(input[i], 0.0f, sizeValues[i] - 1.0f);
            intInputValuesPrevious += (int)Math.floor(input[i]);
            intInputValuesNext += (int)Math.ceil(input[i]);
            ++i;
        }
        float[] outputValuesPrevious = null;
        float[] outputValuesNext = null;
        outputValuesPrevious = this.getSample(intInputValuesPrevious);
        outputValuesNext = this.getSample(intInputValuesNext);
        float[] outputValues = new float[numberOfOutputValues];
        int i2 = 0;
        while (i2 < numberOfOutputValues) {
            SMRange range = this.getRangeForOutput(i2);
            SMRange decode = this.getDecodeForParameter(i2);
            outputValues[i2] = (outputValuesPrevious[i2] + outputValuesNext[i2]) / 2.0f;
            outputValues[i2] = this.interpolate(outputValues[i2], 0.0f, (float)Math.pow(2.0, bitsPerSample), decode.getMin(), decode.getMax());
            outputValues[i2] = this.clipToRange(outputValues[i2], range.getMin(), range.getMax());
            ++i2;
        }
        return outputValues;
    }

    private float[] getSample(int indexValue) {
        int[] sampleValues = this.getSamples()[indexValue];
        int numberOfValues = sampleValues.length;
        float[] result = new float[numberOfValues];
        int i = 0;
        while (i < numberOfValues) {
            result[i] = sampleValues[i];
            ++i;
        }
        return result;
    }
}

