/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common.function;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRange;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.common.function.SMFunctionType0;
import com.plpdf.smmodel.common.function.SMFunctionType2;
import com.plpdf.smmodel.common.function.SMFunctionType3;
import com.plpdf.smmodel.common.function.SMFunctionType4;
import java.io.IOException;

public abstract class SMFunction
implements OMObjectable {
    private static final String CLASS_NAME = SMFunction.class.getName();
    private SMStream functionStream = null;
    private OMDictionary functionDictionary = null;
    private OMArray domain = null;
    private OMArray range = null;
    private int numberOfInputValues = -1;
    private int numberOfOutputValues = -1;

    public SMFunction(OMBase function) {
        if (function instanceof OMStream) {
            this.functionStream = new SMStream((OMStream)function);
            this.functionStream.getStream().setItem(OMName.TYPE, (OMBase)OMName.FUNCTION);
        } else if (function instanceof OMDictionary) {
            this.functionDictionary = (OMDictionary)function;
        }
    }

    public abstract int getFunctionType();

    public OMBase getOMObject() {
        if (this.functionStream != null) {
            return this.functionStream.getOMObject();
        }
        return this.functionDictionary;
    }

    public OMDictionary getDictionary() {
        if (this.functionStream != null) {
            return this.functionStream.getStream();
        }
        return this.functionDictionary;
    }

    protected SMStream getSMStream() {
        return this.functionStream;
    }

    public static SMFunction create(OMBase function) throws IOException {
        OMDictionary functionDictionary;
        int functionType;
        SMFunction retval = null;
        if (function instanceof OMObject) {
            function = ((OMObject)function).getObject();
        }
        if ((functionType = (functionDictionary = (OMDictionary)function).getInt(OMName.FUNCTION_TYPE)) == 0) {
            retval = new SMFunctionType0(functionDictionary);
        } else if (functionType == 2) {
            retval = new SMFunctionType2(functionDictionary);
        } else if (functionType == 3) {
            retval = new SMFunctionType3(functionDictionary);
        } else if (functionType == 4) {
            retval = new SMFunctionType4(functionDictionary);
        } else {
            throw new IOException("Error: Unknown function type " + functionType);
        }
        return retval;
    }

    public int getNumberOfOutputParameters() {
        if (this.numberOfOutputValues == -1) {
            OMArray rangeValues = this.getRangeValues();
            this.numberOfOutputValues = rangeValues.size() / 2;
        }
        return this.numberOfOutputValues;
    }

    public SMRange getRangeForOutput(int n) {
        OMArray rangeValues = this.getRangeValues();
        return new SMRange(rangeValues, n);
    }

    public void setRangeValues(OMArray rangeValues) {
        this.range = rangeValues;
        this.getDictionary().setItem(OMName.RANGE, (OMBase)rangeValues);
    }

    public int getNumberOfInputParameters() {
        if (this.numberOfInputValues == -1) {
            OMArray array = this.getDomainValues();
            this.numberOfInputValues = array.size() / 2;
        }
        return this.numberOfInputValues;
    }

    public SMRange getDomainForInput(int n) {
        OMArray domainValues = this.getDomainValues();
        return new SMRange(domainValues, n);
    }

    public void setDomainValues(OMArray domainValues) {
        this.domain = domainValues;
        this.getDictionary().setItem(OMName.DOMAIN, (OMBase)domainValues);
    }

    public OMArray eval(OMArray input) throws IOException {
        float[] outputValues = this.eval(input.toFloatArray());
        OMArray array = new OMArray();
        array.setFloatArray(outputValues);
        return array;
    }

    public abstract float[] eval(float[] var1) throws IOException;

    protected OMArray getRangeValues() {
        if (this.range == null) {
            this.range = (OMArray)this.getDictionary().getDictionaryObject(OMName.RANGE);
        }
        return this.range;
    }

    private OMArray getDomainValues() {
        if (this.domain == null) {
            this.domain = (OMArray)this.getDictionary().getDictionaryObject(OMName.DOMAIN);
        }
        return this.domain;
    }

    protected float[] clipToRange(float[] inputValues) {
        OMArray rangesArray = this.getRangeValues();
        float[] result = null;
        if (rangesArray != null) {
            float[] rangeValues = rangesArray.toFloatArray();
            int numberOfRanges = rangeValues.length / 2;
            result = new float[numberOfRanges];
            int i = 0;
            while (i < numberOfRanges) {
                result[i] = this.clipToRange(inputValues[i], rangeValues[2 * i], rangeValues[2 * i + 1]);
                ++i;
            }
        } else {
            result = inputValues;
        }
        return result;
    }

    protected float clipToRange(float x, float rangeMin, float rangeMax) {
        return Math.min(Math.max(x, rangeMin), rangeMax);
    }

    protected float interpolate(float x, float xRangeMin, float xRangeMax, float yRangeMin, float yRangeMax) {
        return yRangeMin + (x - xRangeMin) * (yRangeMax - yRangeMin) / (xRangeMax - xRangeMin);
    }
}

