/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common.filespecification;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.filespecification.SMEmbeddedFile;
import com.plpdf.smmodel.common.filespecification.SMFileSpecification;
import java.io.IOException;

public class SMComplexFileSpecification
extends SMFileSpecification {
    private OMDictionary fs;

    public SMComplexFileSpecification() {
        this.fs = new OMDictionary();
        this.fs.setItem(OMName.TYPE, (OMBase)OMName.FILESPEC);
    }

    public SMComplexFileSpecification(OMDictionary dict) {
        this.fs = dict;
    }

    public OMBase getOMObject() {
        return this.fs;
    }

    public OMDictionary getOMDictionary() {
        return this.fs;
    }

    public String getFilename() {
        if (this.getUnicodeFile() != null) {
            return this.getUnicodeFile();
        }
        if (this.getFileDos() != null) {
            return this.getFileDos();
        }
        if (this.getFileMac() != null) {
            return this.getFileMac();
        }
        if (this.getFileUnix() != null) {
            return this.getFileUnix();
        }
        return this.getFile();
    }

    public String getUnicodeFile() {
        return this.fs.getString(OMName.UF);
    }

    public String getFile() {
        return this.fs.getString(OMName.F);
    }

    public void setFile(String file) throws IOException {
        this.fs.setString(OMName.F, file);
    }

    public String getFileDos() {
        return this.fs.getString(OMName.DOS);
    }

    public void setFileDos(String file) throws IOException {
        this.fs.setString(OMName.DOS, file);
    }

    public String getFileMac() {
        return this.fs.getString(OMName.MAC);
    }

    public void setFileMac(String file) throws IOException {
        this.fs.setString(OMName.MAC, file);
    }

    public String getFileUnix() {
        return this.fs.getString(OMName.UNIX);
    }

    public void setFileUnix(String file) throws IOException {
        this.fs.setString(OMName.UNIX, file);
    }

    public void setVolatile(boolean fileIsVolatile) {
        this.fs.setBoolean(OMName.V, fileIsVolatile);
    }

    public boolean isVolatile() {
        return this.fs.getBoolean(OMName.V, false);
    }

    public SMEmbeddedFile getEmbeddedFile() {
        SMEmbeddedFile file = null;
        OMStream stream = (OMStream)this.fs.getObjectFromPath("EF/F");
        if (stream != null) {
            file = new SMEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFile(SMEmbeddedFile file) {
        OMDictionary ef = (OMDictionary)this.fs.getDictionaryObject(OMName.EF);
        if (ef == null && file != null) {
            ef = new OMDictionary();
            this.fs.setItem(OMName.EF, (OMBase)ef);
        }
        if (ef != null) {
            ef.setItem(OMName.F, (OMObjectable)file);
        }
    }

    public SMEmbeddedFile getEmbeddedFileDos() {
        SMEmbeddedFile file = null;
        OMStream stream = (OMStream)this.fs.getObjectFromPath("EF/DOS");
        if (stream != null) {
            file = new SMEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFileDos(SMEmbeddedFile file) {
        OMDictionary ef = (OMDictionary)this.fs.getDictionaryObject(OMName.DOS);
        if (ef == null && file != null) {
            ef = new OMDictionary();
            this.fs.setItem(OMName.EF, (OMBase)ef);
        }
        if (ef != null) {
            ef.setItem(OMName.DOS, (OMObjectable)file);
        }
    }

    public SMEmbeddedFile getEmbeddedFileMac() {
        SMEmbeddedFile file = null;
        OMStream stream = (OMStream)this.fs.getObjectFromPath("EF/Mac");
        if (stream != null) {
            file = new SMEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFileMac(SMEmbeddedFile file) {
        OMDictionary ef = (OMDictionary)this.fs.getDictionaryObject(OMName.MAC);
        if (ef == null && file != null) {
            ef = new OMDictionary();
            this.fs.setItem(OMName.EF, (OMBase)ef);
        }
        if (ef != null) {
            ef.setItem(OMName.MAC, (OMObjectable)file);
        }
    }

    public SMEmbeddedFile getEmbeddedFileUnix() {
        SMEmbeddedFile file = null;
        OMStream stream = (OMStream)this.fs.getObjectFromPath("EF/Unix");
        if (stream != null) {
            file = new SMEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFileUnix(SMEmbeddedFile file) {
        OMDictionary ef = (OMDictionary)this.fs.getDictionaryObject(OMName.UNIX);
        if (ef == null && file != null) {
            ef = new OMDictionary();
            this.fs.setItem(OMName.EF, (OMBase)ef);
        }
        if (ef != null) {
            ef.setItem(OMName.UNIX, (OMObjectable)file);
        }
    }

    public void setFileDescription(String description) throws IOException {
        this.fs.setString(OMName.DESC, description);
    }

    public String getFileDescription() {
        return this.fs.getString(OMName.DESC);
    }
}

