/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMObjectable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SMTextStream
implements OMObjectable {
    private OMString string;
    private OMStream stream;

    public SMTextStream(OMString str) {
        this.string = str;
    }

    public SMTextStream(String str) {
        this.string = new OMString(str);
    }

    public SMTextStream(OMStream str) {
        this.stream = str;
    }

    public static SMTextStream createTextStream(OMBase base) {
        SMTextStream retval = null;
        if (base instanceof OMString) {
            retval = new SMTextStream((OMString)base);
        } else if (base instanceof OMStream) {
            retval = new SMTextStream((OMStream)base);
        }
        return retval;
    }

    public OMBase getOMObject() {
        OMBase retval = null;
        retval = this.string == null ? this.stream : this.string;
        return retval;
    }

    public String getAsString() throws IOException {
        String retval = null;
        if (this.string != null) {
            retval = this.string.getString();
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int amountRead = -1;
            InputStream is = this.stream.getUnfilteredStream();
            while ((amountRead = is.read(buffer)) != -1) {
                out.write(buffer, 0, amountRead);
            }
            retval = new String(out.toByteArray(), "ISO-8859-1");
        }
        return retval;
    }

    public InputStream getAsStream() throws IOException {
        InputStream retval = null;
        retval = this.string != null ? new ByteArrayInputStream(this.string.getBytes()) : this.stream.getUnfilteredStream();
        return retval;
    }
}

