/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common;

import com.plpdf.filter.Filter;
import com.plpdf.filter.FilterManager;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNull;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMDictionaryMap;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.OMStreamArray;
import com.plpdf.smmodel.common.SMMetadata;
import com.plpdf.smmodel.common.filespecification.SMFileSpecification;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMStream
implements OMObjectable {
    private OMStream stream;

    protected SMStream() {
    }

    public SMStream(SMDocument document) {
        this.stream = document.getDocument().createOMStream();
    }

    public SMStream(OMStream str) {
        this.stream = str;
    }

    public SMStream(SMDocument doc, InputStream str) throws IOException {
        this(doc, str, false);
    }

    public SMStream(SMDocument doc, InputStream str, boolean filtered) throws IOException {
        OutputStream output = null;
        try {
            this.stream = doc.getDocument().createOMStream();
            output = filtered ? this.stream.createFilteredStream() : this.stream.createUnfilteredStream();
            byte[] buffer = new byte[1024];
            int amountRead = -1;
            while ((amountRead = str.read(buffer)) != -1) {
                output.write(buffer, 0, amountRead);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (str != null) {
                str.close();
            }
        }
    }

    public void addCompression() {
        List<OMName> filters = this.getFilters();
        if (filters == null) {
            filters = new ArrayList<OMName>();
            filters.add(OMName.FLATE_DECODE);
            this.setFilters(filters);
        }
    }

    public static SMStream createFromOM(OMBase base) throws IOException {
        SMStream retval = null;
        if (base instanceof OMStream) {
            retval = new SMStream((OMStream)base);
        } else if (base instanceof OMArray) {
            if (((OMArray)base).size() > 0) {
                retval = new SMStream(new OMStreamArray((OMArray)base));
            }
        } else if (base != null) {
            throw new IOException("Contents are unknown type:" + base.getClass().getName());
        }
        return retval;
    }

    @Override
    public OMBase getOMObject() {
        return this.stream;
    }

    public OutputStream createOutputStream() throws IOException {
        return this.stream.createUnfilteredStream();
    }

    public InputStream createInputStream() throws IOException {
        return this.stream.getUnfilteredStream();
    }

    public InputStream getPartiallyFilteredStream(List<String> stopFilters) throws IOException {
        FilterManager manager = this.stream.getFilterManager();
        InputStream is = this.stream.getFilteredStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        List<OMName> filters = this.getFilters();
        OMName nextFilter = null;
        boolean done = false;
        int i = 0;
        while (i < filters.size() && !done) {
            os.reset();
            nextFilter = filters.get(i);
            if (stopFilters.contains(nextFilter.getName())) {
                done = true;
            } else {
                Filter filter = manager.getFilter(nextFilter);
                filter.decode(is, os, this.stream, i);
                is = new ByteArrayInputStream(os.toByteArray());
            }
            ++i;
        }
        return is;
    }

    public OMStream getStream() {
        return this.stream;
    }

    public int getLength() {
        return this.stream.getInt(OMName.LENGTH, 0);
    }

    public List<OMName> getFilters() {
        List<?> retval = null;
        OMBase filters = this.stream.getFilters();
        if (filters instanceof OMName) {
            OMName name = (OMName)filters;
            retval = new OMArrayList<OMName>(name, (OMBase)name, (OMDictionary)this.stream, OMName.FILTER);
        } else if (filters instanceof OMArray) {
            retval = ((OMArray)filters).toList();
        }
        return retval;
    }

    public void setFilters(List<OMName> filters) {
        OMArray obj = OMArrayList.converterToOMArray(filters);
        this.stream.setItem(OMName.FILTER, (OMBase)obj);
    }

    public List<Object> getDecodeParms() throws IOException {
        OMArrayList<OMDictionaryMap<String, Object>> retval = null;
        OMBase dp = this.stream.getDictionaryObject(OMName.DECODE_PARMS);
        if (dp == null) {
            dp = this.stream.getDictionaryObject(OMName.DP);
        }
        if (dp instanceof OMDictionary) {
            OMDictionaryMap<String, Object> map = OMDictionaryMap.convertBasicTypesToMap((OMDictionary)dp);
            retval = new OMArrayList<OMDictionaryMap<String, Object>>(map, dp, (OMDictionary)this.stream, OMName.DECODE_PARMS);
        } else if (dp instanceof OMArray) {
            OMArray array = (OMArray)dp;
            ArrayList<OMDictionaryMap<String, Object>> actuals = new ArrayList<OMDictionaryMap<String, Object>>();
            int i = 0;
            while (i < array.size()) {
                actuals.add(OMDictionaryMap.convertBasicTypesToMap((OMDictionary)array.getObject(i)));
                ++i;
            }
            retval = new OMArrayList(actuals, array);
        }
        return retval;
    }

    public void setDecodeParms(List<?> decodeParams) {
        this.stream.setItem(OMName.DECODE_PARMS, (OMBase)OMArrayList.converterToOMArray(decodeParams));
    }

    public SMFileSpecification getFile() throws IOException {
        OMBase f = this.stream.getDictionaryObject(OMName.F);
        SMFileSpecification retval = SMFileSpecification.createFS(f);
        return retval;
    }

    public void setFile(SMFileSpecification f) {
        this.stream.setItem(OMName.F, (OMObjectable)f);
    }

    public List<String> getFileFilters() {
        List<String> retval = null;
        OMBase filters = this.stream.getDictionaryObject(OMName.F_FILTER);
        if (filters instanceof OMName) {
            OMName name = (OMName)filters;
            retval = new OMArrayList<String>(name.getName(), (OMBase)name, (OMDictionary)this.stream, OMName.F_FILTER);
        } else if (filters instanceof OMArray) {
            retval = OMArrayList.convertOMNameOMArrayToList((OMArray)filters);
        }
        return retval;
    }

    public void setFileFilters(List<String> filters) {
        OMArray obj = OMArrayList.convertStringListToOMNameOMArray(filters);
        this.stream.setItem(OMName.F_FILTER, (OMBase)obj);
    }

    public List<Object> getFileDecodeParams() throws IOException {
        OMArrayList<OMDictionaryMap<String, Object>> retval = null;
        OMBase dp = this.stream.getDictionaryObject(OMName.F_DECODE_PARMS);
        if (dp instanceof OMDictionary) {
            OMDictionaryMap<String, Object> map = OMDictionaryMap.convertBasicTypesToMap((OMDictionary)dp);
            retval = new OMArrayList<OMDictionaryMap<String, Object>>(map, dp, (OMDictionary)this.stream, OMName.F_DECODE_PARMS);
        } else if (dp instanceof OMArray) {
            OMArray array = (OMArray)dp;
            ArrayList<OMDictionaryMap<String, Object>> actuals = new ArrayList<OMDictionaryMap<String, Object>>();
            int i = 0;
            while (i < array.size()) {
                actuals.add(OMDictionaryMap.convertBasicTypesToMap((OMDictionary)array.getObject(i)));
                ++i;
            }
            retval = new OMArrayList(actuals, array);
        }
        return retval;
    }

    public void setFileDecodeParams(List<?> decodeParams) {
        this.stream.setItem("FDecodeParams", (OMBase)OMArrayList.converterToOMArray(decodeParams));
    }

    public byte[] getByteArray() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        InputStream is = null;
        try {
            is = this.createInputStream();
            int amountRead = -1;
            while ((amountRead = is.read(buf)) != -1) {
                output.write(buf, 0, amountRead);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return output.toByteArray();
    }

    public String getInputStreamAsString() throws IOException {
        byte[] bStream = this.getByteArray();
        return new String(bStream, "ISO-8859-1");
    }

    public SMMetadata getMetadata() {
        SMMetadata retval = null;
        OMBase mdStream = this.stream.getDictionaryObject(OMName.METADATA);
        if (mdStream != null) {
            if (mdStream instanceof OMStream) {
                retval = new SMMetadata((OMStream)mdStream);
            } else if (!(mdStream instanceof OMNull)) {
                throw new IllegalStateException("Expected a OMStream but was a " + mdStream.getClass().getSimpleName());
            }
        }
        return retval;
    }

    public void setMetadata(SMMetadata meta) {
        this.stream.setItem(OMName.METADATA, (OMObjectable)meta);
    }

    public int getDecodedStreamLength() {
        return this.stream.getInt(OMName.DL);
    }

    public void setDecodedStreamLength(int decodedStreamLength) {
        this.stream.setInt(OMName.DL, decodedStreamLength);
    }

    public SMStream(SMDocument doc, byte[] data, boolean filtered) throws IOException {
        this(doc, new ByteArrayInputStream(data), filtered);
    }

    public void setFilter(OMName filter) {
        this.stream.setItem("Filter", (OMBase)filter);
    }
}

