/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common;

import com.plpdf.font.util.BoundingBox;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.common.OMObjectable;
import java.awt.Dimension;

public class SMRectangle
implements OMObjectable {
    private OMArray rectArray;

    public SMRectangle() {
        this.rectArray = new OMArray();
        this.rectArray.add(new OMFloat(0.0f));
        this.rectArray.add(new OMFloat(0.0f));
        this.rectArray.add(new OMFloat(0.0f));
        this.rectArray.add(new OMFloat(0.0f));
    }

    public SMRectangle(float width, float height) {
        this.rectArray = new OMArray();
        this.rectArray.add(new OMFloat(0.0f));
        this.rectArray.add(new OMFloat(0.0f));
        this.rectArray.add(new OMFloat(width));
        this.rectArray.add(new OMFloat(height));
    }

    public SMRectangle(BoundingBox box) {
        this.rectArray = new OMArray();
        this.rectArray.add(new OMFloat(box.getLowerLeftX()));
        this.rectArray.add(new OMFloat(box.getLowerLeftY()));
        this.rectArray.add(new OMFloat(box.getUpperRightX()));
        this.rectArray.add(new OMFloat(box.getUpperRightY()));
    }

    public SMRectangle(OMArray array) {
        this.rectArray = array;
    }

    public boolean contains(float x, float y) {
        float llx = this.getLowerLeftX();
        float urx = this.getUpperRightX();
        float lly = this.getLowerLeftY();
        float ury = this.getUpperRightY();
        return x >= llx && x <= urx && y >= lly && y <= ury;
    }

    public SMRectangle createRetranslatedRectangle() {
        SMRectangle retval = new SMRectangle();
        retval.setUpperRightX(this.getWidth());
        retval.setUpperRightY(this.getHeight());
        return retval;
    }

    public OMArray getOMArray() {
        return this.rectArray;
    }

    public float getLowerLeftX() {
        return ((OMNumber)this.rectArray.get(0)).floatValue();
    }

    public void setLowerLeftX(float value) {
        this.rectArray.set(0, new OMFloat(value));
    }

    public float getLowerLeftY() {
        return ((OMNumber)this.rectArray.get(1)).floatValue();
    }

    public void setLowerLeftY(float value) {
        this.rectArray.set(1, new OMFloat(value));
    }

    public float getUpperRightX() {
        return ((OMNumber)this.rectArray.get(2)).floatValue();
    }

    public void setUpperRightX(float value) {
        this.rectArray.set(2, new OMFloat(value));
    }

    public float getUpperRightY() {
        return ((OMNumber)this.rectArray.get(3)).floatValue();
    }

    public void setUpperRightY(float value) {
        this.rectArray.set(3, new OMFloat(value));
    }

    public float getWidth() {
        return this.getUpperRightX() - this.getLowerLeftX();
    }

    public float getHeight() {
        return this.getUpperRightY() - this.getLowerLeftY();
    }

    public Dimension createDimension() {
        return new Dimension((int)this.getWidth(), (int)this.getHeight());
    }

    public void move(float horizontalAmount, float verticalAmount) {
        this.setUpperRightX(this.getUpperRightX() + horizontalAmount);
        this.setLowerLeftX(this.getLowerLeftX() + horizontalAmount);
        this.setUpperRightY(this.getUpperRightY() + verticalAmount);
        this.setLowerLeftY(this.getLowerLeftY() + verticalAmount);
    }

    public OMBase getOMObject() {
        return this.rectArray;
    }

    public String toString() {
        return "[" + this.getLowerLeftX() + "," + this.getLowerLeftY() + "," + this.getUpperRightX() + "," + this.getUpperRightY() + "]";
    }
}

