/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMNumberTreeNode;
import com.plpdf.smmodel.common.SMPageLabelRange;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMPageLabels
implements OMObjectable {
    private SortedMap<Integer, SMPageLabelRange> labels = new TreeMap<Integer, SMPageLabelRange>();
    private SMDocument doc;

    public SMPageLabels(SMDocument document) {
        this.doc = document;
        SMPageLabelRange defaultRange = new SMPageLabelRange();
        defaultRange.setStyle("D");
        this.labels.put(0, defaultRange);
    }

    public SMPageLabels(SMDocument document, OMDictionary dict) throws IOException {
        this(document);
        if (dict == null) {
            return;
        }
        SMNumberTreeNode root = new SMNumberTreeNode(dict, OMDictionary.class);
        this.findLabels(root);
    }

    private void findLabels(SMNumberTreeNode node) throws IOException {
        block3: {
            block2: {
                if (node.getKids() == null) break block2;
                List<SMNumberTreeNode> kids = node.getKids();
                for (SMNumberTreeNode kid : kids) {
                    this.findLabels(kid);
                }
                break block3;
            }
            if (node.getNumbers() == null) break block3;
            Map<Integer, OMObjectable> numbers = node.getNumbers();
            for (Map.Entry<Integer, OMObjectable> i : numbers.entrySet()) {
                if (i.getKey() < 0) continue;
                this.labels.put(i.getKey(), new SMPageLabelRange((OMDictionary)i.getValue()));
            }
        }
    }

    public int getPageRangeCount() {
        return this.labels.size();
    }

    public SMPageLabelRange getPageLabelRange(int startPage) {
        return (SMPageLabelRange)this.labels.get(startPage);
    }

    public void setLabelItem(int startPage, SMPageLabelRange item) {
        this.labels.put(startPage, item);
    }

    @Override
    public OMBase getOMObject() {
        OMDictionary dict = new OMDictionary();
        OMArray arr = new OMArray();
        for (Map.Entry<Integer, SMPageLabelRange> i : this.labels.entrySet()) {
            arr.add(OMInteger.get(i.getKey().intValue()));
            arr.add(i.getValue());
        }
        dict.setItem(OMName.NUMS, (OMBase)arr);
        return dict;
    }

    public Map<String, Integer> getPageIndicesByLabels() {
        final HashMap<String, Integer> labelMap = new HashMap<String, Integer>(this.doc.getNumberOfPages());
        this.computeLabels(new LabelHandler(){

            public void newLabel(int pageIndex, String label) {
                labelMap.put(label, pageIndex);
            }
        });
        return labelMap;
    }

    public String[] getLabelsByPageIndices() {
        final String[] map = new String[this.doc.getNumberOfPages()];
        this.computeLabels(new LabelHandler(){

            public void newLabel(int pageIndex, String label) {
                if (pageIndex < SMPageLabels.this.doc.getNumberOfPages()) {
                    map[pageIndex] = label;
                }
            }
        });
        return map;
    }

    private void computeLabels(LabelHandler handler) {
        Iterator<Map.Entry<Integer, SMPageLabelRange>> iterator = this.labels.entrySet().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        int pageIndex = 0;
        Map.Entry<Integer, SMPageLabelRange> lastEntry = iterator.next();
        while (iterator.hasNext()) {
            Map.Entry<Integer, SMPageLabelRange> entry = iterator.next();
            int numPages = entry.getKey() - lastEntry.getKey();
            LabelGenerator gen = new LabelGenerator(lastEntry.getValue(), numPages);
            while (gen.hasNext()) {
                handler.newLabel(pageIndex, gen.next());
                ++pageIndex;
            }
            lastEntry = entry;
        }
        LabelGenerator gen = new LabelGenerator(lastEntry.getValue(), this.doc.getNumberOfPages() - lastEntry.getKey());
        while (gen.hasNext()) {
            handler.newLabel(pageIndex, gen.next());
            ++pageIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelGenerator
    implements Iterator<String> {
        private SMPageLabelRange labelInfo;
        private int numPages;
        private int currentPage;
        private static final String[][] ROMANS = new String[][]{{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"}, {"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"}, {"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"}};

        public LabelGenerator(SMPageLabelRange label, int pages) {
            this.labelInfo = label;
            this.numPages = pages;
            this.currentPage = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentPage < this.numPages;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StringBuilder buf = new StringBuilder();
            if (this.labelInfo.getPrefix() != null) {
                String label = this.labelInfo.getPrefix();
                while (label.lastIndexOf(0) != -1) {
                    label = label.substring(0, label.length() - 1);
                }
                buf.append(label);
            }
            if (this.labelInfo.getStyle() != null) {
                buf.append(this.getNumber(this.labelInfo.getStart() + this.currentPage, this.labelInfo.getStyle()));
            }
            ++this.currentPage;
            return buf.toString();
        }

        private String getNumber(int pageIndex, String style) {
            if ("D".equals(style)) {
                return Integer.toString(pageIndex);
            }
            if ("a".equals(style)) {
                return LabelGenerator.makeLetterLabel(pageIndex);
            }
            if ("A".equals(style)) {
                return LabelGenerator.makeLetterLabel(pageIndex).toUpperCase();
            }
            if ("r".equals(style)) {
                return LabelGenerator.makeRomanLabel(pageIndex);
            }
            if ("R".equals(style)) {
                return LabelGenerator.makeRomanLabel(pageIndex).toUpperCase();
            }
            return Integer.toString(pageIndex);
        }

        private static String makeRomanLabel(int pageIndex) {
            StringBuilder buf = new StringBuilder();
            int power = 0;
            while (power < 3 && pageIndex > 0) {
                buf.insert(0, ROMANS[power][pageIndex % 10]);
                pageIndex /= 10;
                ++power;
            }
            int i = 0;
            while (i < pageIndex) {
                buf.insert(0, 'm');
                ++i;
            }
            return buf.toString();
        }

        private static String makeLetterLabel(int num) {
            StringBuilder buf = new StringBuilder();
            int numLetters = num / 26 + Integer.signum(num % 26);
            int letter = num % 26 + 26 * (1 - Integer.signum(num % 26)) + 64;
            int i = 0;
            while (i < numLetters) {
                buf.appendCodePoint(letter);
                ++i;
            }
            return buf.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface LabelHandler {
        public void newLabel(int var1, String var2);
    }
}

