/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common;

import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMStream;

public class SMObjectStream
extends SMStream {
    public SMObjectStream(OMStream str) {
        super(str);
    }

    public static SMObjectStream createStream(SMDocument document) {
        OMStream cosStream = document.getDocument().createOMStream();
        SMObjectStream strm = new SMObjectStream(cosStream);
        strm.getStream().setName(OMName.TYPE, "ObjStm");
        return strm;
    }

    public String getType() {
        return this.getStream().getNameAsString(OMName.TYPE);
    }

    public int getNumberOfObjects() {
        return this.getStream().getInt(OMName.N, 0);
    }

    public void setNumberOfObjects(int n) {
        this.getStream().setInt(OMName.N, n);
    }

    public int getFirstByteOffset() {
        return this.getStream().getInt(OMName.FIRST, 0);
    }

    public void setFirstByteOffset(int n) {
        this.getStream().setInt(OMName.FIRST, n);
    }

    public SMObjectStream getExtends() {
        SMObjectStream retval = null;
        OMStream stream = (OMStream)this.getStream().getDictionaryObject(OMName.EXTENDS);
        if (stream != null) {
            retval = new SMObjectStream(stream);
        }
        return retval;
    }

    public void setExtends(SMObjectStream stream) {
        this.getStream().setItem(OMName.EXTENDS, (OMObjectable)stream);
    }
}

