/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMNumberTreeNode
implements OMObjectable {
    private OMDictionary node;
    private Class<? extends OMObjectable> valueType = null;

    public SMNumberTreeNode(Class<? extends OMObjectable> valueClass) {
        this.node = new OMDictionary();
        this.valueType = valueClass;
    }

    public SMNumberTreeNode(OMDictionary dict, Class<? extends OMObjectable> valueClass) {
        this.node = dict;
        this.valueType = valueClass;
    }

    @Override
    public OMBase getOMObject() {
        return this.node;
    }

    public OMDictionary getOMDictionary() {
        return this.node;
    }

    public List<SMNumberTreeNode> getKids() {
        OMArrayList retval = null;
        OMArray kids = (OMArray)this.node.getDictionaryObject(OMName.KIDS);
        if (kids != null) {
            ArrayList<SMNumberTreeNode> pdObjects = new ArrayList<SMNumberTreeNode>();
            int i = 0;
            while (i < kids.size()) {
                pdObjects.add(this.createChildNode((OMDictionary)kids.getObject(i)));
                ++i;
            }
            retval = new OMArrayList(pdObjects, kids);
        }
        return retval;
    }

    public void setKids(List<? extends SMNumberTreeNode> kids) {
        if (kids != null && kids.size() > 0) {
            SMNumberTreeNode firstKid = kids.get(0);
            SMNumberTreeNode lastKid = kids.get(kids.size() - 1);
            Integer lowerLimit = firstKid.getLowerLimit();
            this.setLowerLimit(lowerLimit);
            Integer upperLimit = lastKid.getUpperLimit();
            this.setUpperLimit(upperLimit);
        } else if (this.node.getDictionaryObject(OMName.NUMS) == null) {
            this.node.setItem(OMName.LIMITS, null);
        }
        this.node.setItem(OMName.KIDS, (OMBase)OMArrayList.converterToOMArray(kids));
    }

    public Object getValue(Integer index) throws IOException {
        Object retval = null;
        Map<Integer, OMObjectable> names = this.getNumbers();
        if (names != null) {
            retval = names.get(index);
        } else {
            List<SMNumberTreeNode> kids = this.getKids();
            if (kids != null) {
                int i = 0;
                while (i < kids.size() && retval == null) {
                    SMNumberTreeNode childNode = kids.get(i);
                    if (childNode.getLowerLimit().compareTo(index) <= 0 && childNode.getUpperLimit().compareTo(index) >= 0) {
                        retval = childNode.getValue(index);
                    }
                    ++i;
                }
            }
        }
        return retval;
    }

    public Map<Integer, OMObjectable> getNumbers() throws IOException {
        Map<Integer, OMObjectable> indices = null;
        OMArray namesArray = (OMArray)this.node.getDictionaryObject(OMName.NUMS);
        if (namesArray != null) {
            indices = new HashMap();
            int i = 0;
            while (i < namesArray.size()) {
                OMInteger key = (OMInteger)namesArray.getObject(i);
                OMBase cosValue = namesArray.getObject(i + 1);
                OMObjectable pdValue = this.convertOMToPD(cosValue);
                indices.put(key.intValue(), pdValue);
                i += 2;
            }
            indices = Collections.unmodifiableMap(indices);
        }
        return indices;
    }

    protected OMObjectable convertOMToPD(OMBase base) throws IOException {
        OMObjectable retval = null;
        try {
            Constructor<? extends OMObjectable> ctor = this.valueType.getConstructor(base.getClass());
            retval = ctor.newInstance(base);
        }
        catch (Throwable t) {
            throw new IOException("Error while trying to create value in number tree:" + t.getMessage());
        }
        return retval;
    }

    protected SMNumberTreeNode createChildNode(OMDictionary dic) {
        return new SMNumberTreeNode(dic, this.valueType);
    }

    public void setNumbers(Map<Integer, ? extends OMObjectable> numbers) {
        if (numbers == null) {
            this.node.setItem(OMName.NUMS, (OMObjectable)null);
            this.node.setItem(OMName.LIMITS, (OMObjectable)null);
        } else {
            ArrayList<Integer> keys = new ArrayList<Integer>(numbers.keySet());
            Collections.sort(keys);
            OMArray array = new OMArray();
            int i = 0;
            while (i < keys.size()) {
                Integer key = (Integer)keys.get(i);
                array.add(OMInteger.get(key.intValue()));
                OMObjectable obj = numbers.get(key);
                array.add(obj);
                ++i;
            }
            Integer lower = null;
            Integer upper = null;
            if (keys.size() > 0) {
                lower = (Integer)keys.get(0);
                upper = (Integer)keys.get(keys.size() - 1);
            }
            this.setUpperLimit(upper);
            this.setLowerLimit(lower);
            this.node.setItem(OMName.NUMS, (OMBase)array);
        }
    }

    public Integer getUpperLimit() {
        Integer retval = null;
        OMArray arr = (OMArray)this.node.getDictionaryObject(OMName.LIMITS);
        if (arr != null && arr.get(0) != null) {
            retval = arr.getInt(1);
        }
        return retval;
    }

    private void setUpperLimit(Integer upper) {
        OMArray arr = (OMArray)this.node.getDictionaryObject(OMName.LIMITS);
        if (arr == null) {
            arr = new OMArray();
            arr.add(null);
            arr.add(null);
            this.node.setItem(OMName.LIMITS, (OMBase)arr);
        }
        if (upper != null) {
            arr.setInt(1, upper);
        } else {
            arr.set(1, null);
        }
    }

    public Integer getLowerLimit() {
        Integer retval = null;
        OMArray arr = (OMArray)this.node.getDictionaryObject(OMName.LIMITS);
        if (arr != null && arr.get(0) != null) {
            retval = arr.getInt(0);
        }
        return retval;
    }

    private void setLowerLimit(Integer lower) {
        OMArray arr = (OMArray)this.node.getDictionaryObject(OMName.LIMITS);
        if (arr == null) {
            arr = new OMArray();
            arr.add(null);
            arr.add(null);
            this.node.setItem(OMName.LIMITS, (OMBase)arr);
        }
        if (lower != null) {
            arr.setInt(0, lower);
        } else {
            arr.set(0, null);
        }
    }
}

