/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMNameTreeNode
implements OMObjectable {
    private OMDictionary node;
    private Class<? extends OMObjectable> valueType = null;
    private SMNameTreeNode parent = null;

    public SMNameTreeNode(Class<? extends OMObjectable> valueClass) {
        this.node = new OMDictionary();
        this.valueType = valueClass;
    }

    public SMNameTreeNode(OMDictionary dict, Class<? extends OMObjectable> valueClass) {
        this.node = dict;
        this.valueType = valueClass;
    }

    @Override
    public OMBase getOMObject() {
        return this.node;
    }

    public OMDictionary getOMDictionary() {
        return this.node;
    }

    public SMNameTreeNode getParent() {
        return this.parent;
    }

    public void setParent(SMNameTreeNode parentNode) throws IOException {
        this.parent = parentNode;
        this.calculateLimits();
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public List<SMNameTreeNode> getKids() {
        OMArrayList retval = null;
        OMArray kids = (OMArray)this.node.getDictionaryObject(OMName.KIDS);
        if (kids != null) {
            ArrayList<SMNameTreeNode> pdObjects = new ArrayList<SMNameTreeNode>();
            int i = 0;
            while (i < kids.size()) {
                pdObjects.add(this.createChildNode((OMDictionary)kids.getObject(i)));
                ++i;
            }
            retval = new OMArrayList(pdObjects, kids);
        }
        return retval;
    }

    public void setKids(List<? extends SMNameTreeNode> kids) throws IOException {
        if (kids != null && kids.size() > 0) {
            for (SMNameTreeNode sMNameTreeNode : kids) {
                sMNameTreeNode.setParent(this);
            }
            this.node.setItem(OMName.KIDS, (OMBase)OMArrayList.converterToOMArray(kids));
            if (this.isRootNode()) {
                this.node.setItem(OMName.NAMES, null);
            }
        } else {
            this.node.setItem(OMName.KIDS, null);
            this.node.setItem(OMName.LIMITS, null);
        }
        this.calculateLimits();
    }

    private void calculateLimits() throws IOException {
        if (this.isRootNode()) {
            this.node.setItem(OMName.LIMITS, null);
        } else {
            List<SMNameTreeNode> kids = this.getKids();
            if (kids != null && kids.size() > 0) {
                SMNameTreeNode firstKid = kids.get(0);
                SMNameTreeNode lastKid = kids.get(kids.size() - 1);
                String lowerLimit = firstKid.getLowerLimit();
                this.setLowerLimit(lowerLimit);
                String upperLimit = lastKid.getUpperLimit();
                this.setUpperLimit(upperLimit);
            } else {
                try {
                    Map<String, OMObjectable> names = this.getNames();
                    if (names != null && names.size() > 0) {
                        Object[] keys = names.keySet().toArray();
                        String lowerLimit = (String)keys[0];
                        this.setLowerLimit(lowerLimit);
                        String upperLimit = (String)keys[keys.length - 1];
                        this.setUpperLimit(upperLimit);
                    } else {
                        this.node.setItem(OMName.LIMITS, null);
                    }
                }
                catch (IOException exception) {
                    this.node.setItem(OMName.LIMITS, null);
                }
            }
        }
    }

    public Object getValue(String name) throws IOException {
        Object retval = null;
        Map<String, OMObjectable> names = this.getNames();
        if (names != null) {
            retval = names.get(name);
        } else {
            List<SMNameTreeNode> kids = this.getKids();
            if (kids != null) {
                int i = 0;
                while (i < kids.size() && retval == null) {
                    SMNameTreeNode childNode = kids.get(i);
                    if (childNode.getLowerLimit().compareTo(name) <= 0 && childNode.getUpperLimit().compareTo(name) >= 0) {
                        retval = childNode.getValue(name);
                    }
                    ++i;
                }
            }
        }
        return retval;
    }

    public Map<String, OMObjectable> getNames() throws IOException {
        OMArray namesArray = (OMArray)this.node.getDictionaryObject(OMName.NAMES);
        if (namesArray != null) {
            LinkedHashMap<String, OMObjectable> names = new LinkedHashMap<String, OMObjectable>();
            int i = 0;
            while (i < namesArray.size()) {
                OMString key = (OMString)namesArray.getObject(i);
                OMBase cosValue = namesArray.getObject(i + 1);
                names.put(key.getString(), this.convertOMToPD(cosValue));
                i += 2;
            }
            return Collections.unmodifiableMap(names);
        }
        return null;
    }

    protected OMObjectable convertOMToPD(OMBase base) throws IOException {
        return base;
    }

    protected SMNameTreeNode createChildNode(OMDictionary dic) {
        return new SMNameTreeNode(dic, this.valueType);
    }

    public void setNames(Map<String, ? extends OMObjectable> names) throws IOException {
        if (names == null) {
            this.node.setItem(OMName.NAMES, (OMObjectable)null);
            this.node.setItem(OMName.LIMITS, (OMObjectable)null);
        } else {
            OMArray array = new OMArray();
            ArrayList<String> keys = new ArrayList<String>(names.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                array.add(new OMString(key));
                array.add(names.get(key));
            }
            this.node.setItem(OMName.NAMES, (OMBase)array);
            this.calculateLimits();
        }
    }

    public String getUpperLimit() {
        String retval = null;
        OMArray arr = (OMArray)this.node.getDictionaryObject(OMName.LIMITS);
        if (arr != null) {
            retval = arr.getString(1);
        }
        return retval;
    }

    private void setUpperLimit(String upper) throws IOException {
        OMArray arr = (OMArray)this.node.getDictionaryObject(OMName.LIMITS);
        if (arr == null) {
            arr = new OMArray();
            arr.add(null);
            arr.add(null);
            this.node.setItem(OMName.LIMITS, (OMBase)arr);
        }
        arr.setString(1, upper);
    }

    public String getLowerLimit() {
        String retval = null;
        OMArray arr = (OMArray)this.node.getDictionaryObject(OMName.LIMITS);
        if (arr != null) {
            retval = arr.getString(0);
        }
        return retval;
    }

    private void setLowerLimit(String lower) throws IOException {
        OMArray arr = (OMArray)this.node.getDictionaryObject(OMName.LIMITS);
        if (arr == null) {
            arr = new OMArray();
            arr.add(null);
            arr.add(null);
            this.node.setItem(OMName.LIMITS, (OMBase)arr);
        }
        arr.setString(0, lower);
    }
}

