/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.io.RandomAccess;
import com.plpdf.om.IOMVisitor;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.pdfparser.PDFStreamParser;
import com.plpdf.smmodel.common.SMStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class OMStreamArray
extends OMStream {
    private OMArray streams;
    private OMStream firstStream;

    public OMStreamArray(OMArray array) {
        super(new OMDictionary(), null);
        this.streams = array;
        if (array.size() > 0) {
            this.firstStream = (OMStream)array.getObject(0);
        }
    }

    public OMBase get(int index) {
        return this.streams.get(index);
    }

    public OMStream getstream(int index) {
        return (OMStream)this.streams.getObject(index);
    }

    public int getStreamCount() {
        return this.streams.size();
    }

    public RandomAccess getScratchFile() {
        return this.firstStream.getScratchFile();
    }

    public OMBase getItem(OMName key) {
        return this.firstStream.getItem(key);
    }

    public OMBase getDictionaryObject(OMName key) {
        return this.firstStream.getDictionaryObject(key);
    }

    public String toString() {
        return "OMStream{}";
    }

    public List getStreamTokens() throws IOException, CryptographyException {
        List<Object> retval = null;
        if (this.streams.size() > 0) {
            PDFStreamParser parser = new PDFStreamParser(this);
            parser.parse();
            retval = parser.getTokens();
        } else {
            retval = new ArrayList();
        }
        return retval;
    }

    public OMDictionary getDictionary() {
        return this.firstStream;
    }

    public InputStream getFilteredStream() throws IOException {
        throw new IOException("Error: Not allowed to get filtered stream from array of streams.");
    }

    public InputStream getUnfilteredStream() throws IOException {
        Vector<InputStream> inputStreams = new Vector<InputStream>();
        byte[] inbetweenStreamBytes = "\n".getBytes("ISO-8859-1");
        int i = 0;
        while (i < this.streams.size()) {
            OMStream stream = (OMStream)this.streams.getObject(i);
            inputStreams.add(stream.getUnfilteredStream());
            inputStreams.add(new ByteArrayInputStream(inbetweenStreamBytes));
            ++i;
        }
        return new SequenceInputStream(inputStreams.elements());
    }

    public Object accept(IOMVisitor visitor) throws OMVisitorException {
        return this.streams.accept(visitor);
    }

    public OMBase getFilters() {
        return this.firstStream.getFilters();
    }

    public OutputStream createFilteredStream() throws IOException {
        return this.firstStream.createFilteredStream();
    }

    public OutputStream createFilteredStream(OMBase expectedLength) throws IOException {
        return this.firstStream.createFilteredStream(expectedLength);
    }

    public void setFilters(OMBase filters) throws IOException {
        this.firstStream.setFilters(filters);
    }

    public OutputStream createUnfilteredStream() throws IOException {
        return this.firstStream.createUnfilteredStream();
    }

    public void appendStream(OMStream streamToAppend) {
        this.streams.add(streamToAppend);
    }

    public void appendStream(int i, OMStream streamToAppend) {
        this.streams.add(i, streamToAppend);
    }

    public void insertOMStream(SMStream streamToBeInserted) {
        OMArray tmp = new OMArray();
        tmp.add(streamToBeInserted);
        tmp.addAll(this.streams);
        this.streams.clear();
        this.streams = tmp;
    }
}

