/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMBoolean;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMObjectable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMDictionaryMap<K, V>
implements Map<K, V> {
    private OMDictionary map;
    private Map<K, V> actuals;

    public OMDictionaryMap(Map<K, V> actualsMap, OMDictionary dicMap) {
        this.actuals = actualsMap;
        this.map = dicMap;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.actuals.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.actuals.get(key);
    }

    @Override
    public V put(K key, V value) {
        OMObjectable object = (OMObjectable)value;
        this.map.setItem(OMName.getPDFName((String)key), object.getOMObject());
        return this.actuals.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.map.removeItem(OMName.getPDFName((String)key));
        return this.actuals.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void clear() {
        this.map.clear();
        this.actuals.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.actuals.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.actuals.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.actuals.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        boolean retval = false;
        if (o instanceof OMDictionaryMap) {
            OMDictionaryMap other = (OMDictionaryMap)o;
            retval = other.map.equals(this.map);
        }
        return retval;
    }

    public String toString() {
        return this.actuals.toString();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public static OMDictionary convert(Map<?, ?> someMap) {
        Iterator<?> iter = someMap.keySet().iterator();
        OMDictionary dic = new OMDictionary();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            OMObjectable object = (OMObjectable)someMap.get(name);
            dic.setItem(OMName.getPDFName(name), object.getOMObject());
        }
        return dic;
    }

    public static OMDictionaryMap<String, Object> convertBasicTypesToMap(OMDictionary map) throws IOException {
        OMDictionaryMap retval = null;
        if (map != null) {
            HashMap<String, String> actualMap = new HashMap<String, String>();
            for (OMName key : map.keySet()) {
                OMBase cosObj = map.getDictionaryObject(key);
                Object actualObject = null;
                if (cosObj instanceof OMString) {
                    actualObject = ((OMString)cosObj).getString();
                } else if (cosObj instanceof OMInteger) {
                    actualObject = new Integer(((OMInteger)cosObj).intValue());
                } else if (cosObj instanceof OMName) {
                    actualObject = ((OMName)cosObj).getName();
                } else if (cosObj instanceof OMFloat) {
                    actualObject = new Float(((OMFloat)cosObj).floatValue());
                } else if (cosObj instanceof OMBoolean) {
                    actualObject = ((OMBoolean)cosObj).getValue() ? Boolean.TRUE : Boolean.FALSE;
                } else {
                    throw new IOException("Error:unknown type of object to convert:" + cosObj);
                }
                actualMap.put(key.getName(), (String)actualObject);
            }
            retval = new OMDictionaryMap(actualMap, map);
        }
        return retval;
    }
}

