/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.common;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNull;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.DualOMObjectable;
import com.plpdf.smmodel.common.OMObjectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMArrayList<E>
implements List<E> {
    private OMArray array;
    private List<E> actual;
    private OMDictionary parentDict;
    private OMName dictKey;

    public OMArrayList() {
        this.array = new OMArray();
        this.actual = new ArrayList();
    }

    public OMArrayList(List<E> actualList, OMArray cosArray) {
        this.actual = actualList;
        this.array = cosArray;
    }

    public OMArrayList(E actualObject, OMBase item, OMDictionary dictionary, OMName dictionaryKey) {
        this.array = new OMArray();
        this.array.add(item);
        this.actual = new ArrayList();
        this.actual.add(actualObject);
        this.parentDict = dictionary;
        this.dictKey = dictionaryKey;
    }

    public OMArrayList(E actualObject, OMBase item, OMDictionary dictionary, String dictionaryKey) {
        this(actualObject, item, dictionary, OMName.getPDFName(dictionaryKey));
    }

    @Override
    public int size() {
        return this.actual.size();
    }

    @Override
    public boolean isEmpty() {
        return this.actual.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.actual.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.actual.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.actual.toArray();
    }

    @Override
    public <X> X[] toArray(X[] a) {
        return this.actual.toArray(a);
    }

    @Override
    public boolean add(E o) {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (OMBase)this.array);
            this.parentDict = null;
        }
        if (o instanceof String) {
            this.array.add(new OMString((String)o));
        } else if (o instanceof DualOMObjectable) {
            DualOMObjectable dual = (DualOMObjectable)o;
            this.array.add(dual.getFirstOMObject());
            this.array.add(dual.getSecondOMObject());
        } else if (this.array != null) {
            this.array.add(((OMObjectable)o).getOMObject());
        }
        return this.actual.add(o);
    }

    @Override
    public boolean remove(Object o) {
        boolean retval = true;
        int index = this.actual.indexOf(o);
        if (index >= 0) {
            this.actual.remove(index);
            this.array.remove(index);
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.actual.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.parentDict != null && c.size() > 0) {
            this.parentDict.setItem(this.dictKey, (OMBase)this.array);
            this.parentDict = null;
        }
        this.array.addAll(this.toOMObjectList(c));
        return this.actual.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (this.parentDict != null && c.size() > 0) {
            this.parentDict.setItem(this.dictKey, (OMBase)this.array);
            this.parentDict = null;
        }
        if (c.size() > 0 && c.toArray()[0] instanceof DualOMObjectable) {
            this.array.addAll(index * 2, this.toOMObjectList(c));
        } else {
            this.array.addAll(index, this.toOMObjectList(c));
        }
        return this.actual.addAll(index, c);
    }

    public static List<Integer> convertIntegerOMArrayToList(OMArray intArray) {
        OMArrayList retval = null;
        if (intArray != null) {
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            int i = 0;
            while (i < intArray.size()) {
                numbers.add(new Integer(((OMNumber)intArray.get(i)).intValue()));
                ++i;
            }
            retval = new OMArrayList(numbers, intArray);
        }
        return retval;
    }

    public static List<Float> convertFloatOMArrayToList(OMArray floatArray) {
        OMArrayList retval = null;
        if (floatArray != null) {
            ArrayList<Float> numbers = new ArrayList<Float>();
            int i = 0;
            while (i < floatArray.size()) {
                numbers.add(new Float(((OMNumber)floatArray.get(i)).floatValue()));
                ++i;
            }
            retval = new OMArrayList(numbers, floatArray);
        }
        return retval;
    }

    public static List<String> convertOMNameOMArrayToList(OMArray nameArray) {
        OMArrayList retval = null;
        if (nameArray != null) {
            ArrayList<String> names = new ArrayList<String>();
            int i = 0;
            while (i < nameArray.size()) {
                names.add(((OMName)nameArray.getObject(i)).getName());
                ++i;
            }
            retval = new OMArrayList(names, nameArray);
        }
        return retval;
    }

    public static List<String> convertOMStringOMArrayToList(OMArray stringArray) {
        OMArrayList retval = null;
        if (stringArray != null) {
            ArrayList<String> string = new ArrayList<String>();
            int i = 0;
            while (i < stringArray.size()) {
                string.add(((OMString)stringArray.getObject(i)).getString());
                ++i;
            }
            retval = new OMArrayList(string, stringArray);
        }
        return retval;
    }

    public static OMArray convertStringListToOMNameOMArray(List<String> strings) {
        OMArray retval = new OMArray();
        int i = 0;
        while (i < strings.size()) {
            retval.add(OMName.getPDFName(strings.get(i)));
            ++i;
        }
        return retval;
    }

    public static OMArray convertStringListToOMStringOMArray(List<String> strings) {
        OMArray retval = new OMArray();
        int i = 0;
        while (i < strings.size()) {
            retval.add(new OMString(strings.get(i)));
            ++i;
        }
        return retval;
    }

    public static OMArray converterToOMArray(List<?> cosObjectableList) {
        OMArray array = null;
        if (cosObjectableList != null) {
            if (cosObjectableList instanceof OMArrayList) {
                array = ((OMArrayList)cosObjectableList).array;
            } else {
                array = new OMArray();
                for (Object next : cosObjectableList) {
                    Object object;
                    if (next instanceof String) {
                        array.add(new OMString((String)next));
                        continue;
                    }
                    if (next instanceof Integer || next instanceof Long) {
                        array.add(OMInteger.get(((Number)next).longValue()));
                        continue;
                    }
                    if (next instanceof Float || next instanceof Double) {
                        array.add(new OMFloat(((Number)next).floatValue()));
                        continue;
                    }
                    if (next instanceof OMObjectable) {
                        object = (OMObjectable)next;
                        array.add(object.getOMObject());
                        continue;
                    }
                    if (next instanceof DualOMObjectable) {
                        object = (DualOMObjectable)next;
                        array.add(object.getFirstOMObject());
                        array.add(object.getSecondOMObject());
                        continue;
                    }
                    if (next == null) {
                        array.add(OMNull.NULL);
                        continue;
                    }
                    throw new RuntimeException("Error: Don't know how to convert type to OMBase '" + next.getClass().getName() + "'");
                }
            }
        }
        return array;
    }

    private List<OMBase> toOMObjectList(Collection<?> list) {
        ArrayList<OMBase> cosObjects = new ArrayList<OMBase>();
        for (Object next : list) {
            if (next instanceof String) {
                cosObjects.add(new OMString((String)next));
                continue;
            }
            if (next instanceof DualOMObjectable) {
                DualOMObjectable object = (DualOMObjectable)next;
                this.array.add(object.getFirstOMObject());
                this.array.add(object.getSecondOMObject());
                continue;
            }
            OMObjectable cos = (OMObjectable)next;
            cosObjects.add(cos.getOMObject());
        }
        return cosObjects;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.array.removeAll(this.toOMObjectList(c));
        return this.actual.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.array.retainAll(this.toOMObjectList(c));
        return this.actual.retainAll(c);
    }

    @Override
    public void clear() {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, null);
        }
        this.actual.clear();
        this.array.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.actual.equals(o);
    }

    @Override
    public int hashCode() {
        return this.actual.hashCode();
    }

    @Override
    public E get(int index) {
        return this.actual.get(index);
    }

    @Override
    public E set(int index, E element) {
        if (element instanceof String) {
            OMString item = new OMString((String)element);
            if (this.parentDict != null && index == 0) {
                this.parentDict.setItem(this.dictKey, (OMBase)item);
            }
            this.array.set(index, item);
        } else if (element instanceof DualOMObjectable) {
            DualOMObjectable dual = (DualOMObjectable)element;
            this.array.set(index * 2, dual.getFirstOMObject());
            this.array.set(index * 2 + 1, dual.getSecondOMObject());
        } else {
            if (this.parentDict != null && index == 0) {
                this.parentDict.setItem(this.dictKey, ((OMObjectable)element).getOMObject());
            }
            this.array.set(index, ((OMObjectable)element).getOMObject());
        }
        return this.actual.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (OMBase)this.array);
            this.parentDict = null;
        }
        this.actual.add(index, element);
        if (element instanceof String) {
            this.array.add(index, new OMString((String)element));
        } else if (element instanceof DualOMObjectable) {
            DualOMObjectable dual = (DualOMObjectable)element;
            this.array.add(index * 2, dual.getFirstOMObject());
            this.array.add(index * 2 + 1, dual.getSecondOMObject());
        } else {
            this.array.add(index, ((OMObjectable)element).getOMObject());
        }
    }

    @Override
    public E remove(int index) {
        if (this.array.size() > index && this.array.get(index) instanceof DualOMObjectable) {
            this.array.remove(index);
            this.array.remove(index);
        } else {
            this.array.remove(index);
        }
        return this.actual.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.actual.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.actual.indexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.actual.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.actual.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.actual.subList(fromIndex, toIndex);
    }

    public String toString() {
        return "OMArrayList{" + this.array.toString() + "}";
    }

    public OMArray toList() {
        return this.array;
    }
}

