/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMDictionaryMap;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.font.SMFont;
import com.plpdf.smmodel.font.SMFontFactory;
import com.plpdf.smmodel.graphics.SMExtendedGraphicsState;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMColorSpaceFactory;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentGroup;
import com.plpdf.smmodel.graphics.pattern.SMPatternResources;
import com.plpdf.smmodel.graphics.shading.SMShadingResources;
import com.plpdf.smmodel.graphics.xobject.SMXObject;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.smmodel.markedcontent.SMPropertyList;
import com.plpdf.util.MapUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMResources
implements OMObjectable {
    private OMDictionary resources;
    private Map<String, SMFont> fonts = null;
    private Map<SMFont, String> fontMappings = new HashMap<SMFont, String>();
    private Map<String, SMColorSpace> colorspaces = null;
    private Map<String, SMXObject> xobjects = null;
    private Map<SMXObject, String> xobjectMappings = new HashMap<SMXObject, String>();
    private HashMap<String, SMXObjectImage> images = null;
    private Map<String, SMExtendedGraphicsState> graphicsStates = null;
    private Map<String, SMPatternResources> patterns = null;
    private Map<String, SMShadingResources> shadings = null;
    private Map<String, SMOptionalContentGroup> layers = null;
    private Map<SMOptionalContentGroup, String> layerMappings = new HashMap<SMOptionalContentGroup, String>();

    public SMResources() {
        this.resources = new OMDictionary();
    }

    public SMResources(OMDictionary resourceDictionary) {
        this.resources = resourceDictionary;
    }

    public OMDictionary getOMDictionary() {
        return this.resources;
    }

    @Override
    public OMBase getOMObject() {
        return this.resources;
    }

    public void clear() {
        if (this.fonts != null) {
            this.fonts.clear();
            this.fonts = null;
        }
        if (this.fontMappings != null) {
            this.fontMappings.clear();
            this.fontMappings = null;
        }
        if (this.colorspaces != null) {
            this.colorspaces.clear();
            this.colorspaces = null;
        }
        if (this.xobjects != null) {
            this.xobjects.clear();
            this.xobjects = null;
        }
        if (this.xobjectMappings != null) {
            this.xobjectMappings.clear();
            this.xobjectMappings = null;
        }
        if (this.images != null) {
            this.images.clear();
            this.images = null;
        }
        if (this.graphicsStates != null) {
            this.graphicsStates.clear();
            this.graphicsStates = null;
        }
        if (this.patterns != null) {
            this.patterns.clear();
            this.patterns = null;
        }
        if (this.shadings != null) {
            this.shadings.clear();
            this.shadings = null;
        }
        if (this.layers != null) {
            this.layers.clear();
            this.layers = null;
        }
        if (this.layerMappings != null) {
            this.layerMappings.clear();
            this.layerMappings = null;
        }
    }

    public Map<String, SMFont> getFonts(Map<String, SMFont> fontCache) throws IOException {
        return this.getFonts();
    }

    public Map<String, SMFont> getFonts() throws IOException {
        if (this.fonts == null) {
            this.fonts = new HashMap<String, SMFont>();
            OMDictionary fontsDictionary = (OMDictionary)this.resources.getDictionaryObject(OMName.FONT);
            if (fontsDictionary == null) {
                fontsDictionary = new OMDictionary();
                this.resources.setItem(OMName.FONT, (OMBase)fontsDictionary);
            } else {
                for (OMName fontName : fontsDictionary.keySet()) {
                    OMBase font = fontsDictionary.getDictionaryObject(fontName);
                    if (!(font instanceof OMDictionary)) continue;
                    SMFont newFont = null;
                    newFont = SMFontFactory.createFont((OMDictionary)font);
                    if (newFont == null) continue;
                    this.fonts.put(fontName.getName(), newFont);
                }
            }
        }
        return this.fonts;
    }

    public Map<String, SMXObject> getXObjects() throws IOException {
        if (this.xobjects == null) {
            this.xobjects = new HashMap<String, SMXObject>();
            OMDictionary xobjectsDictionary = (OMDictionary)this.resources.getDictionaryObject(OMName.XOBJECT);
            if (xobjectsDictionary == null) {
                xobjectsDictionary = new OMDictionary();
                this.resources.setItem(OMName.XOBJECT, (OMBase)xobjectsDictionary);
            } else {
                this.xobjects = new HashMap<String, SMXObject>();
                for (OMName objName : xobjectsDictionary.keySet()) {
                    SMXObject xobject = null;
                    xobject = SMXObject.createXObject(xobjectsDictionary.getDictionaryObject(objName));
                    if (xobject == null) continue;
                    this.xobjects.put(objName.getName(), xobject);
                }
            }
            this.setXObjects(this.xobjects);
        }
        return this.xobjects;
    }

    public Map<String, SMXObjectImage> getImages() throws IOException {
        if (this.images == null) {
            Map<String, SMXObject> allXObjects = this.getXObjects();
            this.images = new HashMap();
            for (Map.Entry<String, SMXObject> entry : allXObjects.entrySet()) {
                SMXObject xobject = entry.getValue();
                if (!(xobject instanceof SMXObjectImage)) continue;
                this.images.put(entry.getKey(), (SMXObjectImage)xobject);
            }
        }
        return this.images;
    }

    public void setFonts(Map<String, SMFont> fontsValue) {
        this.fonts = fontsValue;
        if (fontsValue != null) {
            this.resources.setItem(OMName.FONT, (OMBase)OMDictionaryMap.convert(fontsValue));
            this.fontMappings = this.reverseMap(fontsValue, SMFont.class);
        } else {
            this.resources.removeItem(OMName.FONT);
            this.fontMappings = null;
        }
    }

    public void setXObjects(Map<String, SMXObject> xobjectsValue) {
        this.xobjects = xobjectsValue;
        if (xobjectsValue != null) {
            this.resources.setItem(OMName.XOBJECT, (OMBase)OMDictionaryMap.convert(xobjectsValue));
            this.xobjectMappings = this.reverseMap(this.xobjects, SMXObject.class);
        } else {
            this.resources.removeItem(OMName.XOBJECT);
            this.xobjectMappings = null;
        }
    }

    public Map<String, SMColorSpace> getColorSpaces() {
        OMDictionary csDictionary;
        if (this.colorspaces == null && (csDictionary = (OMDictionary)this.resources.getDictionaryObject(OMName.COLORSPACE)) != null) {
            this.colorspaces = new HashMap<String, SMColorSpace>();
            for (OMName csName : csDictionary.keySet()) {
                OMBase cs = csDictionary.getDictionaryObject(csName);
                SMColorSpace colorspace = null;
                try {
                    colorspace = SMColorSpaceFactory.createColorSpace(cs);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (colorspace == null) continue;
                this.colorspaces.put(csName.getName(), colorspace);
            }
        }
        return this.colorspaces;
    }

    public void setColorSpaces(Map<String, SMColorSpace> csValue) {
        this.colorspaces = csValue;
        if (csValue != null) {
            this.resources.setItem(OMName.COLORSPACE, (OMBase)OMDictionaryMap.convert(csValue));
        } else {
            this.resources.removeItem(OMName.COLORSPACE);
        }
    }

    public Map<String, SMExtendedGraphicsState> getGraphicsStates() {
        OMDictionary states;
        if (this.graphicsStates == null && (states = (OMDictionary)this.resources.getDictionaryObject(OMName.EXT_G_STATE)) != null) {
            this.graphicsStates = new HashMap<String, SMExtendedGraphicsState>();
            for (OMName name : states.keySet()) {
                OMDictionary dictionary = (OMDictionary)states.getDictionaryObject(name);
                this.graphicsStates.put(name.getName(), new SMExtendedGraphicsState(dictionary));
            }
        }
        return this.graphicsStates;
    }

    public Map<SMExtendedGraphicsState, String> getGraphicsStatesMap() {
        HashMap<SMExtendedGraphicsState, String> graphicsStatesMap = new HashMap<SMExtendedGraphicsState, String>();
        if (this.graphicsStates != null) {
            for (String name : this.graphicsStates.keySet()) {
                SMExtendedGraphicsState state = this.graphicsStates.get(name);
                graphicsStatesMap.put(state, name);
            }
        }
        return graphicsStatesMap;
    }

    public String getGraphicsStates1(SMExtendedGraphicsState gs) {
        String ret = null;
        if (this.graphicsStates != null) {
            for (String name : this.graphicsStates.keySet()) {
                SMExtendedGraphicsState state = this.graphicsStates.get(name);
                if (!gs.equals(state)) continue;
                ret = name;
            }
        }
        return ret;
    }

    public void setGraphicsStates(Map<String, SMExtendedGraphicsState> states) {
        this.graphicsStates = states;
        if (states != null) {
            Iterator<String> iter = states.keySet().iterator();
            OMDictionary dic = new OMDictionary();
            while (iter.hasNext()) {
                String name = iter.next();
                SMExtendedGraphicsState state = states.get(name);
                dic.setItem(OMName.getPDFName(name), state.getOMObject());
            }
            this.resources.setItem(OMName.EXT_G_STATE, (OMBase)dic);
        } else {
            this.resources.removeItem(OMName.EXT_G_STATE);
        }
    }

    public SMPropertyList getProperties() {
        SMPropertyList retval = null;
        OMDictionary props = (OMDictionary)this.resources.getDictionaryObject(OMName.PROPERTIES);
        if (props != null) {
            retval = new SMPropertyList(props);
        }
        return retval;
    }

    public void setProperties(SMPropertyList props) {
        this.resources.setItem(OMName.PROPERTIES, props.getOMObject());
    }

    public Map<String, SMPatternResources> getPatterns() throws IOException {
        OMDictionary patternsDictionary;
        if (this.patterns == null && (patternsDictionary = (OMDictionary)this.resources.getDictionaryObject(OMName.PATTERN)) != null) {
            this.patterns = new HashMap<String, SMPatternResources>();
            for (OMName name : patternsDictionary.keySet()) {
                OMDictionary dictionary = (OMDictionary)patternsDictionary.getDictionaryObject(name);
                this.patterns.put(name.getName(), SMPatternResources.create(dictionary));
            }
        }
        return this.patterns;
    }

    public void setPatterns(Map<String, SMPatternResources> patternsValue) {
        this.patterns = patternsValue;
        if (patternsValue != null) {
            Iterator<String> iter = patternsValue.keySet().iterator();
            OMDictionary dic = new OMDictionary();
            while (iter.hasNext()) {
                String name = iter.next();
                SMPatternResources pattern = patternsValue.get(name);
                dic.setItem(OMName.getPDFName(name), pattern.getOMObject());
            }
            this.resources.setItem(OMName.PATTERN, (OMBase)dic);
        } else {
            this.resources.removeItem(OMName.PATTERN);
        }
    }

    public Map<String, SMShadingResources> getShadings() throws IOException {
        OMDictionary shadingsDictionary;
        if (this.shadings == null && (shadingsDictionary = (OMDictionary)this.resources.getDictionaryObject(OMName.SHADING)) != null) {
            this.shadings = new HashMap<String, SMShadingResources>();
            for (OMName name : shadingsDictionary.keySet()) {
                OMDictionary dictionary = (OMDictionary)shadingsDictionary.getDictionaryObject(name);
                this.shadings.put(name.getName(), SMShadingResources.create(dictionary));
            }
        }
        return this.shadings;
    }

    public void setShadings(Map<String, SMShadingResources> shadingsValue) {
        this.shadings = shadingsValue;
        if (shadingsValue != null) {
            Iterator<String> iter = shadingsValue.keySet().iterator();
            OMDictionary dic = new OMDictionary();
            while (iter.hasNext()) {
                String name = iter.next();
                SMShadingResources shading = shadingsValue.get(name);
                dic.setItem(OMName.getPDFName(name), shading.getOMObject());
            }
            this.resources.setItem(OMName.SHADING, (OMBase)dic);
        } else {
            this.resources.removeItem(OMName.SHADING);
        }
    }

    public String addFont(SMFont font) throws IOException {
        return this.addFont(font, MapUtil.getNextUniqueKey(this.fonts, "F"));
    }

    public String addFont(SMFont font, String fontKey) throws IOException {
        String fontMapping;
        if (this.fonts == null) {
            this.getFonts();
        }
        if ((fontMapping = this.fontMappings.get(font)) == null) {
            fontMapping = fontKey;
            this.fontMappings.put(font, fontMapping);
            this.fonts.put(fontMapping, font);
            this.addFontToDictionary(font, fontMapping);
        }
        return fontMapping;
    }

    private void addFontToDictionary(SMFont font, String fontName) {
        OMDictionary fontsDictionary = (OMDictionary)this.resources.getDictionaryObject(OMName.FONT);
        fontsDictionary.setItem(fontName, (OMObjectable)font);
    }

    public String addXObject(SMXObject xobject, String prefix) throws IOException {
        String objMapping;
        if (this.xobjects == null) {
            this.getXObjects();
        }
        if ((objMapping = this.xobjectMappings.get(xobject)) == null) {
            objMapping = MapUtil.getNextUniqueKey(this.xobjects, prefix);
            this.xobjectMappings.put(xobject, objMapping);
            this.xobjects.put(objMapping, xobject);
            this.addXObjectToDictionary(xobject, objMapping);
        }
        return objMapping;
    }

    private void addXObjectToDictionary(SMXObject xobject, String xobjectName) {
        OMDictionary xobjectsDictionary = (OMDictionary)this.resources.getDictionaryObject(OMName.XOBJECT);
        xobjectsDictionary.setItem(xobjectName, (OMObjectable)xobject);
    }

    private <T> Map<T, String> reverseMap(Map<String, T> map, Class<T> keyClass) {
        HashMap<T, String> reversed = new HashMap<T, String>();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            reversed.put(keyClass.cast(entry.getValue()), entry.getKey());
        }
        return reversed;
    }

    public String addLayer(SMOptionalContentGroup layer) throws IOException {
        return this.addLayer(layer, MapUtil.getNextUniqueKey(this.layers, "Pr"));
    }

    public String addLayer(SMOptionalContentGroup layer, String layerKey) throws IOException {
        String layerMapping;
        if (this.layers == null) {
            this.layers = this.getLayers();
            this.layerMappings = this.reverseMap(this.layers, SMOptionalContentGroup.class);
            this.setLayers(this.layers);
        }
        if ((layerMapping = this.layerMappings.get(layer)) == null) {
            layerMapping = layerKey;
            this.layerMappings.put(layer, layerMapping);
            this.layers.put(layerMapping, layer);
            this.addLayerToDictionary(layer, layerMapping);
        }
        return layerMapping;
    }

    public Map<String, SMOptionalContentGroup> getLayers() throws IOException {
        if (this.layers == null) {
            this.layers = new HashMap<String, SMOptionalContentGroup>();
            OMDictionary propsDictionary = (OMDictionary)this.resources.getDictionaryObject(OMName.PROPERTIES);
            if (propsDictionary == null) {
                propsDictionary = new OMDictionary();
                this.resources.setItem(OMName.PROPERTIES, (OMBase)propsDictionary);
            } else {
                for (OMName propName : propsDictionary.keySet()) {
                    OMBase prop = propsDictionary.getDictionaryObject(propName);
                    if (!(prop instanceof OMDictionary)) continue;
                    OMDictionary dictionary = (OMDictionary)propsDictionary.getDictionaryObject(propName);
                    this.layers.put(propName.getName(), new SMOptionalContentGroup(dictionary));
                }
            }
        }
        return this.layers;
    }

    public void setLayers(Map<String, SMOptionalContentGroup> layersValue) {
        this.layers = layersValue;
        if (layersValue != null) {
            this.resources.setItem(OMName.PROPERTIES, (OMBase)OMDictionaryMap.convert(layersValue));
        } else {
            this.resources.removeItem(OMName.PROPERTIES);
        }
    }

    private void addLayerToDictionary(SMOptionalContentGroup layer, String layerName) {
        OMDictionary propsDictionary = (OMDictionary)this.resources.getDictionaryObject(OMName.PROPERTIES);
        propsDictionary.setItem(layerName, (OMObjectable)layer);
    }

    public Map crExtGState() {
        OMDictionaryMap retval = null;
        OMDictionary dict = new OMDictionary();
        this.resources.setItem(OMName.getPDFName("ExtGState"), (OMBase)dict);
        HashMap actuals = new HashMap();
        retval = new OMDictionaryMap(actuals, dict);
        return retval;
    }
}

