/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel;

import com.plpdf.pdfviewer.PageDrawer;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMRectangle;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SMPageable
implements Pageable,
Printable {
    private final List<SMPage> pages = new ArrayList<SMPage>();
    private final PrinterJob job;

    public SMPageable(SMDocument document, PrinterJob printerJob) throws IllegalArgumentException, PrinterException {
        if (document == null || printerJob == null) {
            throw new IllegalArgumentException("SMPageable(" + document + ", " + printerJob + ")");
        }
        if (!document.getCurrentAccessPermission().canPrint()) {
            throw new PrinterException("You do not have permission to print this document");
        }
        document.getDocumentCatalog().getPages().getAllKids(this.pages);
        this.job = printerJob;
    }

    public SMPageable(SMDocument document) throws IllegalArgumentException, PrinterException {
        this(document, PrinterJob.getPrinterJob());
    }

    public PrinterJob getPrinterJob() {
        return this.job;
    }

    public int getNumberOfPages() {
        return this.pages.size();
    }

    public PageFormat getPageFormat(int i) throws IndexOutOfBoundsException {
        PageFormat format = this.job.defaultPage();
        SMPage page = this.pages.get(i);
        Dimension media = page.findMediaBox().createDimension();
        Dimension crop = page.findCropBox().createDimension();
        double diffWidth = 0.0;
        double diffHeight = 0.0;
        if (!media.equals(crop)) {
            diffWidth = (media.getWidth() - crop.getWidth()) / 2.0;
            diffHeight = (media.getHeight() - crop.getHeight()) / 2.0;
        }
        Paper paper = format.getPaper();
        if (media.getWidth() < media.getHeight()) {
            format.setOrientation(1);
            paper.setImageableArea(diffWidth, diffHeight, crop.getWidth(), crop.getHeight());
        } else {
            format.setOrientation(0);
            paper.setImageableArea(diffHeight, diffWidth, crop.getHeight(), crop.getWidth());
        }
        format.setPaper(paper);
        return format;
    }

    public Printable getPrintable(int i) throws IndexOutOfBoundsException {
        return this.pages.get(i);
    }

    public int print(Graphics graphics, PageFormat format, int i) throws PrinterException {
        if (i >= 0 && i < this.pages.size()) {
            try {
                SMPage page = this.pages.get(i);
                SMRectangle cropBox = page.findCropBox();
                PageDrawer drawer = new PageDrawer();
                drawer.drawPage(graphics, page, cropBox.createDimension());
                return 0;
            }
            catch (IOException io) {
                throw new PrinterIOException(io);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return 1;
        }
        return 1;
    }
}

