/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import java.util.ArrayList;
import java.util.List;

public class SMPageNode
implements OMObjectable {
    private OMDictionary page;

    public SMPageNode() {
        this.page = new OMDictionary();
        this.page.setItem(OMName.TYPE, (OMBase)OMName.PAGES);
        this.page.setItem(OMName.KIDS, (OMBase)new OMArray());
        this.page.setItem(OMName.COUNT, (OMBase)OMInteger.ZERO);
    }

    public SMPageNode(OMDictionary pages) {
        this.page = pages;
    }

    public long updateCount() {
        long totalCount = 0L;
        List kids = this.getKids();
        for (Object next : kids) {
            if (next instanceof SMPage) {
                ++totalCount;
                continue;
            }
            SMPageNode node = (SMPageNode)next;
            totalCount += node.updateCount();
        }
        this.page.setLong(OMName.COUNT, totalCount);
        return totalCount;
    }

    public long getCount() {
        if (this.page == null) {
            return 0L;
        }
        OMBase num = this.page.getDictionaryObject(OMName.COUNT);
        if (num == null) {
            return 0L;
        }
        return ((OMNumber)num).intValue();
    }

    public OMDictionary getDictionary() {
        return this.page;
    }

    public SMPageNode getParent() {
        SMPageNode parent = null;
        OMDictionary parentDic = (OMDictionary)this.page.getDictionaryObject(OMName.PARENT, OMName.P);
        if (parentDic != null) {
            parent = new SMPageNode(parentDic);
        }
        return parent;
    }

    public void setParent(SMPageNode parent) {
        this.page.setItem(OMName.PARENT, (OMBase)parent.getDictionary());
    }

    public OMBase getOMObject() {
        return this.page;
    }

    public List getKids() {
        ArrayList actuals = new ArrayList();
        OMArray kids = SMPageNode.getAllKids(actuals, this.page, false);
        return new OMArrayList(actuals, kids);
    }

    public void getAllKids(List result) {
        SMPageNode.getAllKids(result, this.page, true);
    }

    private static OMArray getAllKids(List result, OMDictionary page, boolean recurse) {
        if (page == null) {
            return null;
        }
        OMArray kids = (OMArray)page.getDictionaryObject(OMName.KIDS);
        if (kids == null) {
            return null;
        }
        int i = 0;
        while (i < kids.size()) {
            OMBase obj = kids.getObject(i);
            if (obj instanceof OMDictionary) {
                OMDictionary kid = (OMDictionary)obj;
                if (OMName.PAGE.equals(kid.getDictionaryObject(OMName.TYPE))) {
                    result.add(new SMPage(kid));
                } else if (recurse) {
                    SMPageNode.getAllKids(result, kid, recurse);
                } else {
                    result.add(new SMPageNode(kid));
                }
            }
            ++i;
        }
        return kids;
    }

    public SMResources getResources() {
        SMResources retval = null;
        OMDictionary resources = (OMDictionary)this.page.getDictionaryObject(OMName.RESOURCES);
        if (resources != null) {
            retval = new SMResources(resources);
        }
        return retval;
    }

    public SMResources findResources() {
        SMResources retval = this.getResources();
        SMPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = parent.findResources();
        }
        return retval;
    }

    public void setResources(SMResources resources) {
        if (resources == null) {
            this.page.removeItem(OMName.RESOURCES);
        } else {
            this.page.setItem(OMName.RESOURCES, (OMBase)resources.getOMDictionary());
        }
    }

    public SMRectangle getMediaBox() {
        SMRectangle retval = null;
        OMArray array = (OMArray)this.page.getDictionaryObject(OMName.MEDIA_BOX);
        if (array != null) {
            retval = new SMRectangle(array);
        }
        return retval;
    }

    public SMRectangle findMediaBox() {
        SMRectangle retval = this.getMediaBox();
        SMPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = parent.findMediaBox();
        }
        return retval;
    }

    public void setMediaBox(SMRectangle mediaBox) {
        if (mediaBox == null) {
            this.page.removeItem(OMName.MEDIA_BOX);
        } else {
            this.page.setItem(OMName.MEDIA_BOX, (OMBase)mediaBox.getOMArray());
        }
    }

    public SMRectangle getCropBox() {
        SMRectangle retval = null;
        OMArray array = (OMArray)this.page.getDictionaryObject(OMName.CROP_BOX);
        if (array != null) {
            retval = new SMRectangle(array);
        }
        return retval;
    }

    public SMRectangle findCropBox() {
        SMRectangle retval = this.getCropBox();
        SMPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = this.findParentCropBox(parent);
        }
        if (retval == null) {
            retval = this.findMediaBox();
        }
        return retval;
    }

    private SMRectangle findParentCropBox(SMPageNode node) {
        SMRectangle rect = node.getCropBox();
        SMPageNode parent = node.getParent();
        if (rect == null && parent != null) {
            rect = this.findParentCropBox(node);
        }
        return rect;
    }

    public void setCropBox(SMRectangle cropBox) {
        if (cropBox == null) {
            this.page.removeItem(OMName.CROP_BOX);
        } else {
            this.page.setItem(OMName.CROP_BOX, (OMBase)cropBox.getOMArray());
        }
    }

    public Integer getRotation() {
        Integer retval = null;
        OMNumber value = (OMNumber)this.page.getDictionaryObject(OMName.ROTATE);
        if (value != null) {
            retval = new Integer(value.intValue());
        }
        return retval;
    }

    public int findRotation() {
        int retval = 0;
        Integer rotation = this.getRotation();
        if (rotation != null) {
            retval = rotation;
        } else {
            SMPageNode parent = this.getParent();
            if (parent != null) {
                retval = parent.findRotation();
            }
        }
        return retval;
    }

    public void setRotation(int rotation) {
        this.page.setInt(OMName.ROTATE, rotation);
    }
}

