/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMStream;
import com.plpdf.pdfviewer.PageDrawer;
import com.plpdf.smmodel.SMPageNode;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMMetadata;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.interactive.action.SMPageAdditionalActions;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.pagenavigation.SMThreadBead;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMPage
implements OMObjectable,
Printable {
    public static final int DEFAULT_USER_SPACE_UNIT_DPI = 72;
    private static final float MM_TO_UNITS = 2.8346457f;
    private static final Color TRANSPARENT_WHITE = new Color(255, 255, 255, 0);
    private OMDictionary page;
    private SMResources pageResources;
    public static final SMRectangle PAGE_SIZE_LETTER = new SMRectangle(612.0f, 792.0f);
    public static final SMRectangle PAGE_SIZE_A0 = new SMRectangle(2383.937f, 3370.3938f);
    public static final SMRectangle PAGE_SIZE_A1 = new SMRectangle(1683.7795f, 2383.937f);
    public static final SMRectangle PAGE_SIZE_A2 = new SMRectangle(1190.5513f, 1683.7795f);
    public static final SMRectangle PAGE_SIZE_A3 = new SMRectangle(841.8898f, 1190.5513f);
    public static final SMRectangle PAGE_SIZE_A4 = new SMRectangle(595.27563f, 841.8898f);
    public static final SMRectangle PAGE_SIZE_A5 = new SMRectangle(419.52756f, 595.27563f);
    public static final SMRectangle PAGE_SIZE_A6 = new SMRectangle(297.63782f, 419.52756f);
    private SMPageNode parent = null;
    private SMRectangle mediaBox = null;

    public SMPage() {
        this.page = new OMDictionary();
        this.page.setItem(OMName.TYPE, (OMBase)OMName.PAGE);
        this.setMediaBox(PAGE_SIZE_LETTER);
    }

    public SMPage(SMRectangle size) {
        this.page = new OMDictionary();
        this.page.setItem(OMName.TYPE, (OMBase)OMName.PAGE);
        this.setMediaBox(size);
    }

    public SMPage(OMDictionary pageDic) {
        this.page = pageDic;
    }

    @Override
    public OMBase getOMObject() {
        return this.page;
    }

    public OMDictionary getOMDictionary() {
        return this.page;
    }

    public SMPageNode getParent() {
        OMDictionary parentDic;
        if (this.parent == null && (parentDic = (OMDictionary)this.page.getDictionaryObject(OMName.PARENT, OMName.P)) != null) {
            this.parent = new SMPageNode(parentDic);
        }
        return this.parent;
    }

    public void setParent(SMPageNode parentNode) {
        this.parent = parentNode;
        this.page.setItem(OMName.PARENT, (OMBase)this.parent.getDictionary());
    }

    public void updateLastModified() throws IOException {
        this.page.setDate(OMName.LAST_MODIFIED, (Calendar)new GregorianCalendar());
    }

    public Calendar getLastModified() throws IOException {
        return this.page.getDate(OMName.LAST_MODIFIED);
    }

    public SMResources getResources() {
        OMDictionary resources;
        if (this.pageResources == null && (resources = (OMDictionary)this.page.getDictionaryObject(OMName.RESOURCES)) != null) {
            this.pageResources = new SMResources(resources);
        }
        return this.pageResources;
    }

    public SMResources findResources() {
        SMResources retval = this.getResources();
        SMPageNode parentNode = this.getParent();
        if (retval == null && this.parent != null) {
            retval = parentNode.findResources();
        }
        return retval;
    }

    public void setResources(SMResources resources) {
        this.pageResources = resources;
        if (resources != null) {
            this.page.setItem(OMName.RESOURCES, (OMObjectable)resources);
        } else {
            this.page.removeItem(OMName.RESOURCES);
        }
    }

    public int getStructParents() {
        return this.page.getInt(OMName.STRUCT_PARENTS, 0);
    }

    public void setStructParents(int structParents) {
        this.page.setInt(OMName.STRUCT_PARENTS, structParents);
    }

    public SMRectangle getMediaBox() {
        OMArray array;
        if (this.mediaBox == null && (array = (OMArray)this.page.getDictionaryObject(OMName.MEDIA_BOX)) != null) {
            this.mediaBox = new SMRectangle(array);
        }
        return this.mediaBox;
    }

    public SMRectangle findMediaBox() {
        SMRectangle retval = this.getMediaBox();
        if (retval == null && this.getParent() != null) {
            retval = this.getParent().findMediaBox();
        }
        if (retval == null) {
            retval = new SMRectangle();
        }
        return retval;
    }

    public void setMediaBox(SMRectangle mediaBoxValue) {
        this.mediaBox = mediaBoxValue;
        if (mediaBoxValue == null) {
            this.page.removeItem(OMName.MEDIA_BOX);
        } else {
            this.page.setItem(OMName.MEDIA_BOX, (OMBase)mediaBoxValue.getOMArray());
        }
    }

    public SMRectangle getCropBox() {
        SMRectangle retval = null;
        OMArray array = (OMArray)this.page.getDictionaryObject(OMName.CROP_BOX);
        if (array != null) {
            retval = new SMRectangle(array);
        }
        return retval;
    }

    public SMRectangle findCropBox() {
        SMRectangle retval = this.getCropBox();
        SMPageNode parentNode = this.getParent();
        if (retval == null && parentNode != null) {
            retval = this.findParentCropBox(parentNode);
        }
        if (retval == null) {
            retval = this.findMediaBox();
        }
        return retval;
    }

    private SMRectangle findParentCropBox(SMPageNode node) {
        SMRectangle rect = node.getCropBox();
        SMPageNode parentNode = node.getParent();
        if (rect == null && parentNode != null) {
            rect = this.findParentCropBox(parentNode);
        }
        return rect;
    }

    public void setCropBox(SMRectangle cropBox) {
        if (cropBox == null) {
            this.page.removeItem(OMName.CROP_BOX);
        } else {
            this.page.setItem(OMName.CROP_BOX, (OMBase)cropBox.getOMArray());
        }
    }

    public SMRectangle getBleedBox() {
        SMRectangle retval = null;
        OMArray array = (OMArray)this.page.getDictionaryObject(OMName.BLEED_BOX);
        retval = array != null ? new SMRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setBleedBox(SMRectangle bleedBox) {
        if (bleedBox == null) {
            this.page.removeItem(OMName.BLEED_BOX);
        } else {
            this.page.setItem(OMName.BLEED_BOX, (OMBase)bleedBox.getOMArray());
        }
    }

    public SMRectangle getTrimBox() {
        SMRectangle retval = null;
        OMArray array = (OMArray)this.page.getDictionaryObject(OMName.TRIM_BOX);
        retval = array != null ? new SMRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setTrimBox(SMRectangle trimBox) {
        if (trimBox == null) {
            this.page.removeItem(OMName.TRIM_BOX);
        } else {
            this.page.setItem(OMName.TRIM_BOX, (OMBase)trimBox.getOMArray());
        }
    }

    public SMRectangle getArtBox() {
        SMRectangle retval = null;
        OMArray array = (OMArray)this.page.getDictionaryObject(OMName.ART_BOX);
        retval = array != null ? new SMRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setArtBox(SMRectangle artBox) {
        if (artBox == null) {
            this.page.removeItem(OMName.ART_BOX);
        } else {
            this.page.setItem(OMName.ART_BOX, (OMBase)artBox.getOMArray());
        }
    }

    public Integer getRotation() {
        Integer retval = null;
        OMNumber value = (OMNumber)this.page.getDictionaryObject(OMName.ROTATE);
        if (value != null) {
            retval = new Integer(value.intValue());
        }
        return retval;
    }

    public int findRotation() {
        int retval = 0;
        Integer rotation = this.getRotation();
        if (rotation != null) {
            retval = rotation;
        } else {
            SMPageNode parentNode = this.getParent();
            if (parentNode != null) {
                retval = parentNode.findRotation();
            }
        }
        return retval;
    }

    public void setRotation(int rotation) {
        this.page.setInt(OMName.ROTATE, rotation);
    }

    public SMStream getContents() throws IOException {
        return SMStream.createFromOM(this.page.getDictionaryObject(OMName.CONTENTS));
    }

    public void setContents(SMStream contents) {
        this.page.setItem(OMName.CONTENTS, (OMObjectable)contents);
    }

    public List<SMThreadBead> getThreadBeads() {
        OMArray beads = (OMArray)this.page.getDictionaryObject(OMName.B);
        if (beads == null) {
            beads = new OMArray();
        }
        ArrayList<SMThreadBead> pdObjects = new ArrayList<SMThreadBead>();
        int i = 0;
        while (i < beads.size()) {
            OMDictionary beadDic = (OMDictionary)beads.getObject(i);
            SMThreadBead bead = null;
            if (beadDic != null) {
                bead = new SMThreadBead(beadDic);
            }
            pdObjects.add(bead);
            ++i;
        }
        return new OMArrayList<SMThreadBead>(pdObjects, beads);
    }

    public void setThreadBeads(List<SMThreadBead> beads) {
        this.page.setItem(OMName.B, (OMBase)OMArrayList.converterToOMArray(beads));
    }

    public SMMetadata getMetadata() {
        SMMetadata retval = null;
        OMStream stream = (OMStream)this.page.getDictionaryObject(OMName.METADATA);
        if (stream != null) {
            retval = new SMMetadata(stream);
        }
        return retval;
    }

    public void setMetadata(SMMetadata meta) {
        this.page.setItem(OMName.METADATA, (OMObjectable)meta);
    }

    public BufferedImage convertToImage() throws Exception {
        return this.convertToImage(8, 144);
    }

    public BufferedImage convertToImage(int imageType, int resolution) throws Exception {
        SMRectangle cropBox = this.findCropBox();
        float widthPt = cropBox.getWidth();
        float heightPt = cropBox.getHeight();
        float scaling = (float)resolution / 72.0f;
        int widthPx = Math.round(widthPt * scaling);
        int heightPx = Math.round(heightPt * scaling);
        Dimension pageDimension = new Dimension((int)widthPt, (int)heightPt);
        BufferedImage retval = null;
        int rotationAngle = this.findRotation();
        if (rotationAngle < 0) {
            rotationAngle += 360;
        } else if (rotationAngle >= 360) {
            rotationAngle -= 360;
        }
        retval = rotationAngle == 90 || rotationAngle == 270 ? new BufferedImage(heightPx, widthPx, imageType) : new BufferedImage(widthPx, heightPx, imageType);
        Graphics2D graphics = (Graphics2D)retval.getGraphics();
        graphics.setBackground(TRANSPARENT_WHITE);
        graphics.clearRect(0, 0, retval.getWidth(), retval.getHeight());
        if (rotationAngle != 0) {
            int translateX = 0;
            int translateY = 0;
            switch (rotationAngle) {
                case 90: {
                    translateX = retval.getWidth();
                    break;
                }
                case 270: {
                    translateY = retval.getHeight();
                    break;
                }
                case 180: {
                    translateX = retval.getWidth();
                    translateY = retval.getHeight();
                    break;
                }
            }
            graphics.translate(translateX, translateY);
            graphics.rotate((float)Math.toRadians(rotationAngle));
        }
        graphics.scale(scaling, scaling);
        PageDrawer drawer = new PageDrawer();
        drawer.drawPage(graphics, this, pageDimension);
        return retval;
    }

    public SMPageAdditionalActions getActions() {
        OMDictionary addAct = (OMDictionary)this.page.getDictionaryObject(OMName.AA);
        if (addAct == null) {
            addAct = new OMDictionary();
            this.page.setItem(OMName.AA, (OMBase)addAct);
        }
        return new SMPageAdditionalActions(addAct);
    }

    public void setActions(SMPageAdditionalActions actions) {
        this.page.setItem(OMName.AA, (OMObjectable)actions);
    }

    public List<SMAnnotation> getAnnotations() throws IOException {
        OMArrayList<SMAnnotation> retval = null;
        OMArray annots = (OMArray)this.page.getDictionaryObject(OMName.ANNOTS);
        if (annots == null) {
            annots = new OMArray();
            this.page.setItem(OMName.ANNOTS, (OMBase)annots);
            retval = new OMArrayList<SMAnnotation>(new ArrayList(), annots);
        } else {
            ArrayList<SMAnnotation> actuals = new ArrayList<SMAnnotation>();
            int i = 0;
            while (i < annots.size()) {
                OMBase item = annots.getObject(i);
                actuals.add(SMAnnotation.createAnnotation(item));
                ++i;
            }
            retval = new OMArrayList(actuals, annots);
        }
        return retval;
    }

    public void setAnnotations(List<SMAnnotation> annots) {
        this.page.setItem(OMName.ANNOTS, (OMBase)OMArrayList.converterToOMArray(annots));
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        try {
            PageDrawer drawer = new PageDrawer();
            SMRectangle cropBox = this.findCropBox();
            drawer.drawPage(graphics, this, cropBox.createDimension());
            return 0;
        }
        catch (IOException io) {
            throw new PrinterIOException(io);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public boolean equals(Object other) {
        return other instanceof SMPage && ((SMPage)other).getOMObject() == this.getOMObject();
    }

    public int hashCode() {
        return this.getOMDictionary().hashCode();
    }

    public void addAnnotations(OMObjectable annot) throws IOException {
        List<SMAnnotation> annotlist = this.getAnnotations();
        annotlist.add((SMAnnotation)annot);
        this.setAnnotations(annotlist);
    }
}

