/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentNameDictionary;
import com.plpdf.smmodel.SMPageNode;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMDestinationOrAction;
import com.plpdf.smmodel.common.SMMetadata;
import com.plpdf.smmodel.common.SMPageLabels;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMMarkInfo;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMStructureTreeRoot;
import com.plpdf.smmodel.graphics.color.SMOutputIntent;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentProperties;
import com.plpdf.smmodel.interactive.action.SMActionFactory;
import com.plpdf.smmodel.interactive.action.SMDocumentCatalogAdditionalActions;
import com.plpdf.smmodel.interactive.action.type.SMURIDictionary;
import com.plpdf.smmodel.interactive.documentnavigation.destination.SMDestination;
import com.plpdf.smmodel.interactive.documentnavigation.outline.SMDocumentOutline;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.pagenavigation.SMThread;
import com.plpdf.smmodel.interactive.viewerpreferences.SMViewerPreferences;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMDocumentCatalog
implements OMObjectable {
    private OMDictionary root;
    private SMDocument document;
    private SMAcroForm acroForm = null;
    public static final String PAGE_MODE_USE_NONE = "UseNone";
    public static final String PAGE_MODE_USE_OUTLINES = "UseOutlines";
    public static final String PAGE_MODE_USE_THUMBS = "UseThumbs";
    public static final String PAGE_MODE_FULL_SCREEN = "FullScreen";
    public static final String PAGE_MODE_USE_OPTIONAL_CONTENT = "UseOC";
    public static final String PAGE_MODE_USE_ATTACHMENTS = "UseAttachments";
    public static final String PAGE_LAYOUT_SINGLE_PAGE = "SinglePage";
    public static final String PAGE_LAYOUT_ONE_COLUMN = "OneColumn";
    public static final String PAGE_LAYOUT_TWO_COLUMN_LEFT = "TwoColumnLeft";
    public static final String PAGE_LAYOUT_TWO_COLUMN_RIGHT = "TwoColumnRight";
    public static final String PAGE_LAYOUT_TWO_PAGE_LEFT = "TwoPageLeft";
    public static final String PAGE_LAYOUT_TWO_PAGE_RIGHT = "TwoPageRight";

    public SMDocumentCatalog(SMDocument doc) {
        this.document = doc;
        this.root = new OMDictionary();
        this.root.setItem(OMName.TYPE, (OMBase)OMName.CATALOG);
        this.document.getDocument().getTrailer().setItem(OMName.ROOT, (OMBase)this.root);
    }

    public SMDocumentCatalog(SMDocument doc, OMDictionary rootDictionary) {
        this.document = doc;
        this.root = rootDictionary;
    }

    @Override
    public OMBase getOMObject() {
        return this.root;
    }

    public OMDictionary getOMDictionary() {
        return this.root;
    }

    public SMAcroForm getAcroForm() {
        OMDictionary acroFormDic;
        if (this.acroForm == null && (acroFormDic = (OMDictionary)this.root.getDictionaryObject(OMName.ACRO_FORM)) != null) {
            this.acroForm = new SMAcroForm(this.document, acroFormDic);
        }
        return this.acroForm;
    }

    public void setAcroForm(SMAcroForm acro) {
        this.root.setItem(OMName.ACRO_FORM, (OMObjectable)acro);
    }

    public SMPageNode getPages() {
        return new SMPageNode((OMDictionary)this.root.getDictionaryObject(OMName.PAGES));
    }

    public List getAllPages() {
        ArrayList retval = new ArrayList();
        SMPageNode rootNode = this.getPages();
        rootNode.getAllKids(retval);
        return retval;
    }

    public SMViewerPreferences getViewerPreferences() {
        SMViewerPreferences retval = null;
        OMDictionary dict = (OMDictionary)this.root.getDictionaryObject(OMName.VIEWER_PREFERENCES);
        if (dict != null) {
            retval = new SMViewerPreferences(dict);
        }
        return retval;
    }

    public void setViewerPreferences(SMViewerPreferences prefs) {
        this.root.setItem(OMName.VIEWER_PREFERENCES, (OMObjectable)prefs);
    }

    public SMDocumentOutline getDocumentOutline() {
        SMDocumentOutline retval = null;
        OMDictionary dict = (OMDictionary)this.root.getDictionaryObject(OMName.OUTLINES);
        if (dict != null) {
            retval = new SMDocumentOutline(dict);
        }
        return retval;
    }

    public void setDocumentOutline(SMDocumentOutline outlines) {
        this.root.setItem(OMName.OUTLINES, (OMObjectable)outlines);
    }

    public List getThreads() {
        OMArray array = (OMArray)this.root.getDictionaryObject(OMName.THREADS);
        if (array == null) {
            array = new OMArray();
            this.root.setItem(OMName.THREADS, (OMBase)array);
        }
        ArrayList<SMThread> pdObjects = new ArrayList<SMThread>();
        int i = 0;
        while (i < array.size()) {
            pdObjects.add(new SMThread((OMDictionary)array.getObject(i)));
            ++i;
        }
        return new OMArrayList(pdObjects, array);
    }

    public void setThreads(List threads) {
        this.root.setItem(OMName.THREADS, (OMBase)OMArrayList.converterToOMArray(threads));
    }

    public SMMetadata getMetadata() {
        SMMetadata retval = null;
        OMStream stream = (OMStream)this.root.getDictionaryObject(OMName.METADATA);
        if (stream != null) {
            retval = new SMMetadata(stream);
        }
        return retval;
    }

    public void setMetadata(SMMetadata meta) {
        this.root.setItem(OMName.METADATA, (OMObjectable)meta);
    }

    public void setOpenAction(SMDestinationOrAction action) {
        this.root.setItem(OMName.OPEN_ACTION, (OMObjectable)action);
    }

    public SMDestinationOrAction getOpenAction() throws IOException {
        SMDestinationOrAction action = null;
        OMBase actionObj = this.root.getDictionaryObject(OMName.OPEN_ACTION);
        if (actionObj != null) {
            if (actionObj instanceof OMDictionary) {
                action = SMActionFactory.createAction((OMDictionary)actionObj);
            } else if (actionObj instanceof OMArray) {
                action = SMDestination.create(actionObj);
            } else {
                throw new IOException("Unknown OpenAction " + actionObj);
            }
        }
        return action;
    }

    public SMDocumentCatalogAdditionalActions getActions() {
        OMDictionary addAct = (OMDictionary)this.root.getDictionaryObject(OMName.AA);
        if (addAct == null) {
            addAct = new OMDictionary();
            this.root.setItem(OMName.AA, (OMBase)addAct);
        }
        return new SMDocumentCatalogAdditionalActions(addAct);
    }

    public void setActions(SMDocumentCatalogAdditionalActions actions) {
        this.root.setItem(OMName.AA, (OMObjectable)actions);
    }

    public SMDocumentNameDictionary getNames() {
        SMDocumentNameDictionary nameDic = null;
        OMDictionary names = (OMDictionary)this.root.getDictionaryObject(OMName.NAMES);
        if (names != null) {
            nameDic = new SMDocumentNameDictionary(this, names);
        }
        return nameDic;
    }

    public void setNames(SMDocumentNameDictionary names) {
        this.root.setItem(OMName.NAMES, (OMObjectable)names);
    }

    public SMMarkInfo getMarkInfo() {
        SMMarkInfo retval = null;
        OMDictionary dic = (OMDictionary)this.root.getDictionaryObject(OMName.MARK_INFO);
        if (dic != null) {
            retval = new SMMarkInfo(dic);
        }
        return retval;
    }

    public void setMarkInfo(SMMarkInfo markInfo) {
        this.root.setItem(OMName.MARK_INFO, (OMObjectable)markInfo);
    }

    public List<SMOutputIntent> getOutputIntent() {
        ArrayList<SMOutputIntent> retval = new ArrayList<SMOutputIntent>();
        OMArray array = (OMArray)this.root.getItem(OMName.OUTPUT_INTENTS);
        if (array != null) {
            for (OMBase cosBase : array) {
                SMOutputIntent oi = new SMOutputIntent((OMStream)cosBase);
                retval.add(oi);
            }
        }
        return retval;
    }

    public void addOutputIntent(SMOutputIntent outputIntent) {
        OMArray array = (OMArray)this.root.getItem(OMName.OUTPUT_INTENTS);
        if (array == null) {
            array = new OMArray();
            this.root.setItem(OMName.OUTPUT_INTENTS, (OMBase)array);
        }
        array.add(outputIntent.getOMObject());
    }

    public void setOutputIntents(List<SMOutputIntent> outputIntents) {
        OMArray array = new OMArray();
        for (SMOutputIntent intent : outputIntents) {
            array.add(intent.getOMObject());
        }
        this.root.setItem(OMName.OUTPUT_INTENTS, (OMBase)array);
    }

    public String getPageMode() {
        return this.root.getNameAsString(OMName.PAGE_MODE, PAGE_MODE_USE_NONE);
    }

    public void setPageMode(String mode) {
        this.root.setName(OMName.PAGE_MODE, mode);
    }

    public String getPageLayout() {
        return this.root.getNameAsString(OMName.PAGE_LAYOUT, PAGE_LAYOUT_SINGLE_PAGE);
    }

    public void setPageLayout(String layout) {
        this.root.setName(OMName.PAGE_LAYOUT, layout);
    }

    public SMURIDictionary getURI() {
        SMURIDictionary retval = null;
        OMDictionary uri = (OMDictionary)this.root.getDictionaryObject(OMName.URI);
        if (uri != null) {
            retval = new SMURIDictionary(uri);
        }
        return retval;
    }

    public void setURI(SMURIDictionary uri) {
        this.root.setItem(OMName.URI, (OMObjectable)uri);
    }

    public SMStructureTreeRoot getStructureTreeRoot() {
        SMStructureTreeRoot treeRoot = null;
        OMDictionary dic = (OMDictionary)this.root.getDictionaryObject(OMName.STRUCT_TREE_ROOT);
        if (dic != null) {
            treeRoot = new SMStructureTreeRoot(dic);
        }
        return treeRoot;
    }

    public void setStructureTreeRoot(SMStructureTreeRoot treeRoot) {
        this.root.setItem(OMName.STRUCT_TREE_ROOT, (OMObjectable)treeRoot);
    }

    public String getLanguage() {
        return this.root.getString(OMName.LANG);
    }

    public void setLanguage(String language) throws IOException {
        this.root.setString(OMName.LANG, language);
    }

    public String getVersion() {
        return this.root.getNameAsString(OMName.VERSION);
    }

    public void setVersion(String version) {
        this.root.setName(OMName.VERSION, version);
    }

    public SMPageLabels getPageLabels() throws IOException {
        SMPageLabels labels = null;
        OMDictionary dict = (OMDictionary)this.root.getDictionaryObject(OMName.PAGE_LABELS);
        if (dict != null) {
            labels = new SMPageLabels(this.document, dict);
        }
        return labels;
    }

    public void setPageLabels(SMPageLabels labels) {
        this.root.setItem(OMName.PAGE_LABELS, (OMObjectable)labels);
    }

    public SMOptionalContentProperties getOCProperties() {
        SMOptionalContentProperties retval = null;
        OMDictionary dict = (OMDictionary)this.root.getDictionaryObject(OMName.OCPROPERTIES);
        if (dict != null) {
            retval = new SMOptionalContentProperties(dict);
        }
        return retval;
    }

    public void setOCProperties(SMOptionalContentProperties ocProperties) {
        this.root.setItem(OMName.OCPROPERTIES, (OMObjectable)ocProperties);
    }

    public void setPerms(OMDictionary perms) {
        this.root.setItem(OMName.PERMS, (OMBase)perms);
    }
}

