/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.InvalidPasswordException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.exceptions.SignatureException;
import com.plpdf.io.RandomAccess;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.pdfparser.NonSequentialPDFParser;
import com.plpdf.pdfparser.PDFParser;
import com.plpdf.pdfwriter.OMWriter;
import com.plpdf.smmodel.SMDocumentCatalog;
import com.plpdf.smmodel.SMDocumentInformation;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMPageNode;
import com.plpdf.smmodel.SMPageable;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.BadSecurityHandlerException;
import com.plpdf.smmodel.encryption.DecryptionMaterial;
import com.plpdf.smmodel.encryption.ProtectionPolicy;
import com.plpdf.smmodel.encryption.SMEncryptionDictionary;
import com.plpdf.smmodel.encryption.SecurityHandler;
import com.plpdf.smmodel.encryption.SecurityHandlersManager;
import com.plpdf.smmodel.encryption.StandardDecryptionMaterial;
import com.plpdf.smmodel.encryption.StandardProtectionPolicy;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentGroup;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentProperties;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceDictionary;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceStream;
import com.plpdf.smmodel.interactive.digitalsignature.SMSignature;
import com.plpdf.smmodel.interactive.digitalsignature.SignatureInterface;
import com.plpdf.smmodel.interactive.digitalsignature.SignatureOptions;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMField;
import com.plpdf.smmodel.interactive.form.SMSignatureField;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMDocument
implements Pageable {
    private static final String CLASS_NAME = SMDocument.class.getName();
    private OMDocument document;
    private SMDocumentInformation documentInformation;
    private SMDocumentCatalog documentCatalog;
    private SMEncryptionDictionary encParameters = null;
    private SecurityHandler securityHandler = null;
    private Map<String, Integer> pageMap = null;
    private boolean allSecurityToBeRemoved = false;
    private static final String PDF_HEADER = "%PDF-";

    public SMDocument() throws IOException {
        this.document = new OMDocument();
        OMDictionary trailer = new OMDictionary();
        this.document.setTrailer(trailer);
        OMDictionary rootDictionary = new OMDictionary();
        trailer.setItem(OMName.ROOT, (OMBase)rootDictionary);
        rootDictionary.setItem(OMName.TYPE, (OMBase)OMName.CATALOG);
        rootDictionary.setItem(OMName.VERSION, (OMBase)OMName.getPDFName("1.4"));
        OMDictionary pages = new OMDictionary();
        rootDictionary.setItem(OMName.PAGES, (OMBase)pages);
        pages.setItem(OMName.TYPE, (OMBase)OMName.PAGES);
        OMArray kidsArray = new OMArray();
        pages.setItem(OMName.KIDS, (OMBase)kidsArray);
        pages.setItem(OMName.COUNT, (OMBase)OMInteger.ZERO);
    }

    private void generatePageMap() {
        this.pageMap = new HashMap<String, Integer>();
        this.processListOfPageReferences(this.getDocumentCatalog().getPages().getKids());
    }

    private void processListOfPageReferences(List<Object> pageNodes) {
        int numberOfNodes = pageNodes.size();
        int i = 0;
        while (i < numberOfNodes) {
            Object pageOrArray = pageNodes.get(i);
            if (pageOrArray instanceof SMPage) {
                OMArray pageArray = ((OMArrayList)((SMPage)pageOrArray).getParent().getKids()).toList();
                this.parseCatalogObject((OMObject)pageArray.get(i));
            } else if (pageOrArray instanceof SMPageNode) {
                this.processListOfPageReferences(((SMPageNode)pageOrArray).getKids());
            }
            ++i;
        }
    }

    private void parseCatalogObject(OMObject thePageOrArrayObject) {
        block6: {
            OMBase kidsBase;
            block7: {
                int kidsCount;
                int arrayCount;
                block5: {
                    OMBase arrayCountBase = thePageOrArrayObject.getItem(OMName.COUNT);
                    arrayCount = -1;
                    if (arrayCountBase instanceof OMInteger) {
                        arrayCount = ((OMInteger)arrayCountBase).intValue();
                    }
                    kidsBase = thePageOrArrayObject.getItem(OMName.KIDS);
                    kidsCount = -1;
                    if (kidsBase instanceof OMArray) {
                        kidsCount = ((OMArray)kidsBase).size();
                    }
                    if (arrayCount != -1 && kidsCount != -1) break block5;
                    String objStr = String.valueOf(thePageOrArrayObject.getObjectNumber().intValue());
                    String genStr = String.valueOf(thePageOrArrayObject.getGenerationNumber().intValue());
                    this.getPageMap().put(String.valueOf(objStr) + "," + genStr, new Integer(this.getPageMap().size() + 1));
                    break block6;
                }
                if (arrayCount != kidsCount) break block7;
                OMArray kidsArray = (OMArray)kidsBase;
                int i = 0;
                while (i < kidsArray.size()) {
                    OMObject thisObject = (OMObject)kidsArray.get(i);
                    String objStr = String.valueOf(thisObject.getObjectNumber().intValue());
                    String genStr = String.valueOf(thisObject.getGenerationNumber().intValue());
                    this.getPageMap().put(String.valueOf(objStr) + "," + genStr, new Integer(this.getPageMap().size() + 1));
                    ++i;
                }
                break block6;
            }
            OMArray list = null;
            if (kidsBase instanceof OMArray) {
                list = (OMArray)kidsBase;
            }
            if (list == null) break block6;
            int arrayCounter = 0;
            while (arrayCounter < list.size()) {
                this.parseCatalogObject((OMObject)list.get(arrayCounter));
                ++arrayCounter;
            }
        }
    }

    public final Map<String, Integer> getPageMap() {
        if (this.pageMap == null) {
            this.generatePageMap();
        }
        return this.pageMap;
    }

    public void addPage(SMPage page) {
        SMPageNode rootPages = this.getDocumentCatalog().getPages();
        rootPages.getKids().add(page);
        page.setParent(rootPages);
        rootPages.updateCount();
    }

    public void addSignature(SMSignature sigObject, SignatureInterface signatureInterface) throws IOException, SignatureException {
        SignatureOptions defaultOptions = new SignatureOptions();
        defaultOptions.setPage(1);
        this.addSignature(sigObject, signatureInterface, defaultOptions);
    }

    public void addSignature(SMSignature sigObject, SignatureInterface signatureInterface, SignatureOptions options) throws IOException, SignatureException {
        OMDocument visualSignature;
        int preferedSignatureSize = options.getPreferedSignatureSize();
        if (preferedSignatureSize > 0) {
            sigObject.setContents(new byte[preferedSignatureSize * 2 + 2]);
        } else {
            sigObject.setContents(new byte[18946]);
        }
        int[] nArray = new int[4];
        nArray[1] = 1000000000;
        nArray[2] = 1000000000;
        nArray[3] = 1000000000;
        sigObject.setByteRange(nArray);
        this.getDocument().setSignatureInterface(signatureInterface);
        SMDocumentCatalog root = this.getDocumentCatalog();
        SMPageNode rootPages = root.getPages();
        ArrayList kids = new ArrayList();
        rootPages.getAllKids(kids);
        int size = (int)rootPages.getCount();
        SMPage page = null;
        if (size == 0) {
            throw new SignatureException(5, "The PDF file has no pages");
        }
        page = options.getPage() > size ? (SMPage)kids.get(size - 1) : (options.getPage() <= 0 ? (SMPage)kids.get(0) : (SMPage)kids.get(options.getPage() - 1));
        SMAcroForm acroForm = root.getAcroForm();
        root.getOMObject().setNeedToBeUpdate(true);
        if (acroForm == null) {
            acroForm = new SMAcroForm(this);
            root.setAcroForm(acroForm);
        } else {
            acroForm.getOMObject().setNeedToBeUpdate(true);
        }
        List<SMAnnotation> annotations = page.getAnnotations();
        List<SMField> fields = acroForm.getFields();
        SMSignatureField signatureField = null;
        if (fields == null) {
            fields = new ArrayList<SMField>();
            acroForm.setFields(fields);
        }
        for (SMField pdField : fields) {
            SMSignature signature;
            if (!(pdField instanceof SMSignatureField) || (signature = ((SMSignatureField)pdField).getSignature()) == null || !signature.getDictionary().equals(sigObject.getDictionary())) continue;
            signatureField = (SMSignatureField)pdField;
        }
        if (signatureField == null) {
            signatureField = new SMSignatureField(acroForm);
            signatureField.setSignature(sigObject);
            signatureField.getWidget().setPage(page);
        }
        List<SMField> acroFormFields = acroForm.getFields();
        OMDictionary acroFormDict = acroForm.getDictionary();
        acroFormDict.setDirect(true);
        acroFormDict.setInt(OMName.SIG_FLAGS, 3);
        boolean checkFields = false;
        for (SMField field : acroFormFields) {
            if (!(field instanceof SMSignatureField) || !((SMSignatureField)field).getOMObject().equals(signatureField.getOMObject())) continue;
            checkFields = true;
            signatureField.getOMObject().setNeedToBeUpdate(true);
            break;
        }
        if (!checkFields) {
            acroFormFields.add(signatureField);
        }
        if ((visualSignature = options.getVisualSignature()) == null) {
            signatureField.getWidget().setRectangle(new SMRectangle());
            acroFormDict.setItem(OMName.DR, null);
            SMAppearanceDictionary ap = new SMAppearanceDictionary();
            OMStream apsStream = this.getDocument().createOMStream();
            apsStream.createUnfilteredStream();
            SMAppearanceStream aps = new SMAppearanceStream(apsStream);
            OMDictionary cosObject = (OMDictionary)aps.getOMObject();
            cosObject.setItem(OMName.SUBTYPE, (OMBase)OMName.FORM);
            cosObject.setItem(OMName.BBOX, (OMObjectable)new SMRectangle());
            ap.setNormalAppearance(aps);
            ap.getDictionary().setDirect(true);
            signatureField.getWidget().setAppearance(ap);
        } else {
            List<OMObject> omObjects = visualSignature.getObjects();
            boolean annotNotFound = true;
            boolean sigFieldNotFound = true;
            for (OMObject omObject : omObjects) {
                OMDictionary cosBaseDict;
                if (!annotNotFound && !sigFieldNotFound) break;
                OMBase base = omObject.getObject();
                if (base == null || !(base instanceof OMDictionary)) continue;
                OMBase ft = ((OMDictionary)base).getItem(OMName.FT);
                OMBase type = ((OMDictionary)base).getItem(OMName.TYPE);
                OMBase apDict = ((OMDictionary)base).getItem(OMName.AP);
                if (annotNotFound && OMName.ANNOT.equals(type)) {
                    cosBaseDict = (OMDictionary)base;
                    OMArray rectAry = (OMArray)cosBaseDict.getItem(OMName.RECT);
                    SMRectangle rect = new SMRectangle(rectAry);
                    signatureField.getWidget().setRectangle(rect);
                    annotNotFound = false;
                }
                if (!sigFieldNotFound || !OMName.SIG.equals(ft) || apDict == null) continue;
                cosBaseDict = (OMDictionary)base;
                SMAppearanceDictionary ap = new SMAppearanceDictionary((OMDictionary)cosBaseDict.getItem(OMName.AP));
                ap.getDictionary().setDirect(true);
                signatureField.getWidget().setAppearance(ap);
                OMBase dr = cosBaseDict.getItem(OMName.DR);
                dr.setDirect(true);
                dr.setNeedToBeUpdate(true);
                acroFormDict.setItem(OMName.DR, dr);
                sigFieldNotFound = false;
            }
            if (annotNotFound || sigFieldNotFound) {
                throw new SignatureException(6, "Could not read all needed objects from template");
            }
        }
        if (annotations == null) {
            annotations = new OMArrayList<SMAnnotation>();
            page.setAnnotations(annotations);
        }
        if (!(annotations instanceof OMArrayList && acroFormFields instanceof OMArrayList && ((OMArrayList)annotations).toList().equals(((OMArrayList)acroFormFields).toList()) || checkFields)) {
            annotations.add(signatureField.getWidget());
        }
        page.getOMObject().setNeedToBeUpdate(true);
    }

    public void addSignatureField(List<SMSignatureField> sigFields, SignatureInterface signatureInterface, SignatureOptions options) throws IOException, SignatureException {
        SMDocumentCatalog catalog = this.getDocumentCatalog();
        catalog.getOMObject().setNeedToBeUpdate(true);
        SMAcroForm acroForm = catalog.getAcroForm();
        if (acroForm == null) {
            acroForm = new SMAcroForm(this);
            catalog.setAcroForm(acroForm);
        } else {
            acroForm.getOMObject().setNeedToBeUpdate(true);
        }
        OMDictionary acroFormDict = acroForm.getDictionary();
        acroFormDict.setDirect(true);
        acroFormDict.setNeedToBeUpdate(true);
        if (acroFormDict.getInt(OMName.SIG_FLAGS) < 1) {
            acroFormDict.setInt(OMName.SIG_FLAGS, 1);
        }
        List<SMField> field = acroForm.getFields();
        for (SMSignatureField sigField : sigFields) {
            SMSignature sigObject = sigField.getSignature();
            sigField.getOMObject().setNeedToBeUpdate(true);
            boolean checkFields = false;
            for (SMField obj : field) {
                if (!(obj instanceof SMSignatureField) || !((SMSignatureField)obj).getOMObject().equals(sigField.getOMObject())) continue;
                checkFields = true;
                sigField.getOMObject().setNeedToBeUpdate(true);
                break;
            }
            if (!checkFields) {
                field.add(sigField);
            }
            if (sigField.getSignature() == null) continue;
            sigField.getOMObject().setNeedToBeUpdate(true);
            this.addSignature(sigField.getSignature(), signatureInterface, options);
        }
    }

    public boolean removePage(SMPage page) {
        SMPageNode parent = page.getParent();
        boolean retval = parent.getKids().remove(page);
        if (retval) {
            this.getDocumentCatalog().getPages().updateCount();
        }
        return retval;
    }

    public boolean removePage(int pageNumber) {
        boolean removed = false;
        List allPages = this.getDocumentCatalog().getAllPages();
        if (allPages.size() > pageNumber) {
            SMPage page = (SMPage)allPages.get(pageNumber);
            removed = this.removePage(page);
        }
        return removed;
    }

    public SMPage importPage(SMPage page) throws IOException {
        SMPage importedPage = new SMPage(new OMDictionary(page.getOMDictionary()));
        InputStream is = null;
        OutputStream os = null;
        try {
            SMStream src = page.getContents();
            if (src != null) {
                SMStream dest = new SMStream(this.document.createCOSStream(src.getStream()));
                ArrayList<OMName> filters = null;
                filters = new ArrayList<OMName>();
                filters.add(OMName.FLATE_DECODE);
                dest.setFilters(filters);
                importedPage.setContents(dest);
                os = dest.createOutputStream();
                byte[] buf = new byte[10240];
                int amountRead = 0;
                is = src.createInputStream();
                while ((amountRead = is.read(buf, 0, 10240)) > -1) {
                    os.write(buf, 0, amountRead);
                }
            }
            this.addPage(importedPage);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return importedPage;
    }

    public SMDocument(OMDocument doc) {
        this.document = doc;
    }

    public OMDocument getDocument() {
        return this.document;
    }

    public SMDocumentInformation getDocumentInformation() {
        if (this.documentInformation == null) {
            OMDictionary trailer = this.document.getTrailer();
            OMDictionary infoDic = (OMDictionary)trailer.getDictionaryObject(OMName.INFO);
            if (infoDic == null) {
                infoDic = new OMDictionary();
                trailer.setItem(OMName.INFO, (OMBase)infoDic);
            }
            this.documentInformation = new SMDocumentInformation(infoDic);
        }
        return this.documentInformation;
    }

    public void setDocumentInformation(SMDocumentInformation info) {
        this.documentInformation = info;
        this.document.getTrailer().setItem(OMName.INFO, (OMBase)info.getDictionary());
    }

    public SMDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            OMDictionary trailer = this.document.getTrailer();
            OMBase dictionary = trailer.getDictionaryObject(OMName.ROOT);
            this.documentCatalog = dictionary instanceof OMDictionary ? new SMDocumentCatalog(this, (OMDictionary)dictionary) : new SMDocumentCatalog(this);
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public SMEncryptionDictionary getEncryptionDictionary() {
        if (this.encParameters == null && this.isEncrypted()) {
            this.encParameters = new SMEncryptionDictionary(this.document.getEncryptionDictionary());
        }
        return this.encParameters;
    }

    public void setEncryptionDictionary(SMEncryptionDictionary encDictionary) throws IOException {
        this.encParameters = encDictionary;
    }

    @Deprecated
    public SMSignature getSignatureDictionary() throws IOException {
        return this.getLastSignatureDictionary();
    }

    public SMSignature getLastSignatureDictionary() throws IOException {
        List<SMSignature> signatureDictionaries = this.getSignatureDictionaries();
        int size = signatureDictionaries.size();
        if (size > 0) {
            return signatureDictionaries.get(size - 1);
        }
        return null;
    }

    public List<SMSignatureField> getSignatureFields() throws IOException {
        LinkedList<SMSignatureField> fields = new LinkedList<SMSignatureField>();
        SMAcroForm acroForm = this.getDocumentCatalog().getAcroForm();
        if (acroForm != null) {
            List<OMDictionary> signatureDictionary = this.document.getSignatureFields(false);
            for (OMDictionary dict : signatureDictionary) {
                fields.add(new SMSignatureField(acroForm, dict));
            }
        }
        return fields;
    }

    public List<SMSignature> getSignatureDictionaries() throws IOException {
        List<OMDictionary> signatureDictionary = this.document.getSignatureDictionaries();
        LinkedList<SMSignature> signatures = new LinkedList<SMSignature>();
        for (OMDictionary dict : signatureDictionary) {
            signatures.add(new SMSignature(dict));
        }
        return signatures;
    }

    @Deprecated
    public boolean isUserPassword(String password) throws IOException, CryptographyException {
        return false;
    }

    @Deprecated
    public boolean isOwnerPassword(String password) throws IOException, CryptographyException {
        return false;
    }

    public void decrypt(String password) throws CryptographyException, IOException, InvalidPasswordException, PlpdfException, NoSuchAlgorithmException {
        try {
            StandardDecryptionMaterial m = new StandardDecryptionMaterial(password);
            this.openProtection(m);
            this.document.dereferenceObjectStreams();
        }
        catch (BadSecurityHandlerException e) {
            throw new CryptographyException(e);
        }
    }

    @Deprecated
    public boolean wasDecryptedWithOwnerPassword() {
        return false;
    }

    public void encrypt(String ownerPassword, String userPassword) throws CryptographyException, IOException {
        try {
            StandardProtectionPolicy policy = new StandardProtectionPolicy(ownerPassword, userPassword, new AccessPermission());
            this.protect(policy);
        }
        catch (BadSecurityHandlerException e) {
            throw new CryptographyException(e);
        }
    }

    @Deprecated
    public String getOwnerPasswordForEncryption() {
        return null;
    }

    @Deprecated
    public String getUserPasswordForEncryption() {
        return null;
    }

    @Deprecated
    public boolean willEncryptWhenSaving() {
        return false;
    }

    @Deprecated
    public void clearWillEncryptWhenSaving() {
    }

    public static SMDocument load(URL url) throws IOException, CryptographyException {
        return SMDocument.load(url.openStream());
    }

    public static SMDocument load(URL url, boolean force) throws IOException, CryptographyException {
        return SMDocument.load(url.openStream(), force);
    }

    public static SMDocument load(URL url, RandomAccess scratchFile) throws IOException, CryptographyException {
        return SMDocument.load(url.openStream(), scratchFile);
    }

    public static SMDocument load(String filename) throws IOException, CryptographyException {
        return SMDocument.load(new FileInputStream(filename));
    }

    public static SMDocument load(String filename, boolean force) throws IOException, CryptographyException {
        return SMDocument.load((InputStream)new FileInputStream(filename), force);
    }

    public static SMDocument load(String filename, RandomAccess scratchFile) throws IOException, CryptographyException {
        return SMDocument.load((InputStream)new FileInputStream(filename), scratchFile);
    }

    public static SMDocument load(File file) throws IOException, CryptographyException {
        return SMDocument.load(new FileInputStream(file));
    }

    public static SMDocument load(File file, RandomAccess scratchFile) throws IOException, CryptographyException {
        return SMDocument.load((InputStream)new FileInputStream(file), scratchFile);
    }

    public static SMDocument load(InputStream input) throws IOException, CryptographyException {
        return SMDocument.load(input, null);
    }

    public static SMDocument load(InputStream input, boolean force) throws IOException, CryptographyException {
        return SMDocument.load(input, null, force);
    }

    public static SMDocument load(InputStream input, RandomAccess scratchFile) throws IOException, CryptographyException {
        PDFParser parser = new PDFParser((InputStream)new BufferedInputStream(input), scratchFile);
        parser.parse();
        return parser.getSMDocument();
    }

    public static SMDocument load(InputStream input, RandomAccess scratchFile, boolean force) throws IOException, CryptographyException {
        PDFParser parser = new PDFParser(new BufferedInputStream(input), scratchFile, force);
        parser.parse();
        return parser.getSMDocument();
    }

    public static SMDocument loadNonSeq(File file, RandomAccess scratchFile) throws IOException, CryptographyException {
        return SMDocument.loadNonSeq(file, scratchFile, "");
    }

    public static SMDocument loadNonSeq(InputStream input, RandomAccess scratchFile) throws IOException {
        return SMDocument.loadNonSeq(input, scratchFile, "");
    }

    public static SMDocument loadNonSeq(InputStream input, RandomAccess scratchFile, String password) throws IOException {
        NonSequentialPDFParser parser = new NonSequentialPDFParser(input, scratchFile, password);
        parser.parse();
        return parser.getSMDocument();
    }

    public static SMDocument loadNonSeq(File file, RandomAccess scratchFile, String password) throws IOException, CryptographyException {
        NonSequentialPDFParser parser = new NonSequentialPDFParser(file, scratchFile, password);
        parser.parse();
        return parser.getSMDocument();
    }

    public void save(String fileName) throws Exception {
        this.save(new File(fileName));
    }

    public void save(File file) throws Exception {
        this.save(new FileOutputStream(file));
    }

    public void save(OutputStream output) throws Exception {
        this.getDocumentCatalog().getPages().updateCount();
        OMWriter writer = null;
        try {
            writer = new OMWriter(output);
            writer.write(this);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void saveIncremental(String fileName) throws Exception {
        this.saveIncremental(new FileInputStream(fileName), new FileOutputStream(fileName, true));
    }

    public void saveIncremental(FileInputStream input, OutputStream output) throws Exception {
        this.getDocumentCatalog().getPages().updateCount();
        OMWriter writer = null;
        try {
            output.write("\r\n".getBytes());
            writer = new OMWriter(output, input);
            writer.write(this);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Deprecated
    public int getPageCount() {
        return this.getNumberOfPages();
    }

    @Override
    public int getNumberOfPages() {
        SMDocumentCatalog cat = this.getDocumentCatalog();
        return (int)cat.getPages().getCount();
    }

    @Override
    @Deprecated
    public PageFormat getPageFormat(int pageIndex) {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            return new SMPageable(this, printerJob).getPageFormat(pageIndex);
        }
        catch (PrinterException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Printable getPrintable(int pageIndex) {
        return (Printable)this.getDocumentCatalog().getAllPages().get(pageIndex);
    }

    public void print(PrinterJob printJob) throws PrinterException {
        this.print(printJob, false);
    }

    public void print() throws PrinterException {
        this.print(PrinterJob.getPrinterJob());
    }

    public void silentPrint() throws PrinterException {
        this.silentPrint(PrinterJob.getPrinterJob());
    }

    public void silentPrint(PrinterJob printJob) throws PrinterException {
        this.print(printJob, true);
    }

    private void print(PrinterJob job, boolean silent) throws PrinterException {
        if (job == null) {
            throw new PrinterException("The given printer job is null.");
        }
        job.setPageable(new SMPageable(this, job));
        if (silent || job.printDialog()) {
            job.print();
        }
    }

    public void close() throws IOException {
        this.document.close();
    }

    public void protect(ProtectionPolicy pp) throws BadSecurityHandlerException {
        SecurityHandler handler;
        this.securityHandler = handler = SecurityHandlersManager.getInstance().getSecurityHandler(pp);
    }

    public void openProtection(DecryptionMaterial pm) throws BadSecurityHandlerException, IOException, CryptographyException, PlpdfException, NoSuchAlgorithmException {
        SMEncryptionDictionary dict = this.getEncryptionDictionary();
        if (dict.getFilter() == null) {
            throw new PlpdfException(CLASS_NAME, "NoNeedToDecrypt");
        }
        this.securityHandler = SecurityHandlersManager.getInstance().getSecurityHandler(dict.getFilter());
        this.securityHandler.decryptDocument(this, pm);
        this.document.dereferenceObjectStreams();
        this.document.setEncryptionDictionary(null);
        this.securityHandler = null;
    }

    public AccessPermission getCurrentAccessPermission() {
        if (this.securityHandler == null) {
            return AccessPermission.getOwnerAccessPermission();
        }
        return this.securityHandler.getCurrentAccessPermission();
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public boolean setSecurityHandler(SecurityHandler secHandler) {
        if (this.securityHandler == null) {
            this.securityHandler = secHandler;
            return true;
        }
        return false;
    }

    public boolean isAllSecurityToBeRemoved() {
        return this.allSecurityToBeRemoved;
    }

    public void setAllSecurityToBeRemoved(boolean removeAllSecurity) {
        this.allSecurityToBeRemoved = removeAllSecurity;
    }

    public void setVersion(float versionValue) {
        this.document.setVersion(versionValue);
        this.document.setHeaderString(PDF_HEADER + Float.toString(versionValue));
    }

    public static SMDocument load15(InputStream input, String password) throws Exception {
        SMDocument doc = SMDocument.load(input, null);
        if (doc.isEncrypted()) {
            doc.decrypt(password);
        }
        if (doc.getDocument().getVersion() < 1.5f) {
            doc.setVersion(1.5f);
        }
        return doc;
    }

    public static SMDocument load15(InputStream input) throws Exception {
        return SMDocument.load15(input, null);
    }

    public static SMDocument load(byte[] input) throws Exception {
        return SMDocument.load((InputStream)new ByteArrayInputStream(input), null);
    }

    public void save(byte[] output) throws Exception {
        OutputStream pdfOutputStream = null;
        this.save(pdfOutputStream);
        output = ((ByteArrayOutputStream)pdfOutputStream).toByteArray();
    }

    public void addLayer(SMOptionalContentGroup layer, boolean addorder) throws IOException, PlpdfException {
        SMOptionalContentProperties ocp = this.getDocumentCatalog().getOCProperties();
        ocp.addLayer(layer, addorder);
    }

    public void addLayer(SMOptionalContentGroup layer, boolean addorder, boolean state) throws IOException, PlpdfException {
        SMOptionalContentProperties ocp = this.getDocumentCatalog().getOCProperties();
        ocp.addLayer(layer, addorder, state);
    }

    public void CopyResourcesIntoPage() throws IOException, PlpdfException {
        SMDocumentCatalog smdc = this.getDocumentCatalog();
        try {
            List pages = smdc.getAllPages();
            for (SMPage page : pages) {
                SMResources res = page.getResources();
                if (res != null || (res = page.findResources()) == null) continue;
                page.setResources(res);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addProducer(String addproducer) throws IOException, PlpdfException {
        SMDocumentInformation info = this.getDocumentInformation();
        String producer = info.getProducer();
        info.setProducer(String.valueOf(producer) + addproducer);
        this.setDocumentInformation(info);
    }
}

