/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.persistence.util;

import com.plpdf.om.OMObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMObjectKey
implements Comparable<OMObjectKey> {
    private long number;
    private long generation;

    public OMObjectKey(OMObject object) {
        this(object.getObjectNumber().longValue(), object.getGenerationNumber().longValue());
    }

    public OMObjectKey(long num, long gen) {
        this.setNumber(num);
        this.setGeneration(gen);
    }

    public boolean equals(Object obj) {
        return obj instanceof OMObjectKey && ((OMObjectKey)obj).getNumber() == this.getNumber() && ((OMObjectKey)obj).getGeneration() == this.getGeneration();
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getNumber() {
        return this.number;
    }

    public int hashCode() {
        return (int)(this.number + this.generation);
    }

    public void setGeneration(long newGeneration) {
        this.generation = newGeneration;
    }

    public void setNumber(long newNumber) {
        this.number = newNumber;
    }

    public String toString() {
        return this.getNumber() + " " + this.getGeneration() + " R";
    }

    @Override
    public int compareTo(OMObjectKey other) {
        if (this.getNumber() < other.getNumber()) {
            return -1;
        }
        if (this.getNumber() > other.getNumber()) {
            return 1;
        }
        if (this.getGeneration() < other.getGeneration()) {
            return -1;
        }
        if (this.getGeneration() > other.getGeneration()) {
            return 1;
        }
        return 0;
    }
}

