/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfwriter;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.exceptions.SignatureException;
import com.plpdf.om.IOMVisitor;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMBoolean;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNull;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.pdfparser.PDFXRefStream;
import com.plpdf.pdfwriter.OMFilterInputStream;
import com.plpdf.pdfwriter.OMStandardOutputStream;
import com.plpdf.pdfwriter.OMWriterXRefEntry;
import com.plpdf.persistence.util.OMObjectKey;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.encryption.SecurityHandler;
import com.plpdf.smmodel.interactive.digitalsignature.SignatureInterface;
import com.plpdf.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMWriter
implements IOMVisitor {
    public static final byte[] DICT_OPEN = StringUtil.getBytes("<<");
    public static final byte[] DICT_CLOSE = StringUtil.getBytes(">>");
    public static final byte[] SPACE = StringUtil.getBytes(" ");
    public static final byte[] COMMENT = StringUtil.getBytes("%");
    public static final byte[] VERSION = StringUtil.getBytes("PDF-1.4");
    public static final byte[] GARBAGE = new byte[]{-10, -28, -4, -33};
    public static final byte[] EOF = StringUtil.getBytes("%%EOF");
    public static final byte[] REFERENCE = StringUtil.getBytes("R");
    public static final byte[] XREF = StringUtil.getBytes("xref");
    public static final byte[] XREF_FREE = StringUtil.getBytes("f");
    public static final byte[] XREF_USED = StringUtil.getBytes("n");
    public static final byte[] TRAILER = StringUtil.getBytes("trailer");
    public static final byte[] STARTXREF = StringUtil.getBytes("startxref");
    public static final byte[] OBJ = StringUtil.getBytes("obj");
    public static final byte[] ENDOBJ = StringUtil.getBytes("endobj");
    public static final byte[] ARRAY_OPEN = StringUtil.getBytes("[");
    public static final byte[] ARRAY_CLOSE = StringUtil.getBytes("]");
    public static final byte[] STREAM = StringUtil.getBytes("stream");
    public static final byte[] ENDSTREAM = StringUtil.getBytes("endstream");
    private NumberFormat formatXrefOffset = new DecimalFormat("0000000000");
    private NumberFormat formatXrefGeneration = new DecimalFormat("00000");
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private OutputStream output;
    private OMStandardOutputStream standardOutput;
    private long startxref = 0L;
    private long number = 0L;
    private Map<OMBase, OMObjectKey> objectKeys = new Hashtable<OMBase, OMObjectKey>();
    private Map<OMObjectKey, OMBase> keyObject = new Hashtable<OMObjectKey, OMBase>();
    private List<OMWriterXRefEntry> xRefEntries = new ArrayList<OMWriterXRefEntry>();
    private HashSet<OMBase> objectsToWriteSet = new HashSet();
    private LinkedList<OMBase> objectsToWrite = new LinkedList();
    private Set<OMBase> writtenObjects = new HashSet<OMBase>();
    private Set<OMBase> actualsAdded = new HashSet<OMBase>();
    private OMObjectKey currentObjectKey = null;
    private SMDocument document = null;
    private boolean willEncrypt = false;
    private boolean incrementalUpdate = false;
    private boolean reachedSignature = false;
    private int[] signaturePosition = new int[2];
    private int[] byterangePosition = new int[2];
    private FileInputStream in;

    public OMWriter(OutputStream os) {
        this.setOutput(os);
        this.setStandardOutput(new OMStandardOutputStream(this.output));
        this.formatDecimal.setMaximumFractionDigits(10);
        this.formatDecimal.setGroupingUsed(false);
    }

    public OMWriter(OutputStream os, FileInputStream is) {
        this(os);
        this.in = is;
        this.incrementalUpdate = true;
    }

    private void prepareIncrement(SMDocument doc) {
        try {
            if (doc != null) {
                OMDocument cosDoc = doc.getDocument();
                Map<OMObjectKey, Long> xrefTable = cosDoc.getXrefTable();
                Set<OMObjectKey> keySet = xrefTable.keySet();
                long highestNumber = 0L;
                for (OMObjectKey cosObjectKey : keySet) {
                    long num;
                    OMBase object = cosDoc.getObjectFromPool(cosObjectKey).getObject();
                    if (object != null && cosObjectKey != null && !(object instanceof OMNumber)) {
                        this.objectKeys.put(object, cosObjectKey);
                        this.keyObject.put(cosObjectKey, object);
                    }
                    if ((num = cosObjectKey.getNumber()) <= highestNumber) continue;
                    highestNumber = num;
                }
                this.setNumber(highestNumber);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void addXRefEntry(OMWriterXRefEntry entry) {
        this.getXRefEntries().add(entry);
    }

    public void close() throws IOException {
        if (this.getStandardOutput() != null) {
            this.getStandardOutput().close();
        }
        if (this.getOutput() != null) {
            this.getOutput().close();
        }
    }

    protected long getNumber() {
        return this.number;
    }

    public Map<OMBase, OMObjectKey> getObjectKeys() {
        return this.objectKeys;
    }

    protected OutputStream getOutput() {
        return this.output;
    }

    protected OMStandardOutputStream getStandardOutput() {
        return this.standardOutput;
    }

    protected long getStartxref() {
        return this.startxref;
    }

    protected List<OMWriterXRefEntry> getXRefEntries() {
        return this.xRefEntries;
    }

    protected void setNumber(long newNumber) {
        this.number = newNumber;
    }

    private void setOutput(OutputStream newOutput) {
        this.output = newOutput;
    }

    private void setStandardOutput(OMStandardOutputStream newStandardOutput) {
        this.standardOutput = newStandardOutput;
    }

    protected void setStartxref(long newStartxref) {
        this.startxref = newStartxref;
    }

    protected void doWriteBody(OMDocument doc) throws IOException, OMVisitorException {
        OMBase nextObject;
        OMDictionary trailer = doc.getTrailer();
        OMDictionary root = (OMDictionary)trailer.getDictionaryObject(OMName.ROOT);
        OMDictionary info = (OMDictionary)trailer.getDictionaryObject(OMName.INFO);
        OMDictionary encrypt = (OMDictionary)trailer.getDictionaryObject(OMName.ENCRYPT);
        if (root != null) {
            this.addObjectToWrite(root);
        }
        if (info != null) {
            this.addObjectToWrite(info);
        }
        while (this.objectsToWrite.size() > 0) {
            nextObject = this.objectsToWrite.removeFirst();
            this.objectsToWriteSet.remove(nextObject);
            this.doWriteObject(nextObject);
        }
        this.willEncrypt = false;
        if (encrypt != null) {
            this.addObjectToWrite(encrypt);
        }
        while (this.objectsToWrite.size() > 0) {
            nextObject = this.objectsToWrite.removeFirst();
            this.objectsToWriteSet.remove(nextObject);
            this.doWriteObject(nextObject);
        }
    }

    private void addObjectToWrite(OMBase object) {
        OMBase actual = object;
        if (actual instanceof OMObject) {
            actual = ((OMObject)actual).getObject();
        }
        if (!(this.writtenObjects.contains(object) || this.objectsToWriteSet.contains(object) || this.actualsAdded.contains(actual))) {
            OMBase OMBase2 = null;
            OMObjectKey cosObjectKey = null;
            if (actual != null) {
                cosObjectKey = this.objectKeys.get(actual);
            }
            if (cosObjectKey != null) {
                OMBase2 = this.keyObject.get(cosObjectKey);
            }
            if (actual != null && this.objectKeys.containsKey(actual) && !object.isNeedToBeUpdate() && OMBase2 != null && !OMBase2.isNeedToBeUpdate()) {
                return;
            }
            this.objectsToWrite.add(object);
            this.objectsToWriteSet.add(object);
            if (actual != null) {
                this.actualsAdded.add(actual);
            }
        }
    }

    public void doWriteObject(OMBase obj) throws OMVisitorException {
        try {
            OMName item;
            OMDictionary dict22;
            OMBase item_;
            this.writtenObjects.add(obj);
            if (obj instanceof OMDictionary && (item_ = (dict22 = (OMDictionary)obj).getItem(OMName.TYPE)) instanceof OMName && (OMName.SIG.equals(item = (OMName)item_) || OMName.DOC_TIME_STAMP.equals(item))) {
                this.reachedSignature = true;
            }
            this.currentObjectKey = this.getObjectKey(obj);
            this.addXRefEntry(new OMWriterXRefEntry(this.getStandardOutput().getPos(), obj, this.currentObjectKey));
            this.getStandardOutput().write(String.valueOf(this.currentObjectKey.getNumber()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(String.valueOf(this.currentObjectKey.getGeneration()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(OBJ);
            this.getStandardOutput().writeEOL();
            try {
                obj.accept(this);
            }
            catch (Exception dict22) {
                // empty catch block
            }
            this.getStandardOutput().writeEOL();
            this.getStandardOutput().write(ENDOBJ);
            this.getStandardOutput().writeEOL();
        }
        catch (IOException e) {
            throw new OMVisitorException(e);
        }
    }

    protected void doWriteHeader(OMDocument doc) throws IOException {
        this.getStandardOutput().write(doc.getHeaderString().getBytes("ISO-8859-1"));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(COMMENT);
        this.getStandardOutput().write(GARBAGE);
        this.getStandardOutput().writeEOL();
    }

    protected void doWriteTrailer(OMDocument doc) throws IOException, OMVisitorException {
        this.getStandardOutput().write(TRAILER);
        this.getStandardOutput().writeEOL();
        OMDictionary trailer = doc.getTrailer();
        Collections.sort(this.getXRefEntries());
        OMWriterXRefEntry lastEntry = this.getXRefEntries().get(this.getXRefEntries().size() - 1);
        trailer.setInt(OMName.SIZE, (int)lastEntry.getKey().getNumber() + 1);
        if (!this.incrementalUpdate) {
            trailer.removeItem(OMName.PREV);
        }
        trailer.removeItem(OMName.DOC_CHECKSUM);
        trailer.accept(this);
    }

    protected void doWriteXRef(OMDocument doc) throws IOException {
        if (doc.isXRefStream()) {
            Collections.sort(this.getXRefEntries());
            OMWriterXRefEntry lastEntry = this.getXRefEntries().get(this.getXRefEntries().size() - 1);
            this.setStartxref(this.getStandardOutput().getPos());
            this.getStandardOutput().write(XREF);
            this.getStandardOutput().writeEOL();
            this.writeXrefRange(0L, lastEntry.getKey().getNumber() + 1L);
            this.writeXrefEntry(OMWriterXRefEntry.getNullEntry());
            long lastObjectNumber = 0L;
            for (OMWriterXRefEntry entry : this.getXRefEntries()) {
                while (lastObjectNumber < entry.getKey().getNumber() - 1L) {
                    this.writeXrefEntry(OMWriterXRefEntry.getNullEntry());
                    ++lastObjectNumber;
                }
                lastObjectNumber = entry.getKey().getNumber();
                this.writeXrefEntry(entry);
            }
        } else {
            OMDictionary trailer = doc.getTrailer();
            trailer.setLong(OMName.PREV, doc.getStartXref());
            this.addXRefEntry(OMWriterXRefEntry.getNullEntry());
            Collections.sort(this.getXRefEntries());
            this.setStartxref(this.getStandardOutput().getPos());
            this.getStandardOutput().write(XREF);
            this.getStandardOutput().writeEOL();
            Integer[] xRefRanges = this.getXRefRanges(this.getXRefEntries());
            int xRefLength = xRefRanges.length;
            int x = 0;
            int j = 0;
            while (x < xRefLength && xRefLength % 2 == 0) {
                this.writeXrefRange(xRefRanges[x].intValue(), xRefRanges[x + 1].intValue());
                int i = 0;
                while (i < xRefRanges[x + 1]) {
                    this.writeXrefEntry(this.xRefEntries.get(j++));
                    ++i;
                }
                x += 2;
            }
        }
    }

    private void doWriteXRefInc(OMDocument doc, long hybridPrev) throws IOException, OMVisitorException {
        if (doc.isXRefStream() || hybridPrev != -1L) {
            PDFXRefStream pdfxRefStream = new PDFXRefStream();
            List<OMWriterXRefEntry> xRefEntries2 = this.getXRefEntries();
            for (OMWriterXRefEntry cosWriterXRefEntry : xRefEntries2) {
                pdfxRefStream.addEntry(cosWriterXRefEntry);
            }
            OMDictionary trailer = doc.getTrailer();
            trailer.setLong(OMName.PREV, doc.getStartXref());
            pdfxRefStream.addTrailerInfo(trailer);
            pdfxRefStream.setSize(this.getNumber() + 2L);
            this.setStartxref(this.getStandardOutput().getPos());
            OMStream stream2 = pdfxRefStream.getStream();
            this.doWriteObject(stream2);
        }
        if (!doc.isXRefStream() || hybridPrev != -1L) {
            OMDictionary trailer = doc.getTrailer();
            trailer.setLong(OMName.PREV, doc.getStartXref());
            if (hybridPrev != -1L) {
                OMName xrefStm = OMName.XREF_STM;
                trailer.removeItem(xrefStm);
                trailer.setLong(xrefStm, this.getStartxref());
            }
            this.addXRefEntry(OMWriterXRefEntry.getNullEntry());
            Collections.sort(this.getXRefEntries());
            this.setStartxref(this.getStandardOutput().getPos());
            this.getStandardOutput().write(XREF);
            this.getStandardOutput().writeEOL();
            Integer[] xRefRanges = this.getXRefRanges(this.getXRefEntries());
            int xRefLength = xRefRanges.length;
            int x = 0;
            int j = 0;
            while (x < xRefLength && xRefLength % 2 == 0) {
                this.writeXrefRange(xRefRanges[x].intValue(), xRefRanges[x + 1].intValue());
                int i = 0;
                while (i < xRefRanges[x + 1]) {
                    this.writeXrefEntry(this.xRefEntries.get(j++));
                    ++i;
                }
                x += 2;
            }
        }
    }

    private void doWriteSignature(OMDocument doc) throws IOException, SignatureException {
        if (this.signaturePosition[0] > 0 && this.byterangePosition[1] > 0) {
            int left = (int)this.getStandardOutput().getPos() - this.signaturePosition[1];
            String newByteRange = "0 " + this.signaturePosition[0] + " " + this.signaturePosition[1] + " " + left + "]";
            int leftByterange = this.byterangePosition[1] - this.byterangePosition[0] - newByteRange.length();
            if (leftByterange < 0) {
                throw new IOException("Can't write new ByteRange, not enough space");
            }
            this.getStandardOutput().setPos(this.byterangePosition[0]);
            this.getStandardOutput().write(newByteRange.getBytes());
            int i = 0;
            while (i < leftByterange) {
                this.getStandardOutput().write(32);
                ++i;
            }
            this.getStandardOutput().setPos(0L);
            int[] nArray = new int[4];
            nArray[1] = this.signaturePosition[0];
            nArray[2] = this.signaturePosition[1];
            nArray[3] = left;
            OMFilterInputStream filterInputStream = new OMFilterInputStream(this.in, nArray);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try {
                int c;
                byte[] buffer = new byte[1024];
                while ((c = ((InputStream)filterInputStream).read(buffer)) != -1) {
                    bytes.write(buffer, 0, c);
                }
            }
            finally {
                if (filterInputStream != null) {
                    ((InputStream)filterInputStream).close();
                }
            }
            byte[] pdfContent = bytes.toByteArray();
            SignatureInterface signatureInterface = doc.getSignatureInterface();
            byte[] sign = signatureInterface.sign(new ByteArrayInputStream(pdfContent));
            String signature = new OMString(sign).getHexString();
            int leftSignaturerange = this.signaturePosition[1] - this.signaturePosition[0] - signature.length();
            if (leftSignaturerange < 0) {
                throw new IOException("Can't write signature, not enough space");
            }
            this.getStandardOutput().setPos(this.signaturePosition[0] + 1);
            this.getStandardOutput().write(signature.getBytes());
        }
    }

    private void writeXrefRange(long x, long y) throws IOException {
        this.getStandardOutput().write(String.valueOf(x).getBytes());
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(y).getBytes());
        this.getStandardOutput().writeEOL();
    }

    private void writeXrefEntry(OMWriterXRefEntry entry) throws IOException {
        String offset = this.formatXrefOffset.format(entry.getOffset());
        String generation = this.formatXrefGeneration.format(entry.getKey().getGeneration());
        this.getStandardOutput().write(offset.getBytes("ISO-8859-1"));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(generation.getBytes("ISO-8859-1"));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(entry.isFree() ? XREF_FREE : XREF_USED);
        this.getStandardOutput().writeCRLF();
    }

    protected Integer[] getXRefRanges(List<OMWriterXRefEntry> xRefEntriesList) {
        int nr = 0;
        int last = -2;
        int count = 1;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (OMWriterXRefEntry object : xRefEntriesList) {
            nr = (int)object.getKey().getNumber();
            if (nr == last + 1) {
                ++count;
                last = nr;
                continue;
            }
            if (last == -2) {
                last = nr;
                continue;
            }
            list.add(last - count + 1);
            list.add(count);
            last = nr;
            count = 1;
        }
        if (xRefEntriesList.size() > 0) {
            list.add(last - count + 1);
            list.add(count);
        }
        return list.toArray(new Integer[list.size()]);
    }

    private OMObjectKey getObjectKey(OMBase obj) {
        OMBase actual = obj;
        if (actual instanceof OMObject) {
            actual = ((OMObject)obj).getObject();
        }
        OMObjectKey key = null;
        if (actual != null) {
            key = this.objectKeys.get(actual);
        }
        if (key == null) {
            key = this.objectKeys.get(obj);
        }
        if (key == null) {
            this.setNumber(this.getNumber() + 1L);
            key = new OMObjectKey(this.getNumber(), 0L);
            this.objectKeys.put(obj, key);
            if (actual != null) {
                this.objectKeys.put(actual, key);
            }
        }
        return key;
    }

    @Override
    public Object visitFromArray(OMArray obj) throws OMVisitorException {
        try {
            int count = 0;
            this.getStandardOutput().write(ARRAY_OPEN);
            Iterator<OMBase> i = obj.iterator();
            while (i.hasNext()) {
                OMBase current = i.next();
                if (current instanceof OMDictionary) {
                    this.addObjectToWrite(current);
                    this.writeReference(current);
                } else if (current instanceof OMObject) {
                    OMBase subValue = ((OMObject)current).getObject();
                    if (subValue instanceof OMDictionary || subValue == null) {
                        this.addObjectToWrite(current);
                        this.writeReference(current);
                    } else {
                        subValue.accept(this);
                    }
                } else if (current == null) {
                    OMNull.NULL.accept(this);
                } else if (current instanceof OMString) {
                    OMString copy = new OMString(true);
                    copy.append(((OMString)current).getBytes());
                    copy.accept(this);
                } else {
                    current.accept(this);
                }
                ++count;
                if (!i.hasNext()) continue;
                if (count % 10 == 0) {
                    this.getStandardOutput().writeEOL();
                    continue;
                }
                this.getStandardOutput().write(SPACE);
            }
            this.getStandardOutput().write(ARRAY_CLOSE);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (IOException e) {
            throw new OMVisitorException(e);
        }
    }

    @Override
    public Object visitFromBoolean(OMBoolean obj) throws OMVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new OMVisitorException(e);
        }
    }

    @Override
    public Object visitFromDictionary(OMDictionary obj) throws OMVisitorException {
        try {
            this.getStandardOutput().write(DICT_OPEN);
            this.getStandardOutput().writeEOL();
            for (Map.Entry<OMName, OMBase> entry : obj.entrySet()) {
                OMBase value = entry.getValue();
                if (value == null) continue;
                entry.getKey().accept(this);
                this.getStandardOutput().write(SPACE);
                if (value instanceof OMDictionary) {
                    OMDictionary dict = (OMDictionary)value;
                    OMBase item = dict.getItem(OMName.XOBJECT);
                    if (item != null) {
                        item.setDirect(true);
                    }
                    if ((item = dict.getItem(OMName.RESOURCES)) != null) {
                        item.setDirect(true);
                    }
                    if (dict.isDirect()) {
                        this.visitFromDictionary(dict);
                    } else {
                        this.addObjectToWrite(dict);
                        this.writeReference(dict);
                    }
                } else if (value instanceof OMObject) {
                    OMBase subValue = ((OMObject)value).getObject();
                    if (subValue instanceof OMDictionary || subValue == null) {
                        this.addObjectToWrite(value);
                        this.writeReference(value);
                    } else if (subValue.isDirect()) {
                        subValue.accept(this);
                    } else {
                        this.addObjectToWrite(subValue);
                        this.writeReference(subValue);
                    }
                } else if (this.reachedSignature && OMName.CONTENTS.equals(entry.getKey())) {
                    this.signaturePosition = new int[2];
                    this.signaturePosition[0] = (int)this.getStandardOutput().getPos();
                    value.accept(this);
                    this.signaturePosition[1] = (int)this.getStandardOutput().getPos();
                } else if (this.reachedSignature && OMName.BYTERANGE.equals(entry.getKey())) {
                    this.byterangePosition = new int[2];
                    this.byterangePosition[0] = (int)this.getStandardOutput().getPos() + 1;
                    value.accept(this);
                    this.byterangePosition[1] = (int)this.getStandardOutput().getPos() - 1;
                    this.reachedSignature = false;
                } else {
                    value.accept(this);
                }
                this.getStandardOutput().writeEOL();
            }
            this.getStandardOutput().write(DICT_CLOSE);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (IOException e) {
            throw new OMVisitorException(e);
        }
    }

    @Override
    public Object visitFromDocument(OMDocument doc) throws OMVisitorException {
        try {
            if (!this.incrementalUpdate) {
                this.doWriteHeader(doc);
            }
            this.doWriteBody(doc);
            OMDictionary trailer = doc.getTrailer();
            long hybridPrev = -1L;
            if (trailer != null) {
                hybridPrev = trailer.getLong(OMName.XREF_STM);
            }
            if (this.incrementalUpdate) {
                this.doWriteXRefInc(doc, hybridPrev);
            } else {
                this.doWriteXRef(doc);
            }
            if (!this.incrementalUpdate || !doc.isXRefStream() || hybridPrev != -1L) {
                this.doWriteTrailer(doc);
            }
            this.getStandardOutput().write(STARTXREF);
            this.getStandardOutput().writeEOL();
            this.getStandardOutput().write(String.valueOf(this.getStartxref()).getBytes("ISO-8859-1"));
            this.getStandardOutput().writeEOL();
            this.getStandardOutput().write(EOF);
            this.getStandardOutput().writeEOL();
            if (this.incrementalUpdate) {
                this.doWriteSignature(doc);
            }
            return null;
        }
        catch (IOException e) {
            throw new OMVisitorException(e);
        }
        catch (SignatureException e) {
            throw new OMVisitorException(e);
        }
    }

    @Override
    public Object visitFromFloat(OMFloat obj) throws OMVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new OMVisitorException(e);
        }
    }

    @Override
    public Object visitFromInt(OMInteger obj) throws OMVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new OMVisitorException(e);
        }
    }

    @Override
    public Object visitFromName(OMName obj) throws OMVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new OMVisitorException(e);
        }
    }

    @Override
    public Object visitFromNull(OMNull obj) throws OMVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new OMVisitorException(e);
        }
    }

    public void writeReference(OMBase obj) throws OMVisitorException {
        try {
            OMObjectKey key = this.getObjectKey(obj);
            this.getStandardOutput().write(String.valueOf(key.getNumber()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(REFERENCE);
        }
        catch (IOException e) {
            throw new OMVisitorException(e);
        }
    }

    @Override
    public Object visitFromStream(OMStream obj) throws OMVisitorException {
        InputStream input = null;
        try {
            if (this.willEncrypt) {
                this.document.getSecurityHandler().encryptStream(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
            }
            Object lengthObject = null;
            OMBase lengthEntry = obj.getDictionaryObject(OMName.LENGTH);
            String type = obj.getNameAsString(OMName.TYPE);
            if (lengthEntry != null && lengthEntry.isDirect() || "XRef".equals(type) || "Metadata".equals(type) || "XObject".equals(type)) {
                OMInteger omInteger = OMInteger.get(obj.getFilteredLength());
                omInteger.setDirect(true);
                obj.setItem(OMName.LENGTH, (OMBase)omInteger);
            }
            input = obj.getFilteredStream();
            this.visitFromDictionary(obj);
            this.getStandardOutput().write(STREAM);
            this.getStandardOutput().writeCRLF();
            byte[] buffer = new byte[1024];
            int amountRead = 0;
            int totalAmountWritten = 0;
            while ((amountRead = input.read(buffer, 0, 1024)) != -1) {
                this.getStandardOutput().write(buffer, 0, amountRead);
                totalAmountWritten += amountRead;
            }
            this.getStandardOutput().writeCRLF();
            this.getStandardOutput().write(ENDSTREAM);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (Exception e) {
            throw new OMVisitorException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new OMVisitorException(e);
                }
            }
        }
    }

    @Override
    public Object visitFromString(OMString obj) throws OMVisitorException {
        try {
            if (this.willEncrypt) {
                this.document.getSecurityHandler().decryptString(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration(), false);
            }
            obj.writePDF(this.getStandardOutput());
        }
        catch (Exception e) {
            throw new OMVisitorException(e);
        }
        return null;
    }

    public void write(OMDocument doc) throws Exception {
        SMDocument pdDoc = new SMDocument(doc);
        this.write(pdDoc);
    }

    public void write(SMDocument doc) throws Exception {
        OMDictionary trailer;
        OMDocument cosDoc;
        this.document = doc;
        if (this.incrementalUpdate) {
            this.prepareIncrement(doc);
        }
        if (doc.isAllSecurityToBeRemoved()) {
            this.willEncrypt = false;
            cosDoc = doc.getDocument();
            trailer = cosDoc.getTrailer();
            trailer.removeItem(OMName.ENCRYPT);
        } else {
            SecurityHandler securityHandler = this.document.getSecurityHandler();
            if (securityHandler != null) {
                try {
                    securityHandler.prepareDocumentForEncryption(this.document);
                    this.willEncrypt = true;
                }
                catch (IOException e) {
                    throw new OMVisitorException(e);
                }
                catch (CryptographyException e) {
                    throw new OMVisitorException(e);
                }
            } else {
                this.willEncrypt = false;
            }
        }
        cosDoc = this.document.getDocument();
        trailer = cosDoc.getTrailer();
        OMArray idArray = (OMArray)trailer.getDictionaryObject(OMName.ID);
        if (idArray == null || this.incrementalUpdate) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(Long.toString(System.currentTimeMillis()).getBytes("ISO-8859-1"));
                OMDictionary info = (OMDictionary)trailer.getDictionaryObject(OMName.INFO);
                if (info != null) {
                    Iterator<OMBase> values = info.getValues().iterator();
                    while (values.hasNext()) {
                        md.update(values.next().toString().getBytes("ISO-8859-1"));
                    }
                }
                idArray = new OMArray();
                OMString id = new OMString(md.digest());
                idArray.add(id);
                idArray.add(id);
                trailer.setItem(OMName.ID, (OMBase)idArray);
            }
            catch (NoSuchAlgorithmException e) {
                throw new OMVisitorException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new OMVisitorException(e);
            }
        }
        cosDoc.accept(this);
    }
}

